/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http.servlet;

import com.sun.grizzly.http.servlet.DispatcherConstants;
import com.sun.grizzly.http.servlet.HttpServletRequestImpl;
import com.sun.grizzly.util.Charsets;
import com.sun.grizzly.util.buf.MessageBytes;
import com.sun.grizzly.util.http.Enumerator;
import com.sun.grizzly.util.http.ParameterMap;
import com.sun.grizzly.util.http.Parameters;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class DispatchedHttpServletRequest
extends HttpServletRequestWrapper {
    private String contextPath;
    private String requestURI;
    private String servletPath;
    private String pathInfo;
    private String queryString;
    private HashMap specialAttributes;
    private DispatcherConstants.DispatcherType dispatcherType;
    private Object requestDispatcherPath;
    private static final HashSet<String> specials = new HashSet(15);
    private final ParameterMap parameterMap = new ParameterMap();
    private final Parameters mergedParameters = new Parameters();
    private boolean parsedParams = false;

    public DispatchedHttpServletRequest(HttpServletRequest request, DispatcherConstants.DispatcherType dispatcherType) {
        super(request);
        this.dispatcherType = dispatcherType;
        this.setRequest(request);
    }

    private void setRequest(HttpServletRequest request) {
        super.setRequest((ServletRequest)request);
        this.requestDispatcherPath = request.getAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH");
        this.contextPath = request.getContextPath();
        this.requestURI = request.getRequestURI();
        this.servletPath = request.getServletPath();
        this.pathInfo = request.getPathInfo();
        this.queryString = request.getQueryString();
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public void setRequestURI(String requestURI) {
        this.requestURI = requestURI;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public void setPathInfo(String pathInfo) {
        this.pathInfo = pathInfo;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public String getParameter(String name) {
        if (!this.parsedParams) {
            this.parseParameters();
        }
        if (System.getSecurityManager() != null) {
            return (String)AccessController.doPrivileged(new GetParameterPrivilegedAction(name));
        }
        return this.mergedParameters.getParameter(name);
    }

    public Enumeration getParameterNames() {
        if (!this.parsedParams) {
            this.parseParameters();
        }
        if (System.getSecurityManager() != null) {
            return new Enumerator((Collection)((Set)AccessController.doPrivileged(new GetParameterNamesPrivilegedAction())));
        }
        return this.mergedParameters.getParameterNames();
    }

    public String[] getParameterValues(String name) {
        String[] ret;
        if (!this.parsedParams) {
            this.parseParameters();
        }
        if (System.getSecurityManager() != null) {
            ret = (String[])AccessController.doPrivileged(new GetParameterValuePrivilegedAction(name));
            if (ret != null) {
                ret = (String[])ret.clone();
            }
        } else {
            ret = this.mergedParameters.getParameterValues(name);
        }
        return ret;
    }

    public Map getParameterMap() {
        if (!this.parsedParams) {
            this.parseParameters();
        }
        if (System.getSecurityManager() != null) {
            return (Map)AccessController.doPrivileged(new GetParameterMapPrivilegedAction());
        }
        return this.getParameterMapInternal();
    }

    private ParameterMap getParameterMapInternal() {
        if (this.parameterMap.isLocked()) {
            return this.parameterMap;
        }
        Enumeration e = this.mergedParameters.getParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String[] values = this.mergedParameters.getParameterValues(name);
            this.parameterMap.put((Object)name, (Object)values);
        }
        this.parameterMap.setLocked(true);
        return this.parameterMap;
    }

    private void parseParameters() {
        Charset charset;
        if (this.parsedParams) {
            return;
        }
        String enc = this.getCharacterEncoding();
        if (enc != null) {
            try {
                charset = Charsets.lookupCharset((String)enc);
            }
            catch (Exception e) {
                charset = Charsets.DEFAULT_CHARSET;
            }
        } else {
            charset = Charsets.DEFAULT_CHARSET;
        }
        this.mergedParameters.setEncoding(charset.toString());
        this.mergedParameters.setQueryStringEncoding(charset.toString());
        MessageBytes queryDC = MessageBytes.newInstance();
        queryDC.setString(this.queryString);
        this.mergedParameters.setQuery(queryDC);
        this.mergedParameters.handleQueryParameters();
        Map paramMap = this.getRequest().getParameterMap();
        for (Map.Entry entry : paramMap.entrySet()) {
            this.mergedParameters.addParameterValues((String)entry.getKey(), (String[])entry.getValue());
        }
        this.parsedParams = true;
    }

    public Object getAttribute(String name) {
        if (name.equals("org.apache.catalina.core.DISPATCHER_REQUEST_PATH")) {
            return this.requestDispatcherPath != null ? this.requestDispatcherPath.toString() : null;
        }
        if (!this.isSpecial(name)) {
            return this.getRequest().getAttribute(name);
        }
        Object value = null;
        if (this.specialAttributes != null) {
            value = this.specialAttributes.get(name);
        }
        if (value == null && name.startsWith("javax.servlet.forward")) {
            value = this.getRequest().getAttribute(name);
        }
        return value;
    }

    public Enumeration getAttributeNames() {
        return new AttributeNamesEnumerator();
    }

    public void setAttribute(String name, Object value) {
        if (name.equals("org.apache.catalina.core.DISPATCHER_REQUEST_PATH")) {
            this.requestDispatcherPath = value;
            return;
        }
        if (this.isSpecial(name)) {
            if (this.specialAttributes != null) {
                this.specialAttributes.put(name, value);
            }
        } else {
            this.getRequest().setAttribute(name, value);
        }
    }

    public void removeAttribute(String name) {
        if (this.isSpecial(name)) {
            if (this.specialAttributes != null) {
                this.specialAttributes.remove(name);
            }
        } else {
            this.getRequest().removeAttribute(name);
        }
    }

    private boolean isSpecial(String name) {
        return specials.contains(name);
    }

    void initSpecialAttributes(String requestUri, String contextPath, String servletPath, String pathInfo, String queryString) {
        this.specialAttributes = new HashMap(5);
        switch (this.dispatcherType) {
            case INCLUDE: {
                this.specialAttributes.put("javax.servlet.include.request_uri", requestUri);
                this.specialAttributes.put("javax.servlet.include.context_path", contextPath);
                this.specialAttributes.put("javax.servlet.include.servlet_path", servletPath);
                this.specialAttributes.put("javax.servlet.include.path_info", pathInfo);
                this.specialAttributes.put("javax.servlet.include.query_string", queryString);
                break;
            }
            case FORWARD: 
            case ERROR: {
                this.specialAttributes.put("javax.servlet.forward.request_uri", requestUri);
                this.specialAttributes.put("javax.servlet.forward.context_path", contextPath);
                this.specialAttributes.put("javax.servlet.forward.servlet_path", servletPath);
                this.specialAttributes.put("javax.servlet.forward.path_info", pathInfo);
                this.specialAttributes.put("javax.servlet.forward.query_string", queryString);
                break;
            }
            case ASYNC: {
                this.specialAttributes.put("javax.servlet.async.request_uri", requestUri);
                this.specialAttributes.put("javax.servlet.async.context_path", contextPath);
                this.specialAttributes.put("javax.servlet.async.servlet_path", servletPath);
                this.specialAttributes.put("javax.servlet.async.path_info", pathInfo);
                this.specialAttributes.put("javax.servlet.async.query_string", queryString);
            }
        }
    }

    public HttpServletRequestImpl getRequestFacade() {
        if (this.getRequest() instanceof HttpServletRequestImpl) {
            return (HttpServletRequestImpl)this.getRequest();
        }
        return ((DispatchedHttpServletRequest)this.getRequest()).getRequestFacade();
    }

    public void recycle() {
        this.parameterMap.setLocked(false);
        this.parameterMap.clear();
    }

    static {
        specials.add("javax.servlet.include.request_uri");
        specials.add("javax.servlet.include.context_path");
        specials.add("javax.servlet.include.servlet_path");
        specials.add("javax.servlet.include.path_info");
        specials.add("javax.servlet.include.query_string");
        specials.add("javax.servlet.forward.request_uri");
        specials.add("javax.servlet.forward.context_path");
        specials.add("javax.servlet.forward.servlet_path");
        specials.add("javax.servlet.forward.path_info");
        specials.add("javax.servlet.forward.query_string");
        specials.add("javax.servlet.async.request_uri");
        specials.add("javax.servlet.async.context_path");
        specials.add("javax.servlet.async.servlet_path");
        specials.add("javax.servlet.async.path_info");
        specials.add("javax.servlet.async.query_string");
    }

    private final class GetParameterMapPrivilegedAction
    implements PrivilegedAction {
        private GetParameterMapPrivilegedAction() {
        }

        public Object run() {
            return DispatchedHttpServletRequest.this.getParameterMapInternal();
        }
    }

    private final class GetParameterValuePrivilegedAction
    implements PrivilegedAction {
        public final String name;

        public GetParameterValuePrivilegedAction(String name) {
            this.name = name;
        }

        public Object run() {
            return DispatchedHttpServletRequest.this.mergedParameters.getParameterValues(this.name);
        }
    }

    private final class GetParameterNamesPrivilegedAction
    implements PrivilegedAction {
        private GetParameterNamesPrivilegedAction() {
        }

        public Object run() {
            return DispatchedHttpServletRequest.this.mergedParameters.getParameterNames();
        }
    }

    private final class GetParameterPrivilegedAction
    implements PrivilegedAction {
        public final String name;

        public GetParameterPrivilegedAction(String name) {
            this.name = name;
        }

        public Object run() {
            return DispatchedHttpServletRequest.this.mergedParameters.getParameter(this.name);
        }
    }

    private final class AttributeNamesEnumerator
    implements Enumeration {
        protected Enumeration<String> parentEnumeration = null;
        protected String next = null;
        private Iterator<String> specialNames = null;

        public AttributeNamesEnumerator() {
            this.parentEnumeration = DispatchedHttpServletRequest.this.getRequest().getAttributeNames();
            if (DispatchedHttpServletRequest.this.specialAttributes != null) {
                this.specialNames = DispatchedHttpServletRequest.this.specialAttributes.keySet().iterator();
            }
        }

        public boolean hasMoreElements() {
            return this.specialNames != null && this.specialNames.hasNext() || this.next != null || (this.next = this.findNext()) != null;
        }

        public Object nextElement() {
            if (this.specialNames != null && this.specialNames.hasNext()) {
                return this.specialNames.next();
            }
            String result = this.next;
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.next = this.findNext();
            return result;
        }

        protected String findNext() {
            String result = null;
            while (result == null && this.parentEnumeration.hasMoreElements()) {
                String current = this.parentEnumeration.nextElement();
                if (DispatchedHttpServletRequest.this.isSpecial(current) && (DispatchedHttpServletRequest.this.dispatcherType.equals((Object)DispatcherConstants.DispatcherType.FORWARD) || !current.startsWith("javax.servlet.forward") || DispatchedHttpServletRequest.this.getAttribute(current) == null)) continue;
                result = current;
            }
            return result;
        }
    }
}

