/*
 * Decompiled with CFR 0.152.
 */
package com.sun.facelets.tag.jsf;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.el.LegacyValueBinding;
import com.sun.facelets.tag.MetaRule;
import com.sun.facelets.tag.Metadata;
import com.sun.facelets.tag.MetadataTarget;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.util.FacesAPI;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.el.ValueBinding;

final class ComponentRule
extends MetaRule {
    private static final Logger log = Logger.getLogger("facelets.tag.component");
    public static final ComponentRule Instance = new ComponentRule();

    public Metadata applyRule(String name, TagAttribute attribute, MetadataTarget meta) {
        if (meta.isTargetInstanceOf(UIComponent.class)) {
            if (!attribute.isLiteral()) {
                Class type = meta.getPropertyType(name);
                if (type == null) {
                    Class clazz = type = Object.class;
                }
                if (FacesAPI.getComponentVersion(meta.getTargetClass()) >= 12) {
                    return new ValueExpressionMetadata(name, type, attribute);
                }
                return new ValueBindingMetadata(name, type, attribute);
            }
            if (meta.getWriteMethod(name) == null) {
                ComponentRule.warnAttr(attribute, meta.getTargetClass(), name);
                return new LiteralAttributeMetadata(name, attribute.getValue());
            }
        }
        return null;
    }

    private static void warnAttr(TagAttribute attr, Class type, String n) {
        if (log.isLoggable(Level.WARNING)) {
            log.warning(attr + " Property '" + n + "' is not on type: " + type.getName());
        }
    }

    static final class ValueBindingMetadata
    extends Metadata {
        private final String name;
        private final TagAttribute attr;
        private final Class type;

        public ValueBindingMetadata(String name, Class type, TagAttribute attr) {
            this.name = name;
            this.attr = attr;
            this.type = type;
        }

        public void applyMetadata(FaceletContext ctx, Object instance) {
            ((UIComponent)instance).setValueBinding(this.name, (ValueBinding)new LegacyValueBinding(this.attr.getValueExpression(ctx, this.type)));
        }
    }

    static final class ValueExpressionMetadata
    extends Metadata {
        private final String name;
        private final TagAttribute attr;
        private final Class type;

        public ValueExpressionMetadata(String name, Class type, TagAttribute attr) {
            this.name = name;
            this.attr = attr;
            this.type = type;
        }

        public void applyMetadata(FaceletContext ctx, Object instance) {
            ((UIComponent)instance).setValueExpression(this.name, this.attr.getValueExpression(ctx, this.type));
        }
    }

    final class LiteralAttributeMetadata
    extends Metadata {
        private final String name;
        private final String value;

        public LiteralAttributeMetadata(String name, String value) {
            this.value = value;
            this.name = name;
        }

        public void applyMetadata(FaceletContext ctx, Object instance) {
            ((UIComponent)instance).getAttributes().put(this.name, this.value);
        }
    }
}

