/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import oracle.jdbc.driver.InternalFactory;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.internal.XSSecureId;

final class XSSecureIdI
extends XSSecureId {
    byte[] kpxssidpmac = null;
    byte[] kpxssidpmtid = null;
    long kpxssidpnonce = 0L;

    XSSecureIdI() {
    }

    @Override
    public void setMac(byte[] kpxssidpmac) throws SQLException {
        InternalFactory.xsSecurityCheck();
        this.kpxssidpmac = (byte[])(kpxssidpmac == null ? null : Arrays.copyOf(kpxssidpmac, kpxssidpmac.length));
    }

    @Override
    public void setMidtierId(byte[] kpxssidpmtid) throws SQLException {
        InternalFactory.xsSecurityCheck();
        this.kpxssidpmtid = (byte[])(kpxssidpmtid == null ? null : Arrays.copyOf(kpxssidpmtid, kpxssidpmtid.length));
    }

    @Override
    public void setNonce(long kpxssidpnonce) throws SQLException {
        InternalFactory.xsSecurityCheck();
        this.kpxssidpnonce = kpxssidpnonce;
    }

    @Override
    public byte[] getMac() {
        InternalFactory.xsSecurityCheck();
        if (this.kpxssidpmac == null) {
            return null;
        }
        return Arrays.copyOf(this.kpxssidpmac, this.kpxssidpmac.length);
    }

    @Override
    public byte[] getMidtierId() {
        InternalFactory.xsSecurityCheck();
        if (this.kpxssidpmtid == null) {
            return null;
        }
        return Arrays.copyOf(this.kpxssidpmtid, this.kpxssidpmtid.length);
    }

    @Override
    public long getNonce() {
        InternalFactory.xsSecurityCheck();
        return this.kpxssidpnonce;
    }

    void marshal(T4CMAREngine mar) throws IOException {
        if (this.kpxssidpmac != null) {
            mar.marshalUB4(this.kpxssidpmac.length);
            mar.marshalCLR(this.kpxssidpmac, this.kpxssidpmac.length);
        } else {
            mar.marshalUB4(0L);
        }
        if (this.kpxssidpmtid != null) {
            mar.marshalUB4(this.kpxssidpmtid.length);
            mar.marshalCLR(this.kpxssidpmtid, this.kpxssidpmtid.length);
        } else {
            mar.marshalUB4(0L);
        }
        mar.marshalUB4(this.kpxssidpnonce);
    }

    static XSSecureIdI unmarshal(T4CMAREngine mar) throws SQLException, IOException {
        int kpxssidpmtidLength;
        byte[] kpxssidpmac = null;
        byte[] kpxssidpmtid = null;
        long kpxssidpnonce = 0L;
        int kpxssidpmacLength = (int)mar.unmarshalUB4();
        if (kpxssidpmacLength > 0) {
            kpxssidpmac = mar.unmarshalNBytes(kpxssidpmacLength);
        }
        if ((kpxssidpmtidLength = (int)mar.unmarshalUB4()) > 0) {
            kpxssidpmtid = mar.unmarshalNBytes(kpxssidpmtidLength);
        }
        kpxssidpnonce = mar.unmarshalUB4();
        XSSecureIdI secid = new XSSecureIdI();
        secid.setMac(kpxssidpmac);
        secid.setMidtierId(kpxssidpmtid);
        secid.setNonce(kpxssidpnonce);
        return secid;
    }
}

