/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.FixedSortKeyDefinition;
import net.sf.saxon.sort.SortedIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.Value;

class SortedTupleIterator
extends SortedIterator {
    public SortedTupleIterator(XPathContext xPathContext, SequenceIterator sequenceIterator, FixedSortKeyDefinition[] fixedSortKeyDefinitionArray) throws XPathException {
        super(xPathContext, sequenceIterator, fixedSortKeyDefinitionArray);
        this.setHostLanguage(51);
    }

    protected void buildArray() throws XPathException {
        ObjectValue objectValue;
        int n = 100;
        this.nodeKeys = new Object[n * this.recordSize];
        this.count = 0;
        while ((objectValue = (ObjectValue)this.base.next()) != null) {
            Value[] valueArray = (Value[])objectValue.getObject();
            if (this.count == n) {
                Object[] objectArray = new Object[(n *= 2) * this.recordSize];
                System.arraycopy(this.nodeKeys, 0, objectArray, 0, this.count * this.recordSize);
                this.nodeKeys = objectArray;
            }
            int n2 = this.count * this.recordSize;
            this.nodeKeys[n2] = new ObjectValue(valueArray[0]);
            for (int i = 1; i <= this.sortkeys.length; ++i) {
                Value value = valueArray[i].reduce();
                this.nodeKeys[n2 + i] = value instanceof EmptySequence ? null : value;
            }
            this.nodeKeys[n2 + this.sortkeys.length + 1] = new Integer(this.count);
            ++this.count;
        }
    }
}

