/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.index.LinkedCursor;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.TableLink;
import org.h2.util.StatementBuilder;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class LinkedIndex
extends BaseIndex {
    private TableLink link;
    private String targetTableName;
    private long rowCount;

    public LinkedIndex(TableLink tableLink, int n, IndexColumn[] indexColumnArray, IndexType indexType) {
        this.initBaseIndex(tableLink, n, null, indexColumnArray, indexType);
        this.link = tableLink;
        this.targetTableName = this.link.getQualifiedTable();
    }

    public String getCreateSQL() {
        return null;
    }

    public void close(Session session) {
    }

    private boolean isNull(Value value) {
        return value == null || value == ValueNull.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Session session, Row row) throws SQLException {
        Object object;
        StatementBuilder statementBuilder = new StatementBuilder("INSERT INTO ");
        statementBuilder.append(this.targetTableName).append(" VALUES(");
        for (int i = 0; i < row.getColumnCount(); ++i) {
            object = row.getValue(i);
            statementBuilder.appendExceptFirst(", ");
            if (object == null) {
                statementBuilder.append("DEFAULT");
                continue;
            }
            if (this.isNull((Value)object)) {
                statementBuilder.append("NULL");
                continue;
            }
            statementBuilder.append('?');
        }
        statementBuilder.append(')');
        String string = statementBuilder.toString();
        object = this.link.getConnection();
        synchronized (object) {
            try {
                PreparedStatement preparedStatement = this.link.getPreparedStatement(string, false);
                int n = 0;
                for (int i = 0; i < row.getColumnCount(); ++i) {
                    Value value = row.getValue(i);
                    if (value == null || value == ValueNull.INSTANCE) continue;
                    value.set(preparedStatement, n + 1);
                    ++n;
                }
                preparedStatement.executeUpdate();
                ++this.rowCount;
            }
            catch (SQLException sQLException) {
                throw this.link.wrapException(string, sQLException);
            }
        }
    }

    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) throws SQLException {
        Object object;
        Object object2;
        int n;
        StatementBuilder statementBuilder = new StatementBuilder("SELECT * FROM ");
        statementBuilder.append(this.targetTableName).append(" T");
        for (n = 0; searchRow != null && n < searchRow.getColumnCount(); ++n) {
            object2 = searchRow.getValue(n);
            if (object2 == null) continue;
            statementBuilder.appendOnlyFirst(" WHERE ");
            statementBuilder.appendExceptFirst(" AND ");
            object = this.table.getColumn(n);
            statementBuilder.append(((Column)object).getSQL()).append(">=");
            this.addParameter(statementBuilder, (Column)object);
        }
        for (n = 0; searchRow2 != null && n < searchRow2.getColumnCount(); ++n) {
            object2 = searchRow2.getValue(n);
            if (object2 == null) continue;
            statementBuilder.appendOnlyFirst(" WHERE ");
            statementBuilder.appendExceptFirst(" AND ");
            object = this.table.getColumn(n);
            statementBuilder.append(((Column)object).getSQL()).append("<=");
            this.addParameter(statementBuilder, (Column)object);
        }
        String string = statementBuilder.toString();
        object2 = this.link.getConnection();
        synchronized (object2) {
            try {
                Value value;
                int n2;
                object = this.link.getPreparedStatement(string, true);
                int n3 = 0;
                for (n2 = 0; searchRow != null && n2 < searchRow.getColumnCount(); ++n2) {
                    value = searchRow.getValue(n2);
                    if (value == null) continue;
                    value.set((PreparedStatement)object, n3 + 1);
                    ++n3;
                }
                for (n2 = 0; searchRow2 != null && n2 < searchRow2.getColumnCount(); ++n2) {
                    value = searchRow2.getValue(n2);
                    if (value == null) continue;
                    value.set((PreparedStatement)object, n3 + 1);
                    ++n3;
                }
                ResultSet resultSet = object.executeQuery();
                return new LinkedCursor(this.link, resultSet, session, string, (PreparedStatement)object);
            }
            catch (SQLException sQLException) {
                throw this.link.wrapException(string, sQLException);
            }
        }
    }

    private void addParameter(StatementBuilder statementBuilder, Column column) {
        if (column.getType() == 21 && this.link.isOracle()) {
            statementBuilder.append("CAST(? AS CHAR(").append(column.getPrecision()).append("))");
        } else {
            statementBuilder.append('?');
        }
    }

    public double getCost(Session session, int[] nArray) {
        return 100L + this.getCostRangeIndex(nArray, this.rowCount + 1000L);
    }

    public void remove(Session session) {
    }

    public void truncate(Session session) {
    }

    public void checkRename() throws SQLException {
        throw Message.getUnsupportedException("LINKED");
    }

    public boolean needRebuild() {
        return false;
    }

    public boolean canGetFirstOrLast() {
        return false;
    }

    public Cursor findFirstOrLast(Session session, boolean bl) throws SQLException {
        throw Message.getUnsupportedException("LINKED");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Session session, Row row) throws SQLException {
        Object object;
        Object object2;
        StatementBuilder statementBuilder = new StatementBuilder("DELETE FROM ");
        statementBuilder.append(this.targetTableName).append(" WHERE ");
        for (int i = 0; i < row.getColumnCount(); ++i) {
            statementBuilder.appendExceptFirst("AND ");
            object2 = this.table.getColumn(i);
            statementBuilder.append(((Column)object2).getSQL());
            object = row.getValue(i);
            if (this.isNull((Value)object)) {
                statementBuilder.append(" IS NULL ");
                continue;
            }
            statementBuilder.append('=');
            this.addParameter(statementBuilder, (Column)object2);
            statementBuilder.append(' ');
        }
        String string = statementBuilder.toString();
        object2 = this.link.getConnection();
        synchronized (object2) {
            try {
                int n;
                object = this.link.getPreparedStatement(string, false);
                int n2 = 0;
                for (n = 0; n < row.getColumnCount(); ++n) {
                    Value value = row.getValue(n);
                    if (this.isNull(value)) continue;
                    value.set((PreparedStatement)object, n2 + 1);
                    ++n2;
                }
                n = object.executeUpdate();
                this.rowCount -= (long)n;
            }
            catch (SQLException sQLException) {
                throw this.link.wrapException(string, sQLException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Row row, Row row2) throws SQLException {
        Object object;
        int n;
        StatementBuilder statementBuilder = new StatementBuilder("UPDATE ");
        statementBuilder.append(this.targetTableName).append(" SET ");
        for (n = 0; n < row2.getColumnCount(); ++n) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(this.table.getColumn(n).getSQL()).append('=');
            object = row2.getValue(n);
            if (object == null) {
                statementBuilder.append("DEFAULT");
                continue;
            }
            statementBuilder.append('?');
        }
        statementBuilder.append(" WHERE ");
        statementBuilder.resetCount();
        for (n = 0; n < row.getColumnCount(); ++n) {
            object = this.table.getColumn(n);
            statementBuilder.appendExceptFirst(" AND ");
            statementBuilder.append(((Column)object).getSQL());
            Value value = row.getValue(n);
            if (this.isNull(value)) {
                statementBuilder.append(" IS NULL");
                continue;
            }
            statementBuilder.append('=');
            this.addParameter(statementBuilder, (Column)object);
        }
        String string = statementBuilder.toString();
        object = this.link.getConnection();
        synchronized (object) {
            try {
                Value value;
                int n2;
                int n3 = 1;
                PreparedStatement preparedStatement = this.link.getPreparedStatement(string, false);
                for (n2 = 0; n2 < row2.getColumnCount(); ++n2) {
                    value = row2.getValue(n2);
                    if (value == null) continue;
                    value.set(preparedStatement, n3);
                    ++n3;
                }
                for (n2 = 0; n2 < row.getColumnCount(); ++n2) {
                    value = row.getValue(n2);
                    if (this.isNull(value)) continue;
                    value.set(preparedStatement, n3);
                    ++n3;
                }
                n2 = preparedStatement.executeUpdate();
                this.rowCount = this.rowCount + (long)n2 - (long)n2;
            }
            catch (SQLException sQLException) {
                throw this.link.wrapException(string, sQLException);
            }
        }
    }

    public long getRowCount(Session session) {
        return this.rowCount;
    }

    public long getRowCountApproximation() {
        return this.rowCount;
    }
}

