/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.gui;

import java.util.ArrayList;
import java.util.Iterator;
import org.webharvest.gui.BreakpointInfo;

public class BreakpointCollection
extends ArrayList {
    public int addBreakpoint(BreakpointInfo breakpointInfo) {
        if (breakpointInfo != null) {
            int lineNumber = breakpointInfo.getLineNumber();
            int size = this.size();
            for (int i = 0; i < size; ++i) {
                BreakpointInfo breakpoint = (BreakpointInfo)this.get(i);
                int currLineNumber = breakpoint.getLineNumber();
                if (currLineNumber == lineNumber) {
                    return -1;
                }
                if (currLineNumber <= lineNumber) continue;
                this.add(i, breakpointInfo);
                return i;
            }
            this.add(breakpointInfo);
            return size;
        }
        return -1;
    }

    public void removeBreakpoint(int lineNumber) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            BreakpointInfo breakpoint = (BreakpointInfo)this.get(i);
            int currLineNumber = breakpoint.getLineNumber();
            if (currLineNumber == lineNumber) {
                this.remove(i);
                return;
            }
            if (currLineNumber <= lineNumber) continue;
            return;
        }
    }

    public void removeBreakpointsInRange(int from, int to) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            BreakpointInfo breakpoint = (BreakpointInfo)iterator.next();
            int currLineNumber = breakpoint.getLineNumber();
            if (currLineNumber >= from && currLineNumber <= to) {
                iterator.remove();
                continue;
            }
            if (currLineNumber <= to) continue;
            return;
        }
    }

    public void updateBreakpoints(int from, int amount) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            BreakpointInfo breakpoint = (BreakpointInfo)this.get(i);
            int currLineNumber = breakpoint.getLineNumber();
            if (currLineNumber < from) continue;
            breakpoint.updateForAmount(amount);
        }
    }

    public boolean isThereBreakpoint(int lineNumber) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            BreakpointInfo breakpoint = (BreakpointInfo)this.get(i);
            int currLineNumber = breakpoint.getLineNumber();
            if (currLineNumber == lineNumber) {
                return true;
            }
            if (currLineNumber <= lineNumber) continue;
            return false;
        }
        return false;
    }
}

