/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.solr.analysis.BufferedTokenStream;
import org.apache.solr.util.ArraysUtils;

public class RemoveDuplicatesTokenFilter
extends BufferedTokenStream {
    public RemoveDuplicatesTokenFilter(TokenStream input) {
        super(input);
    }

    protected Token process(Token t) throws IOException {
        Token tok = this.read();
        while (tok != null && tok.getPositionIncrement() == 0) {
            if (null != t) {
                this.write(t);
                t = null;
            }
            boolean dup = false;
            for (Token outTok : this.output()) {
                int tokLen = tok.termLength();
                if (outTok.termLength() != tokLen || !ArraysUtils.equals(outTok.termBuffer(), 0, tok.termBuffer(), 0, tokLen)) continue;
                dup = true;
            }
            if (!dup) {
                this.write(tok);
            }
            tok = this.read();
        }
        if (tok != null) {
            this.pushBack(tok);
        }
        return t;
    }
}

