/*
 * #%L
 * Vradi :: Services
 * 
 * $Id: FileServiceImpl.java 1817 2010-12-01 17:20:15Z sletellier $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.5.1/vradi-services/src/main/java/com/jurismarches/vradi/services/FileServiceImpl.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package com.jurismarches.vradi.services;

import java.io.File;
import java.io.IOException;

import com.jurismarches.vradi.VradiServiceConfiguration;
import com.jurismarches.vradi.VradiServiceConfigurationHelper;
import org.apache.commons.io.FileUtils;
import org.nuiton.util.ApplicationConfig;

/**
 * File service impl.
 * 
 * @author chatellier
 * @version $Revision: 1817 $
 * 
 * Last update : $Date: 2010-12-01 18:20:15 +0100 (mer., 01 déc. 2010) $
 * By : $Author: sletellier $
 */
public class FileServiceImpl implements FileService {

    protected ApplicationConfig config;

    public FileServiceImpl() {
        this(VradiServiceConfiguration.getInstance());
    }
    
    public FileServiceImpl(ApplicationConfig config) {
        this.config = config;
    }

    @Override
    public String uploadTemplate(File file, String extensionName) throws VradiException {
        
        String fileuri;

        try {
            File templatesDir = VradiServiceConfigurationHelper.getTemplatesDir(config);
            File templateDir = new File(templatesDir, extensionName);
            templateDir.mkdirs();

            File copyOfTemplate = new File(templateDir, file.getName());
            FileUtils.copyFile(file, copyOfTemplate);
            fileuri = copyOfTemplate.getName();
        }
        catch (IOException ex) {
            throw new VradiException("Can't copy file", ex);
        }

        return fileuri;
    }

    @Override
    public File downloadTemplate(String extensionName, String templateName) {
        File templateFile = null;
        if (templateName != null){
            File templatesDir = VradiServiceConfigurationHelper.getTemplatesDir(config);
            File templateDir = new File(templatesDir, extensionName);
            templateFile = new File(templateDir, templateName);
        }
        return templateFile;
    }

    @Override
    public File downloadTemplate(boolean convertUrl, String extensionName, String templateName) throws VradiException {
        return downloadTemplate(extensionName, templateName);
    }

    @Override
    public String uploadWebHarvestScript(File file) throws VradiException {

        String fileuri;

        try {
            File scriptsDir = VradiServiceConfigurationHelper.getWebHarvestScriptDir(config);
            File scriptFile = new File(scriptsDir, file.getName());
            FileUtils.copyFile(file, scriptFile);
            fileuri = scriptFile.getName();
        }
        catch (IOException ex) {
            throw new VradiException("Can't copy file", ex);
        }

        return fileuri;
    }

    @Override
    public File downloadWebHarvestScript(String uri) {
        File scriptsDir = VradiServiceConfigurationHelper.getWebHarvestScriptDir(config);
        File scriptFile = new File(scriptsDir, uri);
        return scriptFile;
    }

    @Override
    public File downloadWebHarvestScript(boolean convertUrl, String uri) {
        return downloadWebHarvestScript(uri);
    }

    @Override
    public File downloadPDF(String uri) {
        File pdfDir = VradiServiceConfigurationHelper.getPdfDir(config);
        File pdfFile = new File(pdfDir, uri);
        return pdfFile;
    }

    @Override
    public File downloadPDF(boolean convertUrl, String uri) {
        return downloadPDF(uri);
    }

    @Override
    public String getPDFUrl(String uri) throws VradiException {
        File pdfDir = VradiServiceConfigurationHelper.getPdfDir(config);
        File pdfFile = new File(pdfDir, uri);
        return pdfFile.toURI().toString();
    }

    @Override
    public String uploadFormAttachment(File file, String formId) throws VradiException {
        
        String fileuri;

        try {
            File attachementsDir = VradiServiceConfigurationHelper.getAttachmentsDir(config);
            File attachementDir = new File(attachementsDir, formId);
            attachementDir.mkdirs();

            File copyOfFormAttachement = new File(attachementDir, file.getName());
            FileUtils.copyFile(file, copyOfFormAttachement);
            fileuri = copyOfFormAttachement.getName();
        }
        catch (IOException ex) {
            throw new VradiException("Can't copy file", ex);
        }

        return fileuri;
    }

    @Override
    public String uploadTempFile(File file) throws VradiException {

        String fileURI;

        try {
            File tempDir = VradiServiceConfigurationHelper.getTempDir(config);
            tempDir.mkdirs();

            File copyOfTempFile = new File(tempDir, file.getName());
            FileUtils.copyFile(file, copyOfTempFile);
            fileURI = "file://" + copyOfTempFile.getAbsolutePath();
        }
        catch (IOException ex) {
            throw new VradiException("Can't copy file", ex);
        }

        return fileURI;
    }

    @Override
    public File downloadFormAttachment(String uri) {
        File attachmentDir = VradiServiceConfigurationHelper.getAttachmentsDir(config);
        File attachmentFile = new File(attachmentDir, uri);
        return attachmentFile;
    }

    @Override
    public File downloadFormAttachment(String fileName, String formId) {
        return downloadFormAttachment(formId + File.separator + fileName);
    }

    @Override
    public File downloadFormAttachment(boolean convertUrl, String fileName, String formId) {
        return downloadFormAttachment(fileName, formId);
    }

    @Override
    public String uploadFormEmbeddedFile(File file, String formId) throws VradiException {
        
        String fileuri;

        try {
            File embeddedsDir = VradiServiceConfigurationHelper.getEmbeddedFilesDir(config);
            File embeddedDir = new File(embeddedsDir, formId);
            embeddedDir.mkdirs();

            File copyOfEmbeddedFile = new File(embeddedDir, file.getName());
            FileUtils.copyFile(file, copyOfEmbeddedFile);
            fileuri = copyOfEmbeddedFile.getName();
        }
        catch (IOException ex) {
            throw new VradiException("Can't copy file", ex);
        }

        return fileuri;
    }

    @Override
    public File downloadFormEmbeddedFile(String uri) {
        File parentDir = VradiServiceConfigurationHelper.getEmbeddedFilesDir(config);
        File toDownloadFile = new File(parentDir, uri);
        return toDownloadFile;
    }

    @Override
    public File downloadFormEmbeddedFile(String fileName, String formId) {
        return downloadFormEmbeddedFile(formId + File.separator + fileName);
    }

    @Override
    public File downloadFormEmbeddedFile(boolean convertUrl, String fileName, String formId) {
        return downloadFormEmbeddedFile(fileName, formId);
    }

    @Override
    public String getFormEmbeddedUrl(String fileName, String formId) throws VradiException {
        File parentDir = VradiServiceConfigurationHelper.getEmbeddedFilesDir(config);
        File toDownloadFile = new File(parentDir, formId + File.separator + fileName);
        return toDownloadFile.toURI().toString();
    }

    @Override
    public File downloadRequestHistory(String uri) throws VradiException {
        File parentDir = VradiServiceConfigurationHelper.getQueryHistoryDir(config);
        File toDownloadFile = new File(parentDir, uri);
        return toDownloadFile;
    }

    @Override
    public File downloadRequestHistory(boolean convertUrl, String uri) throws VradiException {
        return downloadRequestHistory(uri);
    }

    @Override
    public String getRequestHistoryURL(String uri) throws VradiException {
        File parentDir = VradiServiceConfigurationHelper.getQueryHistoryDir(config);
        File toDownloadFile = new File(parentDir, uri);
        return toDownloadFile.toURI().toString();
    }
}
