/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.utils.props;

import java.io.InputStream;
import java.util.Properties;

public abstract class PropertyLoader {
    private static final boolean THROW_ON_LOAD_FAILURE = true;
    private static final String SUFFIX = ".ccf";
    private static final String SUFFIX_PROPERTIES = ".properties";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(String name, ClassLoader loader) {
        boolean isCCFSuffix = true;
        if (name == null) {
            throw new IllegalArgumentException("null input: name");
        }
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if (name.endsWith(SUFFIX)) {
            name = name.substring(0, name.length() - SUFFIX.length());
        }
        if (name.endsWith(SUFFIX_PROPERTIES)) {
            name = name.substring(0, name.length() - SUFFIX_PROPERTIES.length());
            isCCFSuffix = false;
        }
        Properties result = null;
        InputStream in = null;
        try {
            if (loader == null) {
                loader = ClassLoader.getSystemClassLoader();
            }
            if (!(name = name.replace('.', '/')).endsWith(SUFFIX) && isCCFSuffix) {
                name = name.concat(SUFFIX);
            } else if (!name.endsWith(SUFFIX_PROPERTIES) && !isCCFSuffix) {
                name = name.concat(SUFFIX_PROPERTIES);
            }
            in = loader.getResourceAsStream(name);
            if (in != null) {
                result = new Properties();
                result.load(in);
            }
        }
        catch (Exception e) {
            result = null;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Throwable ignore) {}
            }
        }
        if (result == null) {
            throw new IllegalArgumentException("could not load [" + name + "]" + " as " + "a classloader resource");
        }
        return result;
    }

    public static Properties loadProperties(String name) {
        return PropertyLoader.loadProperties(name, Thread.currentThread().getContextClassLoader());
    }

    private PropertyLoader() {
    }
}

