/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.protocols.urp;

import com.sun.star.lib.uno.environments.remote.ThreadId;
import com.sun.star.lib.uno.typedesc.TypeDescription;
import com.sun.star.uno.Any;
import com.sun.star.uno.Enum;
import com.sun.star.uno.IBridge;
import com.sun.star.uno.IFieldDescription;
import com.sun.star.uno.ITypeDescription;
import com.sun.star.uno.Type;
import com.sun.star.uno.TypeClass;
import com.sun.star.uno.XInterface;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;

final class Unmarshal {
    private final IBridge bridge;
    private final String[] objectIdCache;
    private final ThreadId[] threadIdCache;
    private final TypeDescription[] typeCache;
    private DataInputStream input;

    public Unmarshal(IBridge iBridge, int n) {
        this.bridge = iBridge;
        this.objectIdCache = new String[n];
        this.threadIdCache = new ThreadId[n];
        this.typeCache = new TypeDescription[n];
        this.reset(new byte[0]);
    }

    public int read8Bit() {
        try {
            return this.input.readUnsignedByte();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    public int read16Bit() {
        try {
            return this.input.readUnsignedShort();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    public String readObjectId() {
        String string = this.readStringValue();
        int n = this.read16Bit();
        if (n == 65535) {
            if (string.length() == 0) {
                string = null;
            }
        } else if (string.length() == 0) {
            string = this.objectIdCache[n];
        } else {
            this.objectIdCache[n] = string;
        }
        return string;
    }

    public Object readInterface(Type type) {
        String string = this.readObjectId();
        return string == null ? null : this.bridge.mapInterfaceFrom((Object)string, type);
    }

    public ThreadId readThreadId() {
        int n;
        int n2 = this.readCompressedNumber();
        byte[] byArray = null;
        ThreadId threadId = null;
        if (n2 != 0) {
            byArray = new byte[n2];
            this.readBytes(byArray);
            threadId = new ThreadId(byArray);
        }
        if ((n = this.read16Bit()) != 65535) {
            if (n2 == 0) {
                threadId = this.threadIdCache[n];
            } else {
                this.threadIdCache[n] = threadId;
            }
        }
        return threadId;
    }

    public TypeDescription readType() {
        int n = this.read8Bit();
        TypeClass typeClass = TypeClass.fromInt((int)(n & 0x7F));
        if (TypeDescription.isTypeClassSimple((TypeClass)typeClass)) {
            return TypeDescription.getTypeDescription((TypeClass)typeClass);
        }
        int n2 = this.read16Bit();
        TypeDescription typeDescription = null;
        if ((n & 0x80) != 0) {
            try {
                typeDescription = TypeDescription.getTypeDescription((String)this.readStringValue());
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException(classNotFoundException.toString());
            }
        }
        if (n2 != 65535) {
            if ((n & 0x80) == 0) {
                typeDescription = this.typeCache[n2];
            } else {
                this.typeCache[n2] = typeDescription;
            }
        }
        return typeDescription;
    }

    public Object readValue(TypeDescription typeDescription) {
        switch (typeDescription.getTypeClass().getValue()) {
            case 0: {
                return null;
            }
            case 2: {
                return this.readBooleanValue();
            }
            case 3: {
                return this.readByteValue();
            }
            case 4: 
            case 5: {
                return this.readShortValue();
            }
            case 6: 
            case 7: {
                return this.readLongValue();
            }
            case 8: 
            case 9: {
                return this.readHyperValue();
            }
            case 10: {
                return this.readFloatValue();
            }
            case 11: {
                return this.readDoubleValue();
            }
            case 1: {
                return this.readCharValue();
            }
            case 12: {
                return this.readStringValue();
            }
            case 13: {
                return this.readTypeValue();
            }
            case 14: {
                return this.readAnyValue();
            }
            case 20: {
                return this.readSequenceValue(typeDescription);
            }
            case 15: {
                return this.readEnumValue(typeDescription);
            }
            case 17: {
                return this.readStructValue(typeDescription);
            }
            case 19: {
                return this.readExceptionValue(typeDescription);
            }
            case 22: {
                return this.readInterfaceValue(typeDescription);
            }
        }
        throw new IllegalArgumentException("Bad type descriptor " + typeDescription);
    }

    public boolean hasMore() {
        try {
            return this.input.available() > 0;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    public void reset(byte[] byArray) {
        this.input = new DataInputStream(new ByteArrayInputStream(byArray));
    }

    private Boolean readBooleanValue() {
        try {
            return this.input.readBoolean() ? Boolean.TRUE : Boolean.FALSE;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    private Byte readByteValue() {
        try {
            return new Byte(this.input.readByte());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    private Short readShortValue() {
        try {
            return new Short(this.input.readShort());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    private Integer readLongValue() {
        try {
            return new Integer(this.input.readInt());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    private Long readHyperValue() {
        try {
            return new Long(this.input.readLong());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    private Float readFloatValue() {
        try {
            return new Float(this.input.readFloat());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    private Double readDoubleValue() {
        try {
            return new Double(this.input.readDouble());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    private Character readCharValue() {
        try {
            return new Character(this.input.readChar());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    private String readStringValue() {
        int n = this.readCompressedNumber();
        byte[] byArray = new byte[n];
        this.readBytes(byArray);
        try {
            return new String(byArray, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException.toString());
        }
    }

    private Type readTypeValue() {
        return new Type((ITypeDescription)this.readType());
    }

    private Object readAnyValue() {
        TypeDescription typeDescription = this.readType();
        switch (typeDescription.getTypeClass().getValue()) {
            case 0: {
                return Any.VOID;
            }
            case 2: {
                return this.readBooleanValue();
            }
            case 3: {
                return this.readByteValue();
            }
            case 4: {
                return this.readShortValue();
            }
            case 5: {
                return new Any(Type.UNSIGNED_SHORT, (Object)this.readShortValue());
            }
            case 6: {
                return this.readLongValue();
            }
            case 7: {
                return new Any(Type.UNSIGNED_LONG, (Object)this.readLongValue());
            }
            case 8: {
                return this.readHyperValue();
            }
            case 9: {
                return new Any(Type.UNSIGNED_HYPER, (Object)this.readHyperValue());
            }
            case 10: {
                return this.readFloatValue();
            }
            case 11: {
                return this.readDoubleValue();
            }
            case 1: {
                return this.readCharValue();
            }
            case 12: {
                return this.readStringValue();
            }
            case 13: {
                return this.readTypeValue();
            }
            case 20: {
                Object object = this.readSequenceValue(typeDescription);
                TypeDescription typeDescription2 = (TypeDescription)typeDescription.getComponentType();
                while (typeDescription2.getTypeClass() == TypeClass.SEQUENCE) {
                    typeDescription2 = (TypeDescription)typeDescription2.getComponentType();
                }
                switch (typeDescription2.getTypeClass().getValue()) {
                    case 5: 
                    case 7: 
                    case 9: {
                        return new Any(new Type((ITypeDescription)typeDescription), object);
                    }
                    case 17: {
                        if (!typeDescription2.hasTypeArguments()) break;
                        return new Any(new Type((ITypeDescription)typeDescription), object);
                    }
                }
                return object;
            }
            case 15: {
                return this.readEnumValue(typeDescription);
            }
            case 17: {
                Object object = this.readStructValue(typeDescription);
                return typeDescription.hasTypeArguments() ? new Any(new Type((ITypeDescription)typeDescription), object) : object;
            }
            case 19: {
                return this.readExceptionValue(typeDescription);
            }
            case 22: {
                Object object = this.readInterfaceValue(typeDescription);
                return typeDescription.getZClass() == XInterface.class ? object : new Any(new Type((ITypeDescription)typeDescription), object);
            }
        }
        throw new RuntimeException("Reading ANY with bad type " + typeDescription.getTypeClass());
    }

    private Object readSequenceValue(TypeDescription typeDescription) {
        int n = this.readCompressedNumber();
        TypeDescription typeDescription2 = (TypeDescription)typeDescription.getComponentType();
        if (typeDescription2.getTypeClass() == TypeClass.BYTE) {
            byte[] byArray = new byte[n];
            this.readBytes(byArray);
            return byArray;
        }
        Object object = Array.newInstance(typeDescription2.getTypeClass() == TypeClass.ANY ? Object.class : typeDescription2.getZClass(), n);
        for (int i = 0; i < n; ++i) {
            Array.set(object, i, this.readValue(typeDescription2));
        }
        return object;
    }

    private Enum readEnumValue(TypeDescription typeDescription) {
        try {
            return (Enum)typeDescription.getZClass().getMethod("fromInt", Integer.TYPE).invoke(null, this.readLongValue());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException.toString());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException.toString());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException.toString());
        }
    }

    private Object readStructValue(TypeDescription typeDescription) {
        Object t;
        try {
            t = typeDescription.getZClass().newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(instantiationException.toString());
        }
        this.readFields(typeDescription, t);
        return t;
    }

    private Exception readExceptionValue(TypeDescription typeDescription) {
        Exception exception;
        try {
            exception = (Exception)typeDescription.getZClass().getConstructor(String.class).newInstance(this.readStringValue());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(instantiationException.toString());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException.toString());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException.toString());
        }
        this.readFields(typeDescription, exception);
        return exception;
    }

    private Object readInterfaceValue(TypeDescription typeDescription) {
        return this.readInterface(new Type((ITypeDescription)typeDescription));
    }

    private int readCompressedNumber() {
        int n = this.read8Bit();
        try {
            return n < 255 ? n : this.input.readInt();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    private void readBytes(byte[] byArray) {
        try {
            this.input.readFully(byArray);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    private void readFields(TypeDescription typeDescription, Object object) {
        IFieldDescription[] iFieldDescriptionArray = typeDescription.getFieldDescriptions();
        for (int i = 0; i < iFieldDescriptionArray.length; ++i) {
            try {
                iFieldDescriptionArray[i].getField().set(object, this.readValue((TypeDescription)iFieldDescriptionArray[i].getTypeDescription()));
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException.toString());
            }
        }
    }
}

