/*
 * #%L
 * Vradi :: Services
 * 
 * $Id: XmlStreamImportResult.java 1493 2010-09-24 09:51:40Z chatellier $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.3.2/vradi-services/src/main/java/com/jurismarches/vradi/beans/XmlStreamImportResult.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package com.jurismarches.vradi.beans;

import java.io.Serializable;

/**
 * Import xml stream results.
 * 
 * Contains :
 * - the number of created forms
 * - the number of already existing forms (non created)
 * - the number of forms created with date parsing error
 * - the number of forms created with number parsing error
 * 
 * @author chatellier
 * @version $Revision: 1493 $
 * 
 * Last update : $Date: 2010-09-24 11:51:40 +0200 (ven., 24 sept. 2010) $
 * By : $Author: chatellier $
 */
public class XmlStreamImportResult implements Serializable {

    /** serialVersionUID. */
    private static final long serialVersionUID = -7378576743532050958L;

    protected int createdFormCount;
    
    protected int alreadyExistsFormCount;
    
    protected int dateParsingError;
    
    protected int numberParsingError;

    public int getCreatedFormCount() {
        return createdFormCount;
    }

    public void setCreatedFormCount(int createdFormCount) {
        this.createdFormCount = createdFormCount;
    }

    public int getAlreadyExistsFormCount() {
        return alreadyExistsFormCount;
    }

    public void setAlreadyExistsFormCount(int alreadyExistsFormCount) {
        this.alreadyExistsFormCount = alreadyExistsFormCount;
    }

    public int getDateParsingError() {
        return dateParsingError;
    }

    public void setDateParsingError(int dateParsingError) {
        this.dateParsingError = dateParsingError;
    }

    public int getNumberParsingError() {
        return numberParsingError;
    }

    public void setNumberParsingError(int numberParsingError) {
        this.numberParsingError = numberParsingError;
    }
}
