/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.common.internal.util.propertyservice;

import com.arjuna.common.internal.util.propertyservice.ConcatenationPrefix;
import com.arjuna.common.internal.util.propertyservice.FullPropertyName;
import com.arjuna.common.internal.util.propertyservice.PropertyPrefix;
import com.arjuna.common.util.propertyservice.PropertiesFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class BeanPopulator {
    private static final ConcurrentMap<Class, Object> singletonBeanInstances = new ConcurrentHashMap<Class, Object>();

    public static <T> T getSingletonInstance(Class<T> beanClass) throws RuntimeException {
        if (!singletonBeanInstances.containsKey(beanClass)) {
            Object bean = null;
            try {
                bean = beanClass.newInstance();
                Properties properties = PropertiesFactory.getDefaultProperties();
                BeanPopulator.configureFromProperties(bean, properties);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            singletonBeanInstances.putIfAbsent(beanClass, bean);
        }
        return (T)singletonBeanInstances.get(beanClass);
    }

    public static void configureFromProperties(Object bean, Properties properties) throws Exception {
        if (!bean.getClass().isAnnotationPresent(PropertyPrefix.class)) {
            throw new Exception("no PropertyPrefix found on " + bean.getClass().getName());
        }
        for (Field field : bean.getClass().getDeclaredFields()) {
            String getterMethodName;
            Class<?> type = field.getType();
            String setterMethodName = "set" + BeanPopulator.capitalizeFirstLetter(field.getName());
            Method setter = bean.getClass().getMethod(setterMethodName, field.getType());
            Method getter = null;
            if (field.getType().equals(Boolean.TYPE)) {
                getterMethodName = "is" + BeanPopulator.capitalizeFirstLetter(field.getName());
                try {
                    getter = bean.getClass().getMethod(getterMethodName, new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
            }
            if (getter == null) {
                getterMethodName = "get" + BeanPopulator.capitalizeFirstLetter(field.getName());
                getter = bean.getClass().getMethod(getterMethodName, new Class[0]);
            }
            if (field.isAnnotationPresent(ConcatenationPrefix.class) || field.getType().getName().startsWith("java.util")) {
                BeanPopulator.handleGroupProperty(bean, properties, field, setter, getter);
                continue;
            }
            BeanPopulator.handleSimpleProperty(bean, properties, field, setter, getter);
        }
    }

    public static String printState() {
        StringBuffer buffer = new StringBuffer();
        for (Object bean : singletonBeanInstances.values()) {
            BeanPopulator.printBean(bean, buffer);
        }
        return buffer.toString();
    }

    private static void handleGroupProperty(Object bean, Properties properties, Field field, Method setter, Method getter) throws Exception {
        LinkedList<String> lines = new LinkedList<String>();
        String valueFromProperties = BeanPopulator.getValueFromProperties(bean, properties, field, bean.getClass().getSimpleName());
        if (valueFromProperties != null) {
            String[] tokens;
            for (String token : tokens = valueFromProperties.split("\\s+")) {
                lines.add(token);
            }
        } else {
            LinkedList<String> listOfMatchingPropertyNames = new LinkedList<String>();
            Enumeration<?> propertyNamesEnumeration = properties.propertyNames();
            ConcatenationPrefix concatenationPrefix = field.getAnnotation(ConcatenationPrefix.class);
            if (propertyNamesEnumeration != null && concatenationPrefix != null) {
                String prefix = concatenationPrefix.prefix();
                while (propertyNamesEnumeration.hasMoreElements()) {
                    String name = (String)propertyNamesEnumeration.nextElement();
                    if (!name.startsWith(prefix)) continue;
                    listOfMatchingPropertyNames.add(name);
                }
            }
            Collections.sort(listOfMatchingPropertyNames);
            for (String name : listOfMatchingPropertyNames) {
                String value = properties.getProperty(name);
                lines.add(value);
            }
        }
        Cloneable replacementValue = null;
        if (Map.class.isAssignableFrom(field.getType())) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (String element : lines) {
                String[] tokens = element.split("=");
                map.put(tokens[0], tokens[1]);
            }
            replacementValue = map;
        } else {
            replacementValue = lines;
        }
        Object valueFromBean = getter.invoke(bean, new Object[0]);
        if (!valueFromBean.equals(replacementValue)) {
            setter.invoke(bean, replacementValue);
        }
    }

    private static void handleSimpleProperty(Object bean, Properties properties, Field field, Method setter, Method getter) throws Exception {
        PropertyPrefix prefixAnnotation = bean.getClass().getAnnotation(PropertyPrefix.class);
        String prefix = prefixAnnotation.prefix();
        String valueFromProperties = BeanPopulator.getValueFromProperties(bean, properties, field, prefix);
        if (valueFromProperties != null) {
            Object valueFromBean = getter.invoke(bean, new Object[0]);
            if (field.getType().equals(Boolean.TYPE)) {
                if (!((Boolean)valueFromBean).booleanValue() && BeanPopulator.isPositive(valueFromProperties)) {
                    setter.invoke(bean, Boolean.TRUE);
                }
                if (((Boolean)valueFromBean).booleanValue() && BeanPopulator.isNegative(valueFromProperties)) {
                    setter.invoke(bean, Boolean.FALSE);
                }
            } else if (field.getType().equals(String.class)) {
                if (!valueFromProperties.equals(valueFromBean)) {
                    setter.invoke(bean, valueFromProperties);
                }
            } else if (field.getType().equals(Long.TYPE)) {
                Long longValue = Long.valueOf(valueFromProperties);
                if (!longValue.equals(valueFromBean)) {
                    setter.invoke(bean, longValue);
                }
            } else if (field.getType().equals(Integer.TYPE)) {
                Integer intValue = Integer.valueOf(valueFromProperties);
                if (!intValue.equals(valueFromBean)) {
                    setter.invoke(bean, intValue);
                }
            } else {
                throw new Exception("unknown field type " + field.getType());
            }
        }
    }

    private static String getValueFromProperties(Object bean, Properties properties, Field field, String prefix) {
        String propertyFileKey;
        String valueFromProperties = null;
        if (valueFromProperties == null) {
            propertyFileKey = bean.getClass().getCanonicalName() + "." + field.getName();
            valueFromProperties = properties.getProperty(propertyFileKey);
        }
        if (valueFromProperties == null) {
            propertyFileKey = bean.getClass().getSimpleName() + "." + field.getName();
            valueFromProperties = properties.getProperty(propertyFileKey);
        }
        if (valueFromProperties == null) {
            propertyFileKey = prefix + field.getName();
            if (field.isAnnotationPresent(FullPropertyName.class)) {
                FullPropertyName fullPropertyName = field.getAnnotation(FullPropertyName.class);
                propertyFileKey = fullPropertyName.name();
            }
            valueFromProperties = properties.getProperty(propertyFileKey);
        }
        return valueFromProperties;
    }

    private static void printBean(Object bean, StringBuffer buffer) {
        String lineSeparator = System.getProperty("line.separator");
        buffer.append("Bean class: ");
        buffer.append(bean.getClass().getCanonicalName());
        buffer.append(lineSeparator);
        for (Field field : bean.getClass().getDeclaredFields()) {
            String getterMethodName;
            Class<?> type = field.getType();
            Method getter = null;
            if (field.getType().equals(Boolean.TYPE)) {
                getterMethodName = "is" + BeanPopulator.capitalizeFirstLetter(field.getName());
                try {
                    getter = bean.getClass().getMethod(getterMethodName, new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
            }
            try {
                if (getter == null) {
                    getterMethodName = "get" + BeanPopulator.capitalizeFirstLetter(field.getName());
                    getter = bean.getClass().getMethod(getterMethodName, new Class[0]);
                }
                Object valueFromBean = getter.invoke(bean, new Object[0]);
                buffer.append("  ");
                buffer.append(field.getName());
                buffer.append(": ");
                buffer.append(valueFromBean);
            }
            catch (Exception e) {
                buffer.append("failed to read property ");
                buffer.append(field.getName());
            }
            buffer.append(lineSeparator);
        }
    }

    private static String capitalizeFirstLetter(String string) {
        return string.length() > 0 ? Character.toUpperCase(string.charAt(0)) + string.substring(1) : string;
    }

    private static boolean isPositive(String value) {
        return "YES".equalsIgnoreCase(value) || "ON".equalsIgnoreCase(value) || "TRUE".equalsIgnoreCase(value);
    }

    private static boolean isNegative(String value) {
        return "NO".equalsIgnoreCase(value) || "OFF".equalsIgnoreCase(value) || "FALSE".equalsIgnoreCase(value);
    }
}

