/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.Stack;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import net.sf.saxon.Controller;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.StartTagBuffer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.style.UseWhenStaticContext;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;

public class UseWhenFilter
extends ProxyReceiver {
    private StartTagBuffer startTag;
    private int useWhenCode;
    private int xslUseWhenCode;
    private int defaultNamespaceCode;
    private int depthOfHole = 0;
    private boolean emptyStylesheetElement = false;
    private Stack defaultNamespaceStack = new Stack();

    public UseWhenFilter(StartTagBuffer startTagBuffer) {
        this.startTag = startTagBuffer;
    }

    public void open() throws XPathException {
        this.useWhenCode = this.getNamePool().allocate("", "", "use-when") & 0xFFFFF;
        this.xslUseWhenCode = this.getNamePool().allocate("xsl", "http://www.w3.org/1999/XSL/Transform", "use-when");
        this.defaultNamespaceCode = this.getNamePool().allocate("", "", "xpath-default-namespace");
        super.open();
    }

    /*
     * Unable to fully structure code
     */
    public void startElement(int var1_1, int var2_2, int var3_3, int var4_4) throws XPathException {
        this.defaultNamespaceStack.push(this.startTag.getAttribute(this.defaultNamespaceCode));
        if (this.emptyStylesheetElement) {
            this.depthOfHole = 1;
        }
        if (this.depthOfHole == 0) {
            var5_5 = (var1_1 & 1048575) < 1024 ? this.startTag.getAttribute(this.useWhenCode) : this.startTag.getAttribute(this.xslUseWhenCode);
            if (var5_5 != null) {
                try {
                    var6_6 = this.evaluateUseWhen(var5_5, this.getDocumentLocator().getLineNumber(var3_3));
                    if (var6_6) ** GOTO lbl33
                    var7_8 = var1_1 & 1048575;
                    if (var7_8 == 180 || var7_8 == 183) {
                        this.emptyStylesheetElement = true;
                    }
                    this.depthOfHole = 1;
                    return;
                }
                catch (XPathException var6_7) {
                    var7_9 = new StaticError("Error in use-when expression. " + var6_7.getMessage());
                    var8_10 = new ExpressionLocation();
                    var8_10.setSystemId(this.getDocumentLocator().getSystemId(var3_3));
                    var8_10.setLineNumber(this.getDocumentLocator().getLineNumber(var3_3));
                    var7_9.setLocator(var8_10);
                    var7_9.setErrorCode(var6_7.getErrorCodeLocalPart());
                    try {
                        this.getPipelineConfiguration().getErrorListener().fatalError(var7_9);
                    }
                    catch (TransformerException var9_11) {
                        throw StaticError.makeStaticError(var9_11);
                    }
                    var7_9.setHasBeenReported();
                    throw var7_9;
                }
            }
        } else {
            ++this.depthOfHole;
        }
lbl33:
        // 4 sources

        super.startElement(var1_1, var2_2, var3_3, var4_4);
    }

    public void namespace(int n, int n2) throws XPathException {
        if (this.depthOfHole == 0) {
            super.namespace(n, n2);
        }
    }

    public void attribute(int n, int n2, CharSequence charSequence, int n3, int n4) throws XPathException {
        if (this.depthOfHole == 0) {
            super.attribute(n, n2, charSequence, n3, n4);
        }
    }

    public void startContent() throws XPathException {
        if (this.depthOfHole == 0) {
            super.startContent();
        }
    }

    public void endElement() throws XPathException {
        this.defaultNamespaceStack.pop();
        if (this.depthOfHole > 0) {
            --this.depthOfHole;
        } else {
            super.endElement();
        }
    }

    public void characters(CharSequence charSequence, int n, int n2) throws XPathException {
        if (this.depthOfHole == 0) {
            super.characters(charSequence, n, n2);
        }
    }

    public void processingInstruction(String string, CharSequence charSequence, int n, int n2) {
    }

    public void comment(CharSequence charSequence, int n, int n2) throws XPathException {
    }

    public boolean evaluateUseWhen(String string, int n) throws XPathException {
        Object object;
        UseWhenStaticContext useWhenStaticContext = new UseWhenStaticContext(this.getConfiguration(), this.startTag);
        useWhenStaticContext.setBaseURI(this.getDocumentLocator().getSystemId(n));
        for (int i = this.defaultNamespaceStack.size() - 1; i >= 0; --i) {
            object = (String)this.defaultNamespaceStack.get(i);
            if (object == null) continue;
            short s = this.getNamePool().getCodeForURI((String)object);
            useWhenStaticContext.setDefaultElementNamespace(s);
            break;
        }
        Expression expression = ExpressionTool.make(string, useWhenStaticContext, 0, 0, this.getDocumentLocator().getLineNumber(n));
        object = Type.ITEM_TYPE;
        expression = expression.typeCheck(useWhenStaticContext, (ItemType)object);
        SlotManager slotManager = this.getPipelineConfiguration().getConfiguration().makeSlotManager();
        ExpressionTool.allocateSlots(expression, slotManager.getNumberOfVariables(), slotManager);
        Controller controller = new Controller(this.getConfiguration());
        controller.setURIResolver(new URIPreventer());
        XPathContextMajor xPathContextMajor = controller.newXPathContext();
        xPathContextMajor = xPathContextMajor.newCleanContext();
        xPathContextMajor.openStackFrame(slotManager.getNumberOfVariables());
        return expression.effectiveBooleanValue(xPathContextMajor);
    }

    private static class URIPreventer
    implements URIResolver {
        private URIPreventer() {
        }

        public Source resolve(String string, String string2) throws TransformerException {
            throw new TransformerException("No external documents are available within an [xsl]use-when expression");
        }
    }
}

