/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.StringValue;

public class StringLength
extends SystemFunction {
    private boolean shortcut = false;

    public Expression simplify(StaticContext staticContext) throws XPathException {
        return this.simplifyArguments(staticContext);
    }

    public int getIntrinsicDependencies() {
        int n = super.getIntrinsicDependencies();
        if (this.argument.length == 0) {
            n |= 2;
        }
        return n;
    }

    public Expression preEvaluate(StaticContext staticContext) throws XPathException {
        if (this.argument.length == 0) {
            return this;
        }
        return ExpressionTool.eagerEvaluate(this, staticContext.makeEarlyEvaluationContext());
    }

    public void setShortcut() {
        this.shortcut = true;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        AtomicValue atomicValue;
        Object object;
        if (this.argument.length == 0) {
            object = xPathContext.getContextItem();
            if (object == null) {
                this.dynamicError("The context item for string-length() is not set", "FONC0001", xPathContext);
            }
            atomicValue = StringValue.makeStringValue(object.getStringValueCS());
        } else {
            atomicValue = (AtomicValue)this.argument[0].evaluateItem(xPathContext);
        }
        if (atomicValue == null) {
            return IntegerValue.ZERO;
        }
        object = atomicValue.getStringValueCS();
        if (this.shortcut) {
            return new IntegerValue(object.length() > 0 ? 1 : 0);
        }
        return new IntegerValue(StringValue.getStringLength((CharSequence)object));
    }
}

