/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.sql.SQLException;
import org.h2.command.ddl.SchemaCommand;
import org.h2.constraint.Constraint;
import org.h2.engine.Session;
import org.h2.message.Message;
import org.h2.schema.Schema;

public class AlterTableDropConstraint
extends SchemaCommand {
    private String constraintName;
    private boolean ifExists;

    public AlterTableDropConstraint(Session session, Schema schema, boolean bl) {
        super(session, schema);
        this.ifExists = bl;
    }

    public void setConstraintName(String string) {
        this.constraintName = string;
    }

    public int update() throws SQLException {
        this.session.commit(true);
        Constraint constraint = this.getSchema().findConstraint(this.session, this.constraintName);
        if (constraint == null) {
            if (!this.ifExists) {
                throw Message.getSQLException(90057, this.constraintName);
            }
        } else {
            this.session.getUser().checkRight(constraint.getTable(), 15);
            this.session.getUser().checkRight(constraint.getRefTable(), 15);
            this.session.getDatabase().removeSchemaObject(this.session, constraint);
        }
        return 0;
    }
}

