/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services.managers;

import com.jurismarches.vradi.VradiConstants;
import com.jurismarches.vradi.VradiServiceConfiguration;
import com.jurismarches.vradi.beans.FormPagedResult;
import com.jurismarches.vradi.beans.QueryBean;
import com.jurismarches.vradi.beans.SendingHelper;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.GroupForms;
import com.jurismarches.vradi.entities.ModificationTag;
import com.jurismarches.vradi.entities.Sending;
import com.jurismarches.vradi.entities.SendingImpl;
import com.jurismarches.vradi.entities.Session;
import com.jurismarches.vradi.entities.SessionImpl;
import com.jurismarches.vradi.entities.Status;
import com.jurismarches.vradi.entities.StatusImpl;
import com.jurismarches.vradi.entities.Thesaurus;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.managers.SearchManager;
import com.jurismarches.vradi.services.managers.ThesaurusManager;
import com.jurismarches.vradi.services.search.UnsupportedQueryException;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.DateUtil;
import org.nuiton.wikitty.BusinessEntity;
import org.nuiton.wikitty.Criteria;
import org.nuiton.wikitty.PagedResult;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.search.Element;
import org.nuiton.wikitty.search.Search;

public class FormManager {
    private static final Log log = LogFactory.getLog(FormManager.class);
    protected WikittyProxy wikittyProxy;
    protected ThesaurusManager thesaurusManager;
    protected SearchManager searchManager;

    public FormManager(WikittyProxy wikittyProxy, ThesaurusManager thesaurusManager, SearchManager searchManager) {
        this.wikittyProxy = wikittyProxy;
        this.thesaurusManager = thesaurusManager;
        this.searchManager = searchManager;
    }

    public List<Form> updateForms(List<Form> forms, Set<String> thesaurus) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"updateForms(forms)");
        }
        if (forms == null || forms.isEmpty()) {
            return forms;
        }
        ArrayList<Thesaurus> entitiesToSave = new ArrayList<Thesaurus>();
        for (Form form : forms) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("updating form: " + form.getId()));
            }
            Date now = new Date();
            if (form.getCreationDate() == null) {
                form.setCreationDate(now);
            } else {
                ModificationTag modificationTag = (ModificationTag)this.wikittyProxy.cast((BusinessEntity)form, ModificationTag.class);
                modificationTag.setLastModified(now);
            }
            if (thesaurus == null) continue;
            List<Thesaurus> attachedThesauruses = this.thesaurusManager.getThesaurusAttachedToForm(form);
            for (Thesaurus attachedThesaurus : attachedThesauruses) {
                attachedThesaurus.removeAttachment(form.getId());
                if (entitiesToSave.contains(attachedThesaurus)) continue;
                entitiesToSave.add(attachedThesaurus);
            }
            for (String thesaurusId : thesaurus) {
                Thesaurus node = this.thesaurusManager.getThesaurus(thesaurusId);
                if (node.getAttachment() != null && node.getAttachment().contains(form.getWikittyId())) continue;
                node.addAttachment(form.getWikittyId());
                if (entitiesToSave.contains(node)) continue;
                entitiesToSave.add(node);
            }
        }
        List result = this.wikittyProxy.store(forms);
        if (!entitiesToSave.isEmpty()) {
            this.wikittyProxy.store(entitiesToSave);
        }
        return result;
    }

    public Session getLastCloseSession() {
        Search search = Search.query().eq(Element.ELT_EXTENSION, "Session");
        search.eq("Session.status", String.valueOf(VradiConstants.SessionStatus.SENT.getValue())).criteria();
        Criteria criteria = search.criteria();
        criteria.addSortDescending("Session.sessionDate");
        PagedResult result = this.wikittyProxy.findAllByCriteria(Session.class, criteria);
        if (result == null || result.size() == 0) {
            return null;
        }
        return (Session)result.getFirst();
    }

    public Session getLastOpenSession() throws VradiException {
        Session lastClose = this.getLastCloseSession();
        String formatedLastCloseDate = null;
        if (lastClose != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Last closed session : " + lastClose.getSessionDate()));
            }
            try {
                formatedLastCloseDate = WikittyUtil.formatDate((Date)lastClose.getSessionDate());
            }
            catch (ParseException e) {
                log.error((Object)"Cant parse date");
            }
        }
        Search search = Search.query().eq(Element.ELT_EXTENSION, "Session");
        if (formatedLastCloseDate != null) {
            search.ge("Session.sessionDate", formatedLastCloseDate);
        }
        search.or().eq("Session.status", String.valueOf(VradiConstants.SessionStatus.ACTIVE.getValue())).eq("Session.status", String.valueOf(VradiConstants.SessionStatus.STOPPED.getValue())).eq("Session.status", String.valueOf(VradiConstants.SessionStatus.ERROR.getValue()));
        Criteria criteria = search.criteria();
        criteria.addSortDescending("Session.sessionDate");
        PagedResult result = this.wikittyProxy.findAllByCriteria(Session.class, criteria);
        Session session = null;
        if (result != null && result.size() > 0) {
            session = (Session)result.getFirst();
        }
        if (log.isDebugEnabled() && session != null) {
            log.debug((Object)("Last sessions found : " + session.getWikittyId() + " - " + session.getSessionDate() + " with status : " + session.getStatus()));
        }
        return session;
    }

    public List<Session> getSessions(Date sessionDate) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getSessions for date " + sessionDate.toString()));
        }
        Search search = Search.query().eq(Element.ELT_EXTENSION, "Session");
        search.bw("Session.sessionDate", FormManager.getBeginOfDaySolrDate(sessionDate), FormManager.getEndOfDaySolrDate(sessionDate));
        Criteria criteria = search.criteria();
        List allSession = this.wikittyProxy.findAllByCriteria(Session.class, criteria).getAll();
        if (log.isDebugEnabled()) {
            log.debug((Object)(allSession.size() + " sessions found"));
        }
        return allSession;
    }

    protected static String getBeginOfDaySolrDate(Date date) throws VradiException {
        Date localDate = DateUtil.setMinTimeOfDay((Date)date);
        try {
            return WikittyUtil.formatDate((Date)localDate);
        }
        catch (ParseException eee) {
            throw new VradiException("Cant format date " + date, eee);
        }
    }

    protected static String getEndOfDaySolrDate(Date date) throws VradiException {
        Date localDate = DateUtil.setMaxTimeOfDay((Date)date);
        try {
            return WikittyUtil.formatDate((Date)localDate);
        }
        catch (ParseException eee) {
            throw new VradiException("Cant format date " + date, eee);
        }
    }

    public Session createNewSession() throws VradiException {
        Session lastSession = this.getLastOpenSession();
        if (lastSession != null) {
            throw new VradiException(I18n._((String)"Already opened session on %tF", (Object[])new Object[]{lastSession.getSessionDate()}));
        }
        Date now = new Date();
        List<Session> sessionList = this.getSessions(now);
        int num = sessionList.size() + 1;
        if (log.isDebugEnabled()) {
            log.debug((Object)("No session found, creating a new one with num : " + num));
        }
        SessionImpl currentSession = new SessionImpl();
        currentSession.setSessionDate(now);
        currentSession.setNum(num);
        currentSession.setStatus(VradiConstants.SessionStatus.ACTIVE.getValue());
        currentSession.setParagraph(VradiServiceConfiguration.getInstance(new String[0]).getSessionDefaultParagraph());
        currentSession = (Session)this.wikittyProxy.store((BusinessEntity)currentSession);
        return currentSession;
    }

    public Session bindForms(Session currentSession) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("bindForms " + currentSession.getNum() + " : " + currentSession.getSessionDate()));
        }
        try {
            if (!VradiConstants.SessionStatus.isActive(currentSession)) {
                throw new VradiException("Session is not active, abording");
            }
            List<Sending> toSend = this.resetSendings(currentSession);
            if (toSend == null) {
                toSend = new ArrayList<Sending>();
            }
            currentSession = (Session)this.wikittyProxy.restore(Session.class, currentSession.getWikittyId());
            String status = this.getSelectionneStatus().getWikittyId();
            ArrayList<GroupForms> groupFormToSave = new ArrayList<GroupForms>();
            List<Group> groups = this.searchManager.findGroupsWithQueries();
            for (Group group : groups) {
                ArrayList<String> formsIdsToBind = new ArrayList<String>();
                Set queries = group.getQueries();
                for (String queryEntry : queries) {
                    try {
                        QueryBean queryBean = new QueryBean(queryEntry);
                        String query = queryBean.getQuery();
                        Search filter = Search.query();
                        filter.eq("Infogene.status", status);
                        Search filterDateModification = filter.or();
                        Date olderInscriptionDate = this.getOlderInscriptionDate(group.getUser());
                        filterDateModification.isNull("ModificationTag.lastModified");
                        filterDateModification.ge("ModificationTag.lastModified", WikittyUtil.formatDate((Date)olderInscriptionDate));
                        Search filterDatePeremption = filter.or();
                        filterDatePeremption.isNull("Form.datePeremption");
                        filterDatePeremption.ge("Form.datePeremption", WikittyUtil.formatDate((Date)new Date()));
                        Criteria criteria = filter.criteria();
                        FormPagedResult vradiFormPage = new FormPagedResult();
                        vradiFormPage = this.searchManager.findForms(query, criteria, vradiFormPage);
                        List<String> resultFormsIds = vradiFormPage.getFormsIdsToShow();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Query " + query + " return " + resultFormsIds.size() + " forms"));
                        }
                        formsIdsToBind.addAll(resultFormsIds);
                    }
                    catch (IOException ex) {
                        if (!log.isErrorEnabled()) continue;
                        log.error((Object)"Can't parse group query", (Throwable)ex);
                    }
                    catch (UnsupportedQueryException ex) {
                        if (!log.isErrorEnabled()) continue;
                        log.error((Object)"Can't execute group query", (Throwable)ex);
                    }
                    catch (ParseException eee) {
                        throw new VradiException("Cant format date : ", eee);
                    }
                }
                if (formsIdsToBind.isEmpty()) continue;
                List users = this.wikittyProxy.restore(User.class, new ArrayList(group.getUser()));
                for (User user : users) {
                    Sending sending = this.findExistingOrCreateSending(toSend, user);
                    sending.setUser(user.getWikittyId());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Add user " + user.getWikittyId()));
                    }
                    List<Form> formsToBind = this.wikittyProxy.restore(Form.class, formsIdsToBind);
                    formsToBind = this.removeAlreadyBound(currentSession, formsToBind, user);
                    formsToBind = this.removeNotConcernedForms(sending, user, formsToBind);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Adding " + formsToBind.size() + " forms to sending"));
                    }
                    if (formsToBind.isEmpty()) continue;
                    GroupForms groupForms = SendingHelper.createGroupForms(group, formsToBind);
                    groupFormToSave.add(groupForms);
                    sending.addGroupForms(groupForms.getWikittyId());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"GroupForm created");
                    }
                    toSend.add(sending);
                }
            }
            if (toSend.isEmpty()) {
                return currentSession;
            }
            for (Sending s : toSend) {
                currentSession.addSending(s.getWikittyId());
            }
            ArrayList<Object> toSave = new ArrayList<Object>();
            toSave.addAll(groupFormToSave);
            toSave.addAll(toSend);
            toSave.add(currentSession);
            this.wikittyProxy.store(toSave);
            currentSession = (Session)this.wikittyProxy.restore(Session.class, currentSession.getWikittyId());
            if (log.isDebugEnabled()) {
                Set sending = currentSession.getSending();
                int size = sending == null ? 0 : sending.size();
                log.debug((Object)("Saving session '" + currentSession.getSessionDate() + "' number '" + currentSession.getNum() + "' status '" + VradiConstants.SessionStatus.getStatus(currentSession.getStatus()).getDescription() + "' with '" + size + "' sending"));
            }
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't bind form : ", (Throwable)e);
            }
            throw new VradiException("Can't bind form : ", e);
        }
        return currentSession;
    }

    protected List<Sending> resetSendings(Session currentSession) throws VradiException {
        Set sendingsIds = currentSession.getSending();
        if (sendingsIds == null) {
            return null;
        }
        ArrayList<Object> toSave = new ArrayList<Object>();
        List sendings = this.wikittyProxy.restore(Sending.class, new ArrayList(sendingsIds));
        HashSet<String> sendingIdsToDelete = new HashSet<String>();
        HashSet groupFormIdToDelete = new HashSet();
        for (Sending sending : new ArrayList(sendings)) {
            Set groupFormsAddedIds;
            Set concernedGroup = sending.getGroupForms();
            if (concernedGroup != null) {
                ArrayList concernedGroupList = new ArrayList(concernedGroup);
                groupFormIdToDelete.addAll(concernedGroupList);
                sending.clearGroupForms();
            }
            if ((groupFormsAddedIds = sending.getAddedGroupForms()) != null) {
                for (String groupFormsAddedId : groupFormsAddedIds) {
                    GroupForms groupFormsAdded = (GroupForms)this.wikittyProxy.restore(GroupForms.class, groupFormsAddedId);
                    Set<String> addedForms = SendingHelper.extractForms(groupFormsAdded);
                    Set<String> deletedForms = SendingHelper.extractForms(this.wikittyProxy, sending.getDeletedGroupForms());
                    addedForms.removeAll(deletedForms);
                    GroupForms groupForms = SendingHelper.createGroupForms(groupFormsAdded.getGroup(), addedForms);
                    toSave.add(groupForms);
                    sending.addGroupForms(groupForms.getWikittyId());
                }
            }
            Set deletedGroupForm = sending.getDeletedGroupForms();
            if (concernedGroup != null && !concernedGroup.isEmpty() || groupFormsAddedIds != null && !groupFormIdToDelete.isEmpty() || deletedGroupForm != null && !deletedGroupForm.isEmpty()) continue;
            String sendingId = sending.getWikittyId();
            sendingIdsToDelete.add(sendingId);
            currentSession.removeSending(sendingId);
            sendings.remove(sending);
        }
        this.wikittyProxy.delete(groupFormIdToDelete);
        this.wikittyProxy.delete(sendingIdsToDelete);
        toSave.add(currentSession);
        toSave.addAll(sendings);
        this.wikittyProxy.store(toSave);
        sendingsIds = currentSession.getSending();
        if (sendingsIds == null) {
            return null;
        }
        return this.wikittyProxy.restore(Sending.class, new ArrayList(sendingsIds));
    }

    protected List<Form> removeNotConcernedForms(Sending sending, User user, List<Form> finalFormsToBind) {
        Date beginSearchDate = user.getBeginSearchDate();
        for (Form f : new ArrayList<Form>(finalFormsToBind)) {
            String fid;
            Set<String> deletedFormsIds;
            ModificationTag formTag = (ModificationTag)this.wikittyProxy.cast((BusinessEntity)f, ModificationTag.class);
            Date lastModifier = formTag.getLastModified();
            Date peremptionDate = f.getDatePeremption();
            if (!user.getEnable()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Removing form '" + f.getObjet() + "' because user (" + user.getName() + ") is not enable"));
                }
                finalFormsToBind.remove(f);
            }
            if (lastModifier != null && lastModifier.before(beginSearchDate)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Removing form '" + f.getObjet() + "' because date of last modification (" + peremptionDate + ") is pass for user : " + user.getName()));
                }
                finalFormsToBind.remove(f);
            }
            if (peremptionDate != null && peremptionDate.before(new Date())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Removing form '" + f.getObjet() + "' because date of peremption (" + peremptionDate + ") is pass for user : " + user.getName()));
                }
                finalFormsToBind.remove(f);
            }
            if (!(deletedFormsIds = SendingHelper.extractForms(this.wikittyProxy, sending.getDeletedGroupForms())).contains(fid = f.getWikittyId())) continue;
            finalFormsToBind.remove(f);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Removing form '" + f.getObjet() + "' because form is already deleted" + " is pass for user : " + user.getName()));
        }
        return finalFormsToBind;
    }

    protected List<Form> removeAlreadyBound(Session currentSession, List<Form> forms, User user) {
        HashSet<String> formIds = new HashSet<String>();
        for (Form form : forms) {
            formIds.add(form.getWikittyId());
        }
        String userId = user.getWikittyId();
        Search searchGroupForm = Search.query();
        searchGroupForm.contains("GroupForms.form", formIds);
        List groupForms = this.wikittyProxy.findAllByCriteria(GroupForms.class, searchGroupForm.criteria()).getAll();
        ArrayList<String> groupFormsId = new ArrayList<String>();
        for (GroupForms gf : groupForms) {
            if (gf == null) continue;
            groupFormsId.add(gf.getWikittyId());
        }
        Search searchSending = Search.query();
        Set sendingIds = currentSession.getSending();
        if (sendingIds != null) {
            for (String currentSendingId : sendingIds) {
                searchSending.neq(Element.ELT_ID, currentSendingId);
            }
        }
        Search formSearch = searchSending.or();
        for (String groupFormId : groupFormsId) {
            formSearch.eq("Sending.groupForms", groupFormId);
            formSearch.eq("Sending.deletedGroupForms", groupFormId);
        }
        searchSending.eq("Sending.user", userId);
        Criteria criteria = searchSending.criteria();
        PagedResult pagedResult = this.wikittyProxy.findAllByCriteria(Sending.class, criteria);
        for (Sending send : pagedResult.getAll()) {
            Set<String> deletedIds;
            Set<String> formsIds = SendingHelper.extractForms(this.wikittyProxy, send.getGroupForms());
            if (formsIds != null) {
                formIds.removeAll(formsIds);
            }
            if ((deletedIds = SendingHelper.extractForms(this.wikittyProxy, send.getDeletedGroupForms())) == null) continue;
            formIds.removeAll(deletedIds);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Rest " + formIds.size() + " forms"));
        }
        List result = this.wikittyProxy.restore(Form.class, new ArrayList(formIds));
        return result;
    }

    protected Date getOlderInscriptionDate(Set<String> usersIds) {
        Date result = new Date();
        for (String userId : usersIds) {
            User user = (User)this.wikittyProxy.restore(User.class, userId);
            Date beginSearchDate = user.getBeginSearchDate();
            if (beginSearchDate != null && result.after(DateUtil.setMinTimeOfDay((Date)beginSearchDate))) {
                result = beginSearchDate;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("The older inscription date for user " + user.getName() + " is " + result));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("The older inscription date " + result));
        }
        return result;
    }

    public List<Sending> createAllSending(String currentSessionId, Group group, List<String> formsIdsToBind) {
        Session currentSession = (Session)this.wikittyProxy.restore(Session.class, currentSessionId);
        ArrayList<Sending> result = new ArrayList<Sending>();
        List users = this.wikittyProxy.restore(User.class, new ArrayList(group.getUser()));
        for (User user : users) {
            Sending sending = this.createUserSending(currentSession, group, user, formsIdsToBind);
            if (sending == null) continue;
            result.add(sending);
        }
        return result;
    }

    public Sending createUserSending(String currentSessionId, User user, List<String> formsIdsToBind) {
        Session currentSession = (Session)this.wikittyProxy.restore(Session.class, currentSessionId);
        return this.createUserSending(currentSession, null, user, formsIdsToBind);
    }

    protected Sending createUserSending(Session currentSession, Group groupConcerned, User user, List<String> formsIdsToBind) {
        Sending sending = this.findExistingOrCreateSending(currentSession, user);
        sending.setUser(user.getWikittyId());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Add user " + user.getWikittyId()));
        }
        if (!formsIdsToBind.isEmpty()) {
            ArrayList<GroupForms> groupFormsList = new ArrayList<GroupForms>();
            GroupForms groupForms = SendingHelper.createGroupForms(groupConcerned, formsIdsToBind);
            groupFormsList.add(groupForms);
            sending.addGroupForms(groupForms.getWikittyId());
            if (log.isDebugEnabled()) {
                log.debug((Object)"GroupForm created");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding added " + formsIdsToBind.size() + " forms for user : " + user.getName()));
            }
            GroupForms groupFormsAdded = SendingHelper.createGroupForms(groupConcerned, formsIdsToBind);
            groupFormsList.add(groupFormsAdded);
            sending.addAddedGroupForms(groupFormsAdded.getWikittyId());
            currentSession.addSending(sending.getWikittyId());
            ArrayList<Object> toSave = new ArrayList<Object>();
            toSave.addAll(groupFormsList);
            toSave.add(sending);
            toSave.add(currentSession);
            this.wikittyProxy.store(toSave);
            return (Sending)this.wikittyProxy.restore(Sending.class, sending.getWikittyId());
        }
        return null;
    }

    public List<Sending> removeAllSending(String sessionId, List<String> formsIds, Group group) throws VradiException {
        ArrayList<Sending> result = new ArrayList<Sending>();
        List users = this.wikittyProxy.restore(User.class, new ArrayList(group.getUser()));
        for (User user : users) {
            Sending sending = this.removeSending(sessionId, formsIds, group, user);
            result.add(sending);
        }
        return this.wikittyProxy.store(result);
    }

    public Sending removeSending(String sessionId, List<String> formsIds, User user) throws VradiException {
        return this.removeSending(sessionId, formsIds, null, user);
    }

    protected Sending removeSending(String sessionId, List<String> formsIds, Group group, User user) throws VradiException {
        try {
            Session session = (Session)this.wikittyProxy.restore(Session.class, sessionId);
            Set sendingSet = session.getSending();
            ArrayList sendingList = new ArrayList();
            if (sendingSet != null) {
                sendingList = new ArrayList(sendingSet);
            }
            List sendings = this.wikittyProxy.restore(Sending.class, sendingList);
            for (Sending sending : sendings) {
                if (sending == null || !user.getWikittyId().equals(sending.getUser())) continue;
                boolean formAreRemoved = false;
                List groupForms = this.wikittyProxy.restore(GroupForms.class, new ArrayList(sending.getGroupForms()));
                HashSet formsIdsRestored = new HashSet();
                for (GroupForms gf : groupForms) {
                    if (gf == null) continue;
                    for (String formId : formsIds) {
                        if (gf.getForm() == null || !gf.getForm().contains(formId)) continue;
                        gf.removeForm(formId);
                        formAreRemoved = true;
                    }
                    if (gf.getForm() == null) continue;
                    formsIdsRestored.addAll(gf.getForm());
                }
                if (!formAreRemoved) {
                    return sending;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Group concerned for sending of user '" + user.getName() + "' : " + (group == null ? "null" : group.getName())));
                }
                GroupForms groupFormsDeleted = SendingHelper.createGroupForms(group, formsIds);
                sending.addDeletedGroupForms(groupFormsDeleted.getWikittyId());
                if (formsIdsRestored == null || formsIdsRestored.isEmpty()) {
                    sending.setStatus(VradiConstants.SendingStatus.DELETED.getValue());
                }
                ArrayList<Object> toSave = new ArrayList<Object>();
                toSave.addAll(groupForms);
                toSave.add(groupFormsDeleted);
                toSave.add(sending);
                this.wikittyProxy.store(toSave);
                this.closeSessionIfNoMoreError(session);
                return (Sending)this.wikittyProxy.restore(Sending.class, sending.getWikittyId());
            }
            return null;
        }
        catch (Exception eee) {
            throw new VradiException("Cant remove forms for user " + user.getName(), eee);
        }
    }

    public boolean removeFormsFromSession(String sessionId, List<String> formsIds) throws VradiException {
        try {
            Session session = (Session)this.wikittyProxy.restore(Session.class, sessionId);
            if (session == null) {
                return false;
            }
            ArrayList<Object> toSave = new ArrayList<Object>();
            Set sendingsIds = session.getSending();
            if (sendingsIds == null) {
                return false;
            }
            List sendings = this.wikittyProxy.restore(Sending.class, new ArrayList(sendingsIds));
            for (Sending sending : sendings) {
                if (sending == null) continue;
                List groupsForms = this.wikittyProxy.restore(GroupForms.class, new ArrayList(sending.getGroupForms()));
                boolean isDeleted = false;
                for (GroupForms gf : groupsForms) {
                    for (String formId : formsIds) {
                        if (gf == null || gf.getForm() == null || !gf.getForm().contains(formId)) continue;
                        gf.removeForm(formId);
                        isDeleted = true;
                    }
                }
                if (!isDeleted) continue;
                toSave.addAll(groupsForms);
                GroupForms groupFormsDeleted = SendingHelper.createGroupForms((String)null, formsIds);
                sending.addDeletedGroupForms(groupFormsDeleted.getWikittyId());
                toSave.add(groupFormsDeleted);
                if (SendingHelper.extractForms(this.wikittyProxy, sending.getGroupForms()).isEmpty()) {
                    sending.setStatus(VradiConstants.SendingStatus.DELETED.getValue());
                }
                toSave.add(sending);
            }
            this.wikittyProxy.store(toSave);
            this.closeSessionIfNoMoreError(session);
            return true;
        }
        catch (Exception eee) {
            throw new VradiException("Cant remove all forms for session", eee);
        }
    }

    protected Sending findExistingOrCreateSending(Session currentSession, User user) {
        Set sendingsId = currentSession.getSending();
        List<Object> sendings = sendingsId != null ? this.wikittyProxy.restore(Sending.class, new ArrayList(sendingsId)) : new ArrayList<Sending>();
        return this.findExistingOrCreateSending(sendings, user);
    }

    protected Sending findExistingOrCreateSending(List<Sending> sendings, User user) {
        for (Sending sending : sendings) {
            String userId = user.getWikittyId();
            if (sending == null || !userId.equals(sending.getUser())) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Sending is existing for queryMaker : " + user.getName()));
            }
            return sending;
        }
        return this.createNewSending(user);
    }

    protected Sending createNewSending(User user) {
        SendingImpl newSending = new SendingImpl();
        newSending.setSentDate(null);
        newSending.setReceptionDate(null);
        newSending.setParagraph("");
        newSending.setReceptionProof(false);
        newSending.setStatus(VradiConstants.SendingStatus.TO_SEND.getValue());
        newSending.setUser(user.getWikittyId());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending dont exist for queryMaker : " + user + ", creating one"));
        }
        return newSending;
    }

    public Sending revertDeletion(String sendingId, List<String> formsIdsToUpdate) {
        return this.revertDeletion(sendingId, null, formsIdsToUpdate, true);
    }

    protected Sending revertDeletion(String sendingId, String groupId, List<String> formsIdsToUpdate, boolean save) {
        Sending sending = (Sending)this.wikittyProxy.restore(Sending.class, sendingId);
        Set groupFormIds = sending.getDeletedGroupForms();
        if (groupFormIds != null) {
            List groupForms = this.wikittyProxy.restore(GroupForms.class, new ArrayList(groupFormIds));
            boolean isDeleted = false;
            ArrayList<String> toDeleteIds = new ArrayList<String>();
            for (GroupForms gf : groupForms) {
                if (gf == null) continue;
                Set formsInGroupForms = gf.getForm();
                for (String formId : formsIdsToUpdate) {
                    if (formsInGroupForms == null || formsInGroupForms.isEmpty() || !formsInGroupForms.contains(formId)) continue;
                    gf.removeForm(formId);
                    isDeleted = true;
                    if (!gf.getForm().isEmpty()) continue;
                    String toDelete = gf.getWikittyId();
                    sending.removeDeletedGroupForms(toDelete);
                    toDeleteIds.add(toDelete);
                }
            }
            if (!isDeleted) {
                return sending;
            }
            GroupForms groupFormsCreated = SendingHelper.createGroupForms(groupId, formsIdsToUpdate);
            sending.addGroupForms(groupFormsCreated.getWikittyId());
            this.wikittyProxy.delete(toDeleteIds);
            this.wikittyProxy.store(groupForms);
            this.wikittyProxy.store((BusinessEntity)groupFormsCreated);
            if (VradiConstants.SendingStatus.isDeleted(sending)) {
                sending.setStatus(VradiConstants.SendingStatus.TO_SEND.getValue());
            }
            if (save) {
                return (Sending)this.wikittyProxy.store((BusinessEntity)sending);
            }
            return sending;
        }
        return sending;
    }

    public Sending revertUserDeletion(String sessionId, String userId, String formId) {
        return this.revertUserDeletion(sessionId, null, userId, formId, true);
    }

    protected Sending revertUserDeletion(String sessionId, String groupId, String userId, String formId, boolean save) {
        Session session = (Session)this.wikittyProxy.restore(Session.class, sessionId);
        Set sendingIds = session.getSending();
        if (sendingIds == null) {
            return null;
        }
        for (String sendingId : sendingIds) {
            Sending sending = (Sending)this.wikittyProxy.restore(Sending.class, sendingId);
            if (!userId.equals(sending.getUser())) continue;
            ArrayList<String> formIds = new ArrayList<String>();
            formIds.add(formId);
            return this.revertDeletion(sending.getWikittyId(), groupId, formIds, save);
        }
        return null;
    }

    public List<Sending> revertGroupDeletion(String sessionId, String groupId, String formId) {
        ArrayList<Sending> result = new ArrayList<Sending>();
        Group group = (Group)this.wikittyProxy.restore(Group.class, groupId);
        Set userIds = group.getUser();
        if (userIds == null) {
            return result;
        }
        for (String userId : userIds) {
            Sending sending = this.revertUserDeletion(sessionId, groupId, userId, formId, false);
            result.add(sending);
        }
        return this.wikittyProxy.store(result);
    }

    protected Session closeSessionIfNoMoreError(Session session) {
        boolean noOneAreSent;
        session = (Session)this.wikittyProxy.restore(Session.class, session.getWikittyId());
        Set sendingSet = session.getSending();
        ArrayList sendingList = new ArrayList();
        if (sendingSet != null) {
            sendingList = new ArrayList(sendingSet);
        }
        List sendings = this.wikittyProxy.restore(Sending.class, sendingList);
        int sentCnt = 0;
        for (Sending sending : sendings) {
            if (VradiConstants.SendingStatus.isInError(sending)) {
                return session;
            }
            if (!VradiConstants.SendingStatus.isSent(sending)) continue;
            ++sentCnt;
        }
        boolean allAreSent = sentCnt == sendings.size();
        boolean bl = noOneAreSent = sentCnt == 0;
        if (allAreSent) {
            session.setStatus(VradiConstants.SessionStatus.SENT.getValue());
            session.setSessionDate(new Date());
            session.setSessionLogs("");
        } else if (noOneAreSent) {
            session.setStatus(VradiConstants.SessionStatus.ACTIVE.getValue());
            session.setSessionDate(new Date());
            session.setSessionLogs("");
        }
        return (Session)this.wikittyProxy.store((BusinessEntity)session);
    }

    public void deleteSession(String sessionId) throws VradiException {
        if (sessionId == null) {
            return;
        }
        Session sessionToDelete = (Session)this.wikittyProxy.restore(Session.class, sessionId);
        if (!VradiConstants.SessionStatus.isActive(sessionToDelete)) {
            throw new VradiException("Session is not active, abording");
        }
        ArrayList<String> idToDelete = new ArrayList<String>();
        Set sendingsIds = sessionToDelete.getSending();
        if (sendingsIds != null) {
            List sendings = this.wikittyProxy.restore(Sending.class, new ArrayList(sendingsIds));
            for (Sending sending : sendings) {
                Set toDelete = sending.getAddedGroupForms();
                if (toDelete != null) {
                    idToDelete.addAll(toDelete);
                }
                if ((toDelete = sending.getDeletedGroupForms()) != null) {
                    idToDelete.addAll(toDelete);
                }
                if ((toDelete = sending.getGroupForms()) == null) continue;
                idToDelete.addAll(toDelete);
            }
            idToDelete.addAll(sendingsIds);
        }
        idToDelete.add(sessionId);
        this.wikittyProxy.delete(idToDelete);
    }

    public Session getSessionOfSending(String sendingId) throws VradiException {
        try {
            Criteria criteria = Search.query().eq(Element.ELT_EXTENSION, "Session").contains("Session.sending", sendingId).criteria();
            return (Session)this.wikittyProxy.findByCriteria(Session.class, criteria);
        }
        catch (Exception eee) {
            log.error((Object)("Cant restore session for sending '" + sendingId + "' : "), (Throwable)eee);
            throw new VradiException("Cant restore session for sending '" + sendingId + "' : ", eee);
        }
    }

    public Status getStatus(String statusId) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getStatus(" + statusId + ")"));
        }
        Status status = (Status)this.wikittyProxy.restore(Status.class, statusId);
        return status;
    }

    public List<Status> getStatuses(List<String> statusIds) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getStatuses(statusIds)");
        }
        List statuses = this.wikittyProxy.restore(Status.class, statusIds);
        return new ArrayList<Status>(statuses);
    }

    public List<Status> createDefaultStatuses() throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"createDefaultStatuses()");
        }
        ArrayList<Status> all = new ArrayList<Status>();
        all.add(this.getNonTraiteStatus());
        all.add(this.getNonSelectionneStatus());
        all.add(this.getPreselectionneStatus());
        all.add(this.getSelectionneStatus());
        return new ArrayList<Status>(all);
    }

    public Status getNonTraiteStatus() {
        return this.getOrCreateStatus(VradiConstants.FormStatus.NON_TRAITE);
    }

    public Status getNonSelectionneStatus() {
        return this.getOrCreateStatus(VradiConstants.FormStatus.NON_SELECTIONNE);
    }

    public Status getPreselectionneStatus() {
        return this.getOrCreateStatus(VradiConstants.FormStatus.PRESELECTIONNE);
    }

    public Status getSelectionneStatus() {
        return this.getOrCreateStatus(VradiConstants.FormStatus.SELECTIONNE);
    }

    protected Status getOrCreateStatus(VradiConstants.FormStatus type) {
        Search search;
        Criteria criteria;
        Status status;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getOrCreateStatus(" + type.getName() + ")"));
        }
        if ((status = (Status)this.wikittyProxy.findByCriteria(Status.class, criteria = (search = Search.query().eq(Element.ELT_EXTENSION, "Status").eq("Status.name", type.getName())).criteria())) == null) {
            log.warn((Object)("Status not found creating : " + type.getName()));
            status = new StatusImpl();
            status.setName(type.getName());
            status.setValue(type.getValue());
            status.setDescription(type.getDescription());
            status.setModifiable(false);
            status = (Status)this.wikittyProxy.store((BusinessEntity)status);
        }
        return status;
    }

    public List<Status> updateStatuses(List<Status> statuses) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"updateStatuses(statuses)");
        }
        try {
            List result = this.wikittyProxy.store(statuses);
            return result;
        }
        catch (Exception eee) {
            log.error((Object)"Cant update statuses : ", (Throwable)eee);
            throw new VradiException("Cant update statuses : ", eee);
        }
    }

    public Status updateStatus(Status status) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"updateStatus(status)");
        }
        try {
            status = (Status)this.wikittyProxy.store((BusinessEntity)status);
            return status;
        }
        catch (Exception eee) {
            log.error((Object)"Cant update status : ", (Throwable)eee);
            throw new VradiException("Cant update status : ", eee);
        }
    }

    public boolean deleteStatuses(List<String> statusIds) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("deleteStatus(" + statusIds + ")"));
        }
        boolean result = true;
        for (String id : statusIds) {
            Search search = Search.query().eq(Element.ELT_EXTENSION, "Form").eq("Infogene.status", id);
            Criteria criteria = search.criteria();
            PagedResult forms = this.wikittyProxy.findAllByCriteria(Form.class, criteria);
            if (forms.size() > 0) {
                result = false;
                continue;
            }
            try {
                this.wikittyProxy.delete(id);
            }
            catch (Exception e) {
                log.error((Object)"Cant delete status : ", (Throwable)e);
                throw new VradiException("Cant delete status : ", e);
            }
        }
        return result;
    }

    protected List<User> getUsersOfClient(String clientId) {
        Search search = Search.query().eq(Element.ELT_EXTENSION, "User").eq("User.client", clientId);
        Criteria criteria = search.criteria();
        PagedResult usersPageResult = this.wikittyProxy.findAllByCriteria(User.class, criteria);
        return new ArrayList<User>(usersPageResult.getAll());
    }
}

