/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.htmlcleaner.ContentToken;
import org.htmlcleaner.DoctypeToken;
import org.htmlcleaner.HtmlCleaner;
import org.htmlcleaner.TagToken;
import org.htmlcleaner.TagTransformation;
import org.htmlcleaner.Utils;
import org.htmlcleaner.XPather;
import org.htmlcleaner.XPatherException;
import org.htmlcleaner.XmlSerializer;

public class TagNode
extends TagToken {
    private TagNode parent = null;
    private Map attributes = new LinkedHashMap();
    private List children = new ArrayList();
    private DoctypeToken docType = null;
    private List itemsToMove = null;
    private transient HtmlCleaner cleaner = null;
    private transient boolean isFormed = false;

    public TagNode(String name) {
        this(name, null);
    }

    public TagNode(String name, HtmlCleaner cleaner) {
        super(name == null ? null : name.toLowerCase());
        Set pruneTagSet;
        this.cleaner = cleaner;
        if (cleaner != null && (pruneTagSet = cleaner.getPruneTagSet()) != null && name != null && pruneTagSet.contains(name.toLowerCase())) {
            cleaner.addPruneNode(this);
        }
    }

    public String getAttributeByName(String attName) {
        return attName != null ? (String)this.attributes.get(attName.toLowerCase()) : null;
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public boolean hasAttribute(String attName) {
        return attName != null ? this.attributes.containsKey(attName.toLowerCase()) : false;
    }

    public void addAttribute(String attName, String attValue) {
        if (attName != null && !"".equals(attName.trim())) {
            this.attributes.put(attName.toLowerCase(), attValue == null ? "" : attValue);
        }
    }

    public void removeAttribute(String attName) {
        if (attName != null && !"".equals(attName.trim())) {
            this.attributes.remove(attName.toLowerCase());
        }
    }

    public List getChildren() {
        return this.children;
    }

    void setChildren(List children) {
        this.children = children;
    }

    public List getChildTagList() {
        ArrayList childTagList = new ArrayList();
        for (int i = 0; i < this.children.size(); ++i) {
            Object item = this.children.get(i);
            if (!(item instanceof TagNode)) continue;
            childTagList.add(item);
        }
        return childTagList;
    }

    public TagNode[] getChildTags() {
        List childTagList = this.getChildTagList();
        TagNode[] childrenArray = new TagNode[childTagList.size()];
        for (int i = 0; i < childTagList.size(); ++i) {
            childrenArray[i] = (TagNode)childTagList.get(i);
        }
        return childrenArray;
    }

    public StringBuffer getText() {
        StringBuffer text = new StringBuffer();
        for (int i = 0; i < this.children.size(); ++i) {
            Object item = this.children.get(i);
            if (item instanceof ContentToken) {
                text.append(((ContentToken)item).getContent());
                continue;
            }
            if (!(item instanceof TagNode)) continue;
            StringBuffer subtext = ((TagNode)item).getText();
            text.append(subtext);
        }
        return text;
    }

    public TagNode getParent() {
        return this.parent;
    }

    public DoctypeToken getDocType() {
        return this.docType;
    }

    public void setDocType(DoctypeToken docType) {
        this.docType = docType;
    }

    public void addChild(Object child) {
        if (child == null) {
            return;
        }
        if (child instanceof List) {
            this.addChildren((List)child);
        } else {
            this.children.add(child);
            if (child instanceof TagNode) {
                TagNode childTagNode = (TagNode)child;
                childTagNode.parent = this;
            }
        }
    }

    public void addChildren(List newChildren) {
        if (newChildren != null) {
            Iterator it = newChildren.iterator();
            while (it.hasNext()) {
                Object child = it.next();
                this.addChild(child);
            }
        }
    }

    private TagNode findElement(ITagNodeCondition condition, boolean isRecursive) {
        if (condition == null) {
            return null;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            TagNode inner;
            Object item = this.children.get(i);
            if (!(item instanceof TagNode)) continue;
            TagNode currNode = (TagNode)item;
            if (condition.satisfy(currNode)) {
                return currNode;
            }
            if (!isRecursive || (inner = currNode.findElement(condition, isRecursive)) == null) continue;
            return inner;
        }
        return null;
    }

    private List getElementList(ITagNodeCondition condition, boolean isRecursive) {
        LinkedList<TagNode> result = new LinkedList<TagNode>();
        if (condition == null) {
            return result;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            List innerList;
            Object item = this.children.get(i);
            if (!(item instanceof TagNode)) continue;
            TagNode currNode = (TagNode)item;
            if (condition.satisfy(currNode)) {
                result.add(currNode);
            }
            if (!isRecursive || (innerList = currNode.getElementList(condition, isRecursive)) == null || innerList.size() <= 0) continue;
            result.addAll(innerList);
        }
        return result;
    }

    private TagNode[] getElements(ITagNodeCondition condition, boolean isRecursive) {
        List list = this.getElementList(condition, isRecursive);
        TagNode[] array = new TagNode[list == null ? 0 : list.size()];
        for (int i = 0; i < list.size(); ++i) {
            array[i] = (TagNode)list.get(i);
        }
        return array;
    }

    public List getAllElementsList(boolean isRecursive) {
        return this.getElementList(new TagAllCondition(), isRecursive);
    }

    public TagNode[] getAllElements(boolean isRecursive) {
        return this.getElements(new TagAllCondition(), isRecursive);
    }

    public TagNode findElementByName(String findName, boolean isRecursive) {
        return this.findElement(new TagNodeNameCondition(findName), isRecursive);
    }

    public List getElementListByName(String findName, boolean isRecursive) {
        return this.getElementList(new TagNodeNameCondition(findName), isRecursive);
    }

    public TagNode[] getElementsByName(String findName, boolean isRecursive) {
        return this.getElements(new TagNodeNameCondition(findName), isRecursive);
    }

    public TagNode findElementHavingAttribute(String attName, boolean isRecursive) {
        return this.findElement(new TagNodeAttExistsCondition(attName), isRecursive);
    }

    public List getElementListHavingAttribute(String attName, boolean isRecursive) {
        return this.getElementList(new TagNodeAttExistsCondition(attName), isRecursive);
    }

    public TagNode[] getElementsHavingAttribute(String attName, boolean isRecursive) {
        return this.getElements(new TagNodeAttExistsCondition(attName), isRecursive);
    }

    public TagNode findElementByAttValue(String attName, String attValue, boolean isRecursive, boolean isCaseSensitive) {
        return this.findElement(new TagNodeAttValueCondition(attName, attValue, isCaseSensitive), isRecursive);
    }

    public List getElementListByAttValue(String attName, String attValue, boolean isRecursive, boolean isCaseSensitive) {
        return this.getElementList(new TagNodeAttValueCondition(attName, attValue, isCaseSensitive), isRecursive);
    }

    public TagNode[] getElementsByAttValue(String attName, String attValue, boolean isRecursive, boolean isCaseSensitive) {
        return this.getElements(new TagNodeAttValueCondition(attName, attValue, isCaseSensitive), isRecursive);
    }

    public Object[] evaluateXPath(String xPathExpression) throws XPatherException {
        return new XPather(xPathExpression).evaluateAgainstNode(this);
    }

    public boolean removeFromTree() {
        return this.parent != null ? this.parent.removeChild(this) : false;
    }

    public boolean removeChild(Object child) {
        return this.children.remove(child);
    }

    void addItemForMoving(Object item) {
        if (this.itemsToMove == null) {
            this.itemsToMove = new ArrayList();
        }
        this.itemsToMove.add(item);
    }

    List getItemsToMove() {
        return this.itemsToMove;
    }

    void setItemsToMove(List itemsToMove) {
        this.itemsToMove = itemsToMove;
    }

    boolean isFormed() {
        return this.isFormed;
    }

    void setFormed(boolean isFormed) {
        this.isFormed = isFormed;
    }

    void setFormed() {
        this.setFormed(true);
    }

    void transformAttributes(TagTransformation tagTrans) {
        boolean isPreserveSourceAtts = tagTrans.isPreserveSourceAttributes();
        boolean hasAttTransforms = tagTrans.hasAttributeTransformations();
        if (hasAttTransforms || !isPreserveSourceAtts) {
            LinkedHashMap<String, String> newAttributes;
            LinkedHashMap<String, String> linkedHashMap = newAttributes = isPreserveSourceAtts ? new LinkedHashMap<String, String>(this.attributes) : new LinkedHashMap();
            if (hasAttTransforms) {
                Map map = tagTrans.getAttributeTransformations();
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    String attName = (String)entry.getKey();
                    String template = (String)entry.getValue();
                    if (template == null) {
                        newAttributes.remove(attName);
                        continue;
                    }
                    String attValue = Utils.evaluateTemplate(template, this.attributes);
                    newAttributes.put(attName, attValue);
                }
            }
            this.attributes = newAttributes;
        }
    }

    public void serialize(XmlSerializer xmlSerializer, Writer writer) throws IOException {
        xmlSerializer.serialize(this, writer);
    }

    public TagNode makeCopy() {
        TagNode copy = new TagNode(this.name, this.cleaner);
        copy.attributes.putAll(this.attributes);
        return copy;
    }

    public class TagNodeAttValueCondition
    implements ITagNodeCondition {
        private String attName;
        private String attValue;
        private boolean isCaseSensitive;

        public TagNodeAttValueCondition(String attName, String attValue, boolean isCaseSensitive) {
            this.attName = attName;
            this.attValue = attValue;
            this.isCaseSensitive = isCaseSensitive;
        }

        public boolean satisfy(TagNode tagNode) {
            if (tagNode == null || this.attName == null || this.attValue == null) {
                return false;
            }
            return this.isCaseSensitive ? this.attValue.equals(tagNode.getAttributeByName(this.attName)) : this.attValue.equalsIgnoreCase(tagNode.getAttributeByName(this.attName));
        }
    }

    public class TagNodeAttExistsCondition
    implements ITagNodeCondition {
        private String attName;

        public TagNodeAttExistsCondition(String attName) {
            this.attName = attName;
        }

        public boolean satisfy(TagNode tagNode) {
            return tagNode == null ? false : tagNode.attributes.containsKey(this.attName.toLowerCase());
        }
    }

    public class TagNodeNameCondition
    implements ITagNodeCondition {
        private String name;

        public TagNodeNameCondition(String name) {
            this.name = name;
        }

        public boolean satisfy(TagNode tagNode) {
            return tagNode == null ? false : tagNode.name.equalsIgnoreCase(this.name);
        }
    }

    public class TagAllCondition
    implements ITagNodeCondition {
        public boolean satisfy(TagNode tagNode) {
            return true;
        }
    }

    public static interface ITagNodeCondition {
        public boolean satisfy(TagNode var1);
    }
}

