/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.Membership;
import org.jgroups.View;
import org.jgroups.protocols.MERGE2;
import org.jgroups.protocols.MERGE3;
import org.jgroups.protocols.MERGEFAST;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.protocols.pbcast.NAKACK;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Util;
import org.testng.annotations.Test;

@Test(groups={"flush"}, sequential=true)
public class MergeTest
extends ChannelTestBase {
    @Test
    public void testMerging2Members() throws Exception {
        this.mergeHelper("MergeTest.testMerging2Members", "A", "B");
    }

    @Test
    public void testMerging4Members() throws Exception {
        this.mergeHelper("MergeTest.testMerging4Members", "A", "B", "C", "D");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mergeHelper(String cluster_name, String ... members) throws Exception {
        JChannel[] channels = null;
        try {
            channels = this.createChannels(cluster_name, members);
            MergeTest.print(channels);
            System.out.println("\ncreating partitions: ");
            MergeTest.createPartitions(channels, members);
            MergeTest.print(channels);
            for (String member : members) {
                JChannel ch = MergeTest.findChannel(member, channels);
                assert (ch.getView().size() == 1) : "view of " + ch.getAddress() + ": " + ch.getView();
            }
            System.out.println("\n==== injecting merge event ====");
            for (String member : members) {
                MergeTest.injectMergeEvent(channels, member, members);
            }
            for (int i = 0; i < 20; ++i) {
                System.out.print(".");
                if (MergeTest.allChannelsHaveViewOf(channels, members.length)) break;
                Util.sleep(500L);
            }
            System.out.println("\n");
            MergeTest.print(channels);
            MergeTest.assertAllChannelsHaveViewOf(channels, members.length);
        }
        finally {
            if (channels != null) {
                MergeTest.close(channels);
            }
        }
    }

    private JChannel[] createChannels(String cluster_name, String[] members) throws Exception {
        JChannel[] retval = new JChannel[members.length];
        JChannel ch = null;
        for (int i = 0; i < retval.length; ++i) {
            JChannel tmp = ch == null ? (ch = this.createChannel(true, members.length)) : this.createChannel(ch);
            tmp.setName(members[i]);
            ProtocolStack stack = tmp.getProtocolStack();
            NAKACK nakack = (NAKACK)stack.findProtocol((Class<?>)NAKACK.class);
            if (nakack != null) {
                nakack.setLogDiscardMessages(false);
            }
            stack.removeProtocol(MERGE2.class, MERGE3.class, MERGEFAST.class);
            tmp.connect(cluster_name);
            retval[i] = tmp;
        }
        return retval;
    }

    private static void close(JChannel[] channels) {
        if (channels == null) {
            return;
        }
        for (int i = channels.length - 1; i <= 0; --i) {
            JChannel ch = channels[i];
            Util.close((Channel)ch);
        }
    }

    private static void createPartitions(JChannel[] channels, String ... partitions) throws Exception {
        MergeTest.checkUniqueness(new String[][]{partitions});
        ArrayList<View> views = new ArrayList<View>(partitions.length);
        for (String partition : partitions) {
            View view = MergeTest.createView(partition, channels);
            views.add(view);
        }
        MergeTest.applyViews(views, channels);
    }

    private static void checkUniqueness(String[] ... partitions) throws Exception {
        HashSet<String> set = new HashSet<String>();
        String[][] arr$ = partitions;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String[] partition;
            for (String tmp : partition = arr$[i$]) {
                if (set.add(tmp)) continue;
                throw new Exception("partitions are overlapping: element " + tmp + " is in multiple partitions");
            }
        }
    }

    private static void injectMergeEvent(JChannel[] channels, String leader, String ... coordinators) {
        Address leader_addr = leader != null ? MergeTest.findAddress(leader, channels) : MergeTest.determineLeader(channels, new String[0]);
        MergeTest.injectMergeEvent(channels, leader_addr, coordinators);
    }

    private static void injectMergeEvent(JChannel[] channels, Address leader_addr, String ... coordinators) {
        HashMap<Address, View> views = new HashMap<Address, View>();
        for (String tmp : coordinators) {
            Address coord = MergeTest.findAddress(tmp, channels);
            views.put(coord, MergeTest.findView(tmp, channels));
        }
        JChannel coord = MergeTest.findChannel(leader_addr, channels);
        GMS gms = (GMS)coord.getProtocolStack().findProtocol((Class<?>)GMS.class);
        gms.setLevel("trace");
        gms.up(new Event(14, views));
    }

    private static View createView(String partition, JChannel[] channels) throws Exception {
        Vector<Address> members = new Vector<Address>();
        Address addr = MergeTest.findAddress(partition, channels);
        if (addr == null) {
            throw new Exception(partition + " not associated with a channel");
        }
        members.add(addr);
        return new View((Address)members.firstElement(), 10L, members);
    }

    private static JChannel findChannel(String tmp, JChannel[] channels) {
        for (JChannel ch : channels) {
            if (!ch.getName().equals(tmp)) continue;
            return ch;
        }
        return null;
    }

    private static JChannel findChannel(Address addr, JChannel[] channels) {
        for (JChannel ch : channels) {
            if (!ch.getAddress().equals(addr)) continue;
            return ch;
        }
        return null;
    }

    private static View findView(String tmp, JChannel[] channels) {
        for (JChannel ch : channels) {
            if (!ch.getName().equals(tmp)) continue;
            return ch.getView();
        }
        return null;
    }

    private static boolean allChannelsHaveViewOf(JChannel[] channels, int count) {
        for (JChannel ch : channels) {
            if (ch.getView().size() == count) continue;
            return false;
        }
        return true;
    }

    private static void assertAllChannelsHaveViewOf(JChannel[] channels, int count) {
        for (JChannel ch : channels) {
            assert (ch.getView().size() == count) : ch.getName() + " has view " + ch.getView();
        }
    }

    private static Address determineLeader(JChannel[] channels, String ... coords) {
        Membership membership = new Membership();
        for (String coord : coords) {
            membership.add(MergeTest.findAddress(coord, channels));
        }
        membership.sort();
        return membership.elementAt(0);
    }

    private static Address findAddress(String tmp, JChannel[] channels) {
        for (JChannel ch : channels) {
            if (!ch.getName().equals(tmp)) continue;
            return ch.getAddress();
        }
        return null;
    }

    private static void applyViews(List<View> views, JChannel[] channels) {
        for (View view : views) {
            Vector<Address> members = view.getMembers();
            for (JChannel ch : channels) {
                Address addr = ch.getAddress();
                if (!members.contains(addr)) continue;
                GMS gms = (GMS)ch.getProtocolStack().findProtocol((Class<?>)GMS.class);
                gms.installView(view);
            }
        }
    }

    private static void print(JChannel[] channels) {
        for (JChannel ch : channels) {
            System.out.println(ch.getName() + ": " + ch.getView());
        }
    }
}

