/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services.managers;

import com.jurismarches.vradi.VradiConstants;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.FormImpl;
import com.jurismarches.vradi.entities.VradiUser;
import com.jurismarches.vradi.entities.XmlFieldBinding;
import com.jurismarches.vradi.entities.XmlStream;
import com.jurismarches.vradi.services.ServiceFactory;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.managers.DateParser2;
import com.jurismarches.vradi.services.managers.FormManager;
import com.jurismarches.vradi.services.managers.FormTypeManager;
import com.jurismarches.vradi.services.managers.PropertiesManager;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.input.SAXBuilder;
import org.nuiton.util.StringUtil;
import org.sharengo.wikitty.BusinessEntity;
import org.sharengo.wikitty.Criteria;
import org.sharengo.wikitty.FieldType;
import org.sharengo.wikitty.PagedResult;
import org.sharengo.wikitty.Wikitty;
import org.sharengo.wikitty.WikittyExtension;
import org.sharengo.wikitty.WikittyProxy;
import org.sharengo.wikitty.WikittyUtil;
import org.sharengo.wikitty.search.Element;
import org.sharengo.wikitty.search.Search;

public class BindingManager {
    private static final Log log = LogFactory.getLog(BindingManager.class);
    private final WikittyProxy proxy;
    private final FormTypeManager formTypeManager;
    private final FormManager formManager;
    private Timer timer = null;
    private TimerTask xmlStreamTask = null;

    public BindingManager(WikittyProxy proxy, FormTypeManager formTypeManager, FormManager formManager) {
        this.proxy = proxy;
        this.formTypeManager = formTypeManager;
        this.formManager = formManager;
    }

    public BindingManager(FormTypeManager formTypeManager, FormManager formManager) {
        this.proxy = ServiceFactory.getWikittyProxy();
        this.formTypeManager = formTypeManager;
        this.formManager = formManager;
    }

    public List<XmlFieldBinding> getXmlFieldBindings(XmlStream xmlStream) {
        ArrayList<XmlFieldBinding> list = new ArrayList<XmlFieldBinding>();
        if (xmlStream != null && xmlStream.getXmlFieldBinding() != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getXmlFieldBindings(" + xmlStream.getName() + ")"));
                log.debug((Object)xmlStream.getXmlFieldBinding());
            }
            ArrayList bindings = new ArrayList();
            bindings.addAll(xmlStream.getXmlFieldBinding());
            List restore = this.proxy.restore(XmlFieldBinding.class, bindings);
            list.addAll(restore);
        }
        return list;
    }

    public XmlFieldBinding getXmlFieldBinding(String xmlFieldBindingId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getXmlFieldBinding(" + xmlFieldBindingId + ")"));
        }
        XmlFieldBinding xmlFieldBinding = (XmlFieldBinding)this.proxy.restore(XmlFieldBinding.class, xmlFieldBindingId);
        return xmlFieldBinding;
    }

    public List<XmlFieldBinding> updateXmlFieldBindings(List<XmlFieldBinding> bindings) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"updateXmlFieldBindings(bindings)");
        }
        try {
            ArrayList<XmlFieldBinding> list = new ArrayList<XmlFieldBinding>();
            if (bindings != null) {
                bindings = this.proxy.store(bindings);
                list.addAll(bindings);
            }
            return list;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new VradiException(e);
        }
    }

    public XmlStream updateXmlStream(XmlStream xmlStream, List<XmlFieldBinding> bindings) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"updateXmlStream(xmlStream, bindings)");
        }
        try {
            bindings = this.updateXmlFieldBindings(bindings);
            xmlStream.clearXmlFieldBinding();
            for (XmlFieldBinding binding : bindings) {
                xmlStream.addXmlFieldBinding(binding.getWikittyId());
            }
            XmlStream stream = (XmlStream)this.proxy.store((BusinessEntity)xmlStream);
            return stream;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new VradiException(e);
        }
    }

    public List<XmlStream> getAllXmlStreams() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getAllXmlStreams()");
        }
        Criteria criteria = Search.query().eq(Element.ELT_EXTENSION, "XmlStream").criteria();
        PagedResult xmlStreams = this.proxy.findAllByCriteria(XmlStream.class, criteria);
        List all = xmlStreams.getAll();
        ArrayList<XmlStream> list = new ArrayList<XmlStream>();
        list.addAll(all);
        return list;
    }

    public XmlStream getXmlStream(String xmlStreamId) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getXmlStream(" + xmlStreamId + ")"));
        }
        XmlStream xmlStream = (XmlStream)this.proxy.restore(XmlStream.class, xmlStreamId);
        return xmlStream;
    }

    private FormImpl createForm(WikittyExtension formType, List<XmlFieldBinding> bindings, org.jdom.Element feed, BindingContext bindingContext) {
        FormImpl form = new FormImpl();
        Wikitty wikitty = form.getWikitty();
        wikitty.addExtension(formType);
        for (XmlFieldBinding binding : bindings) {
            FieldType fieldType;
            String fqFormField = binding.getFormField();
            try {
                fieldType = wikitty.getFieldType(fqFormField);
            }
            catch (Exception e) {
                continue;
            }
            this.fillFormField(wikitty, fieldType, binding, feed, bindingContext);
        }
        return form;
    }

    private void fillFormField(Wikitty wikitty, FieldType fieldType, XmlFieldBinding binding, org.jdom.Element feed, BindingContext bindingContext) {
        String fqFormField = binding.getFormField();
        Set xmlFields = binding.getXmlField();
        if (xmlFields == null || xmlFields.isEmpty()) {
            String defaultValue = binding.getDefaultValue();
            this.fillFormField2(wikitty, fieldType, fqFormField, defaultValue, bindingContext);
            return;
        }
        for (String xmlField : xmlFields) {
            org.jdom.Element child = feed.getChild(xmlField);
            String feedValue = null;
            if (child != null) {
                feedValue = child.getTextTrim();
            }
            if (feedValue == null || feedValue.isEmpty()) {
                feedValue = binding.getDefaultValue();
            }
            this.fillFormField2(wikitty, fieldType, fqFormField, feedValue, bindingContext);
        }
    }

    private void fillFormField2(Wikitty wikitty, FieldType fieldType, String fqFormField, String feedValue, BindingContext bindingContext) {
        if (feedValue == null || feedValue.isEmpty()) {
            return;
        }
        switch (fieldType.getType()) {
            case DATE: {
                Date date = DateParser2.parse(feedValue);
                if (date != null) {
                    wikitty.setFqField(fqFormField, (Object)WikittyUtil.solrDateFormat.format(date));
                    break;
                }
                ++bindingContext.dateParsingError;
                break;
            }
            case NUMERIC: {
                if (NumberUtils.isNumber((String)feedValue)) {
                    Double value = Double.valueOf(feedValue);
                    wikitty.setFqField(fqFormField, (Object)value);
                    break;
                }
                ++bindingContext.numberParsingError;
                break;
            }
            default: {
                Object fieldValue = wikitty.getFqField(fqFormField);
                String newValue = null;
                newValue = fieldValue != null ? fieldValue + "\n" + feedValue : feedValue;
                wikitty.setFqField(fqFormField, (Object)newValue);
            }
        }
    }

    public int[] getFormsFromXmlStream(XmlStream xmlStream, VradiUser vradiUser) throws VradiException {
        int[] results = new int[4];
        String lastItemRecorded = PropertiesManager.getLastItemOfXmlStream(xmlStream.getName());
        if (log.isDebugEnabled()) {
            log.debug((Object)("getFormsFromXmlStream(" + xmlStream.getName() + ", " + lastItemRecorded));
        }
        if (xmlStream.getFormTypeName() == null) {
            throw new VradiException("xmlStream.formTypeName is null");
        }
        WikittyExtension formType = this.formTypeManager.getFormType(xmlStream.getFormTypeName());
        if (formType == null) {
            throw new VradiException("Extension of name xmlStream.formTypeName does not exists");
        }
        Document document = null;
        try {
            SAXBuilder sxb = new SAXBuilder();
            URL rssUrl = new URL(xmlStream.getUrl());
            log.info((Object)("Reading xmlStream url from: " + rssUrl));
            document = sxb.build(rssUrl);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't read xml stream", (Throwable)e);
            }
            throw new VradiException(e);
        }
        org.jdom.Element racine = document.getRootElement();
        List elements = null;
        if (racine.getChild("channel") != null) {
            org.jdom.Element channel = racine.getChild("channel");
            elements = channel.getChildren("item");
        } else if (racine.getChild("item") != null) {
            elements = racine.getChildren("item");
        } else if (racine.getChild("entry") != null) {
            elements = racine.getChildren("entry");
        }
        if (elements == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Enable to find items or entries in xmlStream");
            }
            return results;
        }
        int index = 0;
        boolean itemAlreadyRecorded = false;
        ArrayList<String> encryptedElements = new ArrayList<String>();
        while (index < elements.size() && !itemAlreadyRecorded) {
            String encryptedItemValue;
            block22: {
                org.jdom.Element element = (org.jdom.Element)elements.get(index);
                StringBuffer sb = new StringBuffer();
                List fields = element.getChildren();
                for (org.jdom.Element field : fields) {
                    sb.append(field.getText());
                }
                encryptedItemValue = null;
                try {
                    encryptedItemValue = StringUtil.encodeMD5((String)sb.toString());
                }
                catch (NoSuchAlgorithmException eee) {
                    if (!log.isFatalEnabled()) break block22;
                    log.fatal((Object)"No MD5 algorithm found");
                }
            }
            if (lastItemRecorded != null && lastItemRecorded.equals(encryptedItemValue)) {
                itemAlreadyRecorded = true;
                continue;
            }
            encryptedElements.add(encryptedItemValue);
            ++index;
        }
        if (--index >= 0) {
            String lastItemOfXmlStream = null;
            ArrayList<Form> forms = new ArrayList<Form>();
            List bindings = this.proxy.restore(XmlFieldBinding.class, new ArrayList(xmlStream.getXmlFieldBinding()));
            String formId = VradiConstants.FORM_ID_DATE_FORMAT.format(new Date());
            String toTreatId = this.formManager.getNonTraiteStatus().getWikittyId();
            BindingContext bindingContext = new BindingContext();
            for (int i = index; i >= 0; --i) {
                org.jdom.Element feed = (org.jdom.Element)elements.get(i);
                FormImpl form = this.createForm(formType, bindings, feed, bindingContext);
                ++bindingContext.nbCreated;
                form.setId(formId + form.getWikittyId());
                form.setXmlStreamURL(xmlStream.getUrl());
                form.setStatus(toTreatId);
                forms.add((Form)form);
                lastItemOfXmlStream = (String)encryptedElements.get(i);
                if (forms.size() <= 1000) continue;
                this.formManager.updateForms(forms);
                PropertiesManager.setLastItemOfXmlStream(xmlStream.getName(), lastItemOfXmlStream);
                forms.clear();
            }
            if (!forms.isEmpty()) {
                this.formManager.updateForms(forms);
                PropertiesManager.setLastItemOfXmlStream(xmlStream.getName(), lastItemOfXmlStream);
            }
            results[0] = bindingContext.nbCreated;
            results[2] = bindingContext.dateParsingError;
            results[3] = bindingContext.numberParsingError;
        }
        results[1] = elements.size() - results[0];
        if (log.isInfoEnabled()) {
            log.info((Object)("Form import from stream, created = " + results[0]));
            log.info((Object)("Form import from stream, already existing = " + results[1]));
            log.info((Object)("Form import from stream, dateParsingError = " + results[2]));
            log.info((Object)("Form import from stream, numberParsingError = " + results[3]));
        }
        return results;
    }

    public void autoLoadFormsFromXmlStreams(String intervalUnit, int intervalValue, Integer hour, Integer minute) throws VradiException {
        int delayInMinute = 0;
        int intervalUnitInMinutes = 0;
        GregorianCalendar cal = new GregorianCalendar();
        int calHour = cal.get(11);
        int calMinute = cal.get(12);
        int diffMinute = 0;
        int diffHour = 0;
        if (minute != null) {
            diffMinute = (60 + minute - calMinute) % 60;
            if (hour != null) {
                diffHour = (24 + hour - calHour - 1 + (60 + minute - calMinute) / 60) % 24;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("delay : " + diffHour + " hours " + diffMinute + " minutes"));
        }
        if (VradiConstants.XmlStreamConfig.HOURS.toString().equals(intervalUnit)) {
            intervalUnitInMinutes = 60;
            delayInMinute = diffMinute;
        } else if (VradiConstants.XmlStreamConfig.DAYS.toString().equals(intervalUnit)) {
            intervalUnitInMinutes = 1440;
            delayInMinute = diffMinute + diffHour * 60;
        } else if (VradiConstants.XmlStreamConfig.MINUTES.toString().equals(intervalUnit)) {
            intervalUnitInMinutes = 1;
            delayInMinute = minute;
        }
        int interval = intervalValue * intervalUnitInMinutes * 60 * 1000;
        int delay = delayInMinute * 60 * 1000;
        this.autoLoadFormsFromXmlStreams(delay, interval);
        PropertiesManager.setXmlStreamConfig(intervalUnit, String.valueOf(intervalValue), hour == null ? null : String.valueOf(hour), minute == null ? null : String.valueOf(minute));
    }

    protected void autoLoadFormsFromXmlStreams(long delay, long period) throws VradiException {
        if (this.timer == null) {
            this.timer = new Timer();
        }
        if (this.xmlStreamTask != null) {
            this.xmlStreamTask.cancel();
            this.timer.purge();
        }
        this.xmlStreamTask = new TimerTask(){

            @Override
            public void run() {
                if (log.isInfoEnabled()) {
                    log.info((Object)"Update xml streams task");
                }
                List<XmlStream> xmlStreams = BindingManager.this.getAllXmlStreams();
                for (XmlStream xmlStream : xmlStreams) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Loading forms from " + xmlStream.getName()));
                    }
                    try {
                        BindingManager.this.getFormsFromXmlStream(xmlStream, null);
                    }
                    catch (VradiException eee) {
                        log.error((Object)("can't create forms from stream : " + xmlStream.getName()));
                    }
                }
            }
        };
        this.timer.scheduleAtFixedRate(this.xmlStreamTask, delay, period);
    }

    private static class BindingContext {
        int dateParsingError = 0;
        int numberParsingError = 0;
        int nbCreated = 0;

        private BindingContext() {
        }
    }
}

