/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services.dto;

import com.jurismarches.vradi.entities.Thesaurus;
import com.jurismarches.vradi.services.dto.VradiDTO;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.wikitty.TreeNodeImpl;
import org.sharengo.wikitty.Wikitty;

public class VradiThesaurusDTO
implements VradiDTO<TreeNodeImpl> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(VradiThesaurusDTO.class);
    protected PropertyChangeSupport propertyChange = new PropertyChangeSupport(this);
    protected boolean toSave = false;
    protected boolean toCreate = false;
    protected boolean toDelete = false;
    protected String name;
    protected String wikittyId;
    protected int formsForThesaurus = 0;
    protected String comment;
    protected int order = 0;
    protected VradiThesaurusDTO parentThesaurus;
    protected String tagsAsString;
    protected List<String> tags = new ArrayList<String>();
    protected Map<String, VradiThesaurusDTO> children = new HashMap<String, VradiThesaurusDTO>();
    public static final Comparator<VradiThesaurusDTO> THESAURUS_COMPARATOR = new Comparator<VradiThesaurusDTO>(){

        @Override
        public int compare(VradiThesaurusDTO o1, VradiThesaurusDTO o2) {
            int result = 0;
            if (o1 != null || o2 != null) {
                if (o1.getOrder() == 0 && o2.getOrder() == 0 || o1.getOrder() == o2.getOrder()) {
                    result = o1.getName().compareToIgnoreCase(o2.getName());
                } else if (o1.getOrder() != 0 && o2.getOrder() != 0) {
                    result = new Integer(o1.getOrder()).compareTo(o2.getOrder());
                } else if (o1.getOrder() != 0 && o2.getOrder() == 0) {
                    result = new Integer(o1.getOrder()).compareTo(Integer.MAX_VALUE);
                } else if (o1.getOrder() == 0 && o2.getOrder() != 0) {
                    result = new Integer(o2.getOrder()).compareTo(Integer.MIN_VALUE);
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Comparing " + o1.getOrder() + "-" + o1.getName() + " with " + o2.getOrder() + "-" + o2.getName() + " result : " + result));
                }
            }
            return result;
        }
    };

    public boolean isRoot() {
        return this.parentThesaurus == null;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        int orderOld = this.order;
        this.order = order;
        this.propertyChange.firePropertyChange("order", orderOld, order);
    }

    public boolean isToDelete() {
        return this.toDelete;
    }

    public void setToDelete(boolean toDelete) {
        boolean toDeleteOld = this.toDelete;
        this.toDelete = toDelete;
        for (VradiThesaurusDTO child : this.getChildren()) {
            child.setToDelete(toDelete);
        }
        this.propertyChange.firePropertyChange("toDelete", toDeleteOld, toDelete);
    }

    public boolean isToCreate() {
        return this.toCreate;
    }

    public void setToCreate(boolean toCreate) {
        boolean old = this.toCreate;
        this.toCreate = toCreate;
        this.propertyChange.firePropertyChange("toCreate", old, toCreate);
    }

    public boolean isToSave() {
        return this.toSave;
    }

    public void setToSave(boolean toSave) {
        boolean old = this.toSave;
        this.toSave = toSave;
        this.propertyChange.firePropertyChange("toSave", old, toSave);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String old = this.name;
        this.name = name;
        this.propertyChange.firePropertyChange("name", old, name);
    }

    public String getOrderName() {
        String orderName = this.name;
        if (this.order != 0) {
            orderName = this.order + " - " + this.name;
        }
        return orderName;
    }

    @Override
    public String getWikittyId() {
        return this.wikittyId;
    }

    @Override
    public void setWikittyId(String wikittyId) {
        String old = this.wikittyId;
        this.wikittyId = wikittyId;
        this.propertyChange.firePropertyChange("wikittyId", old, wikittyId);
    }

    public VradiThesaurusDTO getParentThesaurus() {
        return this.parentThesaurus;
    }

    public void setParentThesaurus(VradiThesaurusDTO parentThesaurus) {
        VradiThesaurusDTO old = this.parentThesaurus;
        this.parentThesaurus = parentThesaurus;
        this.propertyChange.firePropertyChange("parentThesaurus", old, parentThesaurus);
    }

    public String getTagsAsString() {
        if (this.tagsAsString == null || this.tagsAsString.isEmpty()) {
            this.initTagsAsString();
        }
        return this.tagsAsString;
    }

    public void initTagsAsString() {
        String tagAsString = "";
        if (this.tags != null) {
            for (String tag : this.tags) {
                tagAsString = tagAsString + tag + ", ";
            }
            if (!tagAsString.isEmpty()) {
                tagAsString = tagAsString.substring(0, tagAsString.length() - 2);
            }
        }
        this.setTagsAsString(tagAsString);
    }

    public void setTagsAsString(String values) {
        String old = this.tagsAsString;
        this.tagsAsString = values;
        this.propertyChange.firePropertyChange("tagsAsString", old, this.tagsAsString);
    }

    protected List<String> getTags() {
        return this.tags;
    }

    protected void setTags(List<String> tags) {
        this.tags = tags;
    }

    protected void addTag(String tag) {
        this.tags.add(tag);
    }

    public int getFormsForThesaurus() {
        return this.formsForThesaurus;
    }

    public int decFormsForThesaurus() {
        if (this.parentThesaurus != null) {
            this.parentThesaurus.decFormsForThesaurus();
        }
        return --this.formsForThesaurus;
    }

    public int incFormsForThesaurus() {
        if (this.parentThesaurus != null) {
            this.parentThesaurus.incFormsForThesaurus();
        }
        return ++this.formsForThesaurus;
    }

    public void setFormsForThesaurus(int formsForThesaurus) {
        this.formsForThesaurus = formsForThesaurus;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        String old = this.comment;
        this.comment = comment;
        this.propertyChange.firePropertyChange("comment", old, comment);
    }

    public List<VradiThesaurusDTO> getChildren() {
        Collection<VradiThesaurusDTO> children = this.children.values();
        ArrayList<VradiThesaurusDTO> result = new ArrayList<VradiThesaurusDTO>(children);
        return result;
    }

    public void addChild(VradiThesaurusDTO element) {
        Map<String, VradiThesaurusDTO> old = this.children;
        this.children.put(element.getWikittyId(), element);
        this.propertyChange.firePropertyChange("children", old, this.children);
    }

    public void clearChildren() {
        Map<String, VradiThesaurusDTO> old = this.children;
        this.children.clear();
        this.propertyChange.firePropertyChange("children", old, this.children);
    }

    public void removeChild(VradiThesaurusDTO child) {
        Map<String, VradiThesaurusDTO> old = this.children;
        this.children.remove(child.getWikittyId());
        this.propertyChange.firePropertyChange("children", old, this.children);
    }

    public List<String> getChildrenRecursif() {
        ArrayList<String> result = new ArrayList<String>();
        for (VradiThesaurusDTO child : this.getChildren()) {
            result.add(child.getWikittyId());
            result.addAll(child.getChildrenRecursif());
        }
        return result;
    }

    public boolean addChildRecursif(VradiThesaurusDTO child) {
        VradiThesaurusDTO p = child.getParentThesaurus();
        if (this.getWikittyId().equals(p.getWikittyId())) {
            this.addChild(child);
            return true;
        }
        Iterator<VradiThesaurusDTO> i$ = this.getChildren().iterator();
        if (i$.hasNext()) {
            VradiThesaurusDTO c = i$.next();
            return c.addChildRecursif(child);
        }
        return false;
    }

    public boolean removeThesaurusRecursivly(VradiThesaurusDTO toRemove) {
        if (this.children.get(toRemove.getWikittyId()) != null) {
            this.removeChild(toRemove);
            return true;
        }
        Iterator<VradiThesaurusDTO> i$ = this.getChildren().iterator();
        if (i$.hasNext()) {
            VradiThesaurusDTO c = i$.next();
            return c.removeThesaurusRecursivly(toRemove);
        }
        return false;
    }

    public VradiThesaurusDTO isNameExisting(String name) {
        if (this.name.equalsIgnoreCase(name)) {
            return this;
        }
        for (VradiThesaurusDTO child : this.getChildren()) {
            VradiThesaurusDTO result = child.isNameExisting(name);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public VradiThesaurusDTO findThesaurus(String id) {
        if (this.wikittyId.equals(id)) {
            return this;
        }
        VradiThesaurusDTO child = this.children.get(id);
        if (child != null) {
            return child;
        }
        for (VradiThesaurusDTO c : this.children.values()) {
            VradiThesaurusDTO foundThesaurus = c.findThesaurus(id);
            if (foundThesaurus == null) continue;
            return foundThesaurus;
        }
        return null;
    }

    public boolean isChildOf(String parentId) {
        if (this.parentThesaurus == null) {
            return false;
        }
        if (this.parentThesaurus.getWikittyId().equals(parentId)) {
            return true;
        }
        return this.parentThesaurus.isChildOf(parentId);
    }

    public String getRecursifName() {
        return this.getRecursifName(this.getOrderName());
    }

    protected String getRecursifName(String name) {
        List<VradiThesaurusDTO> children = this.getChildren();
        for (VradiThesaurusDTO child : children) {
            name = name + ", " + child.getRecursifName();
        }
        return name;
    }

    public String getParentPath(String pathSeparator) {
        if (this.getParentThesaurus() != null && !this.getParentThesaurus().getName().equals("Thesaurus")) {
            return this.getParentThesaurus().getParentPath(pathSeparator) + pathSeparator + this.getParentThesaurus().getOrderName();
        }
        return "";
    }

    public String getNamePath(String pathSeparator) {
        if (this.parentThesaurus != null) {
            return this.parentThesaurus.getNamePath(pathSeparator) + pathSeparator + this.getOrderName();
        }
        return "";
    }

    public String getPath(String pathSeparator) {
        return this.getPath(null, pathSeparator);
    }

    public String getPath(String defName, String pathSeparator) {
        if (this.parentThesaurus != null) {
            return this.parentThesaurus.getPath(defName, pathSeparator) + pathSeparator + this.wikittyId;
        }
        if (defName != null) {
            return defName;
        }
        return this.name;
    }

    public String getBuildPath(String pathSeparator) {
        if (this.parentThesaurus != null) {
            return this.parentThesaurus.getBuildPath(pathSeparator) + pathSeparator + "children[@wikittyId=\"" + this.wikittyId + "\"]";
        }
        return "..";
    }

    public int getDepth() {
        if (this.getParentThesaurus() == null) {
            return 0;
        }
        return 1 + this.getParentThesaurus().getDepth();
    }

    public String toString() {
        return this.getNamePath("/");
    }

    public VradiThesaurusDTO clone() {
        return this.clone(false);
    }

    protected VradiThesaurusDTO clone(boolean parentAlreadyCloned) {
        VradiThesaurusDTO clone = new VradiThesaurusDTO();
        clone.setWikittyId(this.wikittyId);
        clone.setToCreate(this.toCreate);
        clone.setToSave(this.toSave);
        clone.setComment(this.comment);
        clone.setName(this.name);
        clone.setFormsForThesaurus(this.formsForThesaurus);
        for (VradiThesaurusDTO child : this.getChildren()) {
            clone.addChild(child.cloneChild(clone));
        }
        if (!parentAlreadyCloned && this.parentThesaurus != null) {
            clone.setParentThesaurus(this.parentThesaurus.cloneParents(clone));
        }
        clone.setTags(this.tags);
        clone.setTagsAsString(this.tagsAsString);
        clone.setOrder(this.order);
        return clone;
    }

    protected VradiThesaurusDTO cloneParents(VradiThesaurusDTO childClone) {
        VradiThesaurusDTO clone = this.clone(false);
        clone.addChild(childClone);
        return clone;
    }

    protected VradiThesaurusDTO cloneChild(VradiThesaurusDTO parent) {
        VradiThesaurusDTO clone = this.clone(true);
        clone.setParentThesaurus(parent);
        return clone;
    }

    @Override
    public void fromWikitty(TreeNodeImpl treeNode) {
        this.setName(treeNode.getName());
        this.setWikittyId(treeNode.getWikittyId());
        if (treeNode.getExtensionNames().contains("Thesaurus")) {
            this.setTags((List)treeNode.getField("Thesaurus", "tags"));
            Object orderField = treeNode.getField("Thesaurus", "order");
            if (orderField != null) {
                this.setOrder(((BigDecimal)orderField).intValue());
            } else {
                this.setOrder(0);
            }
            this.setComment((String)treeNode.getField("Thesaurus", "comment"));
            this.initTagsAsString();
        }
    }

    @Override
    public void toWikitty(TreeNodeImpl treeNodeImpl) {
        treeNodeImpl.setName(this.getName());
        VradiThesaurusDTO parentThesaurus = this.getParentThesaurus();
        if (parentThesaurus != null) {
            treeNodeImpl.setParent(parentThesaurus.getWikittyId());
        }
        if (!treeNodeImpl.getExtensionNames().contains("Thesaurus")) {
            Wikitty wikitty = treeNodeImpl.getWikitty();
            wikitty.addExtension(Thesaurus.EXTENSION_THESAURUS);
        }
        treeNodeImpl.setField("Thesaurus", "order", (Object)this.order);
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        } else {
            this.tags.clear();
        }
        if (this.tagsAsString != null) {
            for (String tag : this.tagsAsString.split(",")) {
                this.addTag(tag.trim());
            }
        }
        treeNodeImpl.setField("Thesaurus", "tags", this.tags);
        treeNodeImpl.setField("Thesaurus", "comment", (Object)this.comment);
    }

    @Override
    public void reset() {
        this.setWikittyId(null);
        this.setName(null);
        this.setTags(null);
        this.setComment(null);
        this.setToDelete(false);
        this.setToSave(false);
        this.setToCreate(false);
        this.setFormsForThesaurus(0);
        this.setOrder(0);
        this.children = Collections.emptyMap();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChange.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChange.removePropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChange.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChange.removePropertyChangeListener(propertyName, listener);
    }
}

