/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services.dto;

import com.jurismarches.vradi.entities.ModificationTag;
import com.jurismarches.vradi.entities.Status;
import com.jurismarches.vradi.entities.StatusBean;
import com.jurismarches.vradi.services.dto.VradiDTO;
import java.util.Date;
import org.sharengo.wikitty.BusinessEntityWikitty;

public class VradiStatusDTO
extends StatusBean
implements VradiDTO<Status> {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_UP_OR_DOWN = "upOrDown";
    protected Boolean upOrDown = null;

    @Override
    public void fromWikitty(Status wikitty) {
        if (wikitty == null) {
            this.reset();
        } else {
            this.setWikittyId(wikitty.getWikittyId());
            this.setName(wikitty.getName());
            this.setValue(wikitty.getValue());
            this.setDescription(wikitty.getDescription());
            this.setModifiable(wikitty.getModifiable());
            if (wikitty.getExtensionNames().contains(ModificationTag.EXTENSION_MODIFICATION_TAG)) {
                Object lastModified = wikitty.getField("ModificationTag", "lastModified");
                this.setLastModified(lastModified != null ? (Date)lastModified : null);
                Object lastModifier = wikitty.getField("ModificationTag", "lastModifier");
                this.setLastModifier(lastModifier != null ? (String)lastModifier : null);
            } else {
                this.setLastModified(null);
                this.setLastModifier(null);
            }
        }
    }

    @Override
    public void reset() {
        this.setWikittyId(null);
        this.setName(null);
        this.setValue(-1);
        this.setModifiable(false);
        this.setDescription(null);
        this.setLastModified(null);
        this.setLastModifier(null);
    }

    @Override
    public void toWikitty(Status status) {
        status.setName(this.getName());
        status.setValue(this.getValue());
        status.setDescription(this.getDescription());
        status.setModifiable(this.getModifiable());
        if (!status.getExtensionNames().contains("ModificationTag")) {
            ((BusinessEntityWikitty)status).getWikitty().addExtension(ModificationTag.EXTENSION_MODIFICATION_TAG);
        }
        status.setField("ModificationTag", "lastModified", (Object)this.getLastModified());
        status.setField("ModificationTag", "lastModifier", (Object)this.getLastModifier());
    }

    @Override
    public void setWikittyId(String id) {
        String old = this.id;
        this.id = id;
        this.propertyChange.firePropertyChange("wikittyId", old, id);
    }

    public Boolean isUpOrDown() {
        return this.upOrDown;
    }

    public void setUpOrDown(Boolean value) {
        Boolean oldValue = this.upOrDown;
        this.upOrDown = value;
        this.propertyChange.firePropertyChange(PROPERTY_UP_OR_DOWN, oldValue, value);
    }

    public Date getLastModified() {
        return (Date)this.getField("ModificationTag", "lastModified");
    }

    public void setLastModified(Date lastModified) {
        Date oldValue = this.getLastModified();
        this.setField("ModificationTag", "lastModified", lastModified);
        this.propertyChange.firePropertyChange("lastModified", oldValue, lastModified);
    }

    public String getLastModifier() {
        return (String)this.getField("ModificationTag", "lastModifier");
    }

    public void setLastModifier(String lastModifier) {
        String oldValue = this.getLastModifier();
        this.setField("ModificationTag", "lastModifier", lastModifier);
        this.propertyChange.firePropertyChange("lastModifier", oldValue, lastModifier);
    }

    public String toString() {
        return this.getName();
    }
}

