/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services;

import com.jurismarches.vradi.VradiConstants;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Sending;
import com.jurismarches.vradi.entities.Session;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.services.Configuration;
import com.jurismarches.vradi.services.MailingService;
import com.jurismarches.vradi.services.ServiceFactory;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.VradiStorageService;
import com.jurismarches.vradi.services.managers.ClientManager;
import com.jurismarches.vradi.services.managers.FormManager;
import com.jurismarches.vradi.services.managers.FormTypeManager;
import com.jurismarches.vradi.services.managers.MailingManager;
import com.jurismarches.vradi.services.managers.SearchManager;
import com.jurismarches.vradi.services.managers.TemplateManager;
import com.jurismarches.vradi.services.managers.ThesaurusManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.wikitty.BusinessEntity;
import org.sharengo.wikitty.WikittyProxy;

public class MailingServiceImpl
implements MailingService {
    private static final Log log = LogFactory.getLog(MailingServiceImpl.class);
    protected WikittyProxy proxy = ServiceFactory.getWikittyProxy();
    protected ThesaurusManager thesaurusManager = new ThesaurusManager(this.proxy);
    protected FormManager formManager;
    protected FormTypeManager formTypeManager;
    protected ClientManager clientManager = new ClientManager(this.proxy);
    protected SearchManager searchManager;
    protected MailingManager mailingManager;
    protected Timer mailCronTask;

    public MailingServiceImpl() {
        this.formTypeManager = new FormTypeManager(this.proxy);
        this.mailingManager = new MailingManager(this.proxy);
        this.searchManager = new SearchManager(this.proxy, this.thesaurusManager);
        this.formManager = new FormManager(this.proxy, this.thesaurusManager, this.searchManager);
        this.mailCronTask = new Timer();
        this.mailCronTask.schedule((TimerTask)this.mailingManager, 0L, 600000L);
    }

    @Override
    public String[] getDocumentFields(File template) throws VradiException {
        if (template == null) {
            return null;
        }
        TemplateManager templateManager = new TemplateManager(template.getPath());
        return templateManager.getDocumentFields();
    }

    @Override
    public List<File> generateFilledDocumentInPDF(File template, List<Form> forms, Map<String, String> fieldBindings) throws VradiException {
        return this.generateFilledDocumentInPDF(template, forms, fieldBindings, true);
    }

    @Override
    public List<File> generateFilledDocumentInPDF(File template, List<Form> forms, Map<String, String> fieldBindings, boolean replace) throws VradiException {
        ArrayList<File> generatedPDFList = null;
        if (template == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Try to generate form pdf without template");
            }
        } else {
            TemplateManager templateManager = new TemplateManager(template.getPath());
            HashMap<String, String[]> map = new HashMap<String, String[]>();
            for (Map.Entry<String, String> binding : fieldBindings.entrySet()) {
                String fieldFQName = binding.getValue();
                if (fieldFQName == null || fieldFQName.indexOf(".") <= 0) continue;
                int dot = fieldFQName.indexOf(".");
                String[] fqField = new String[]{fieldFQName.substring(0, dot), fieldFQName.substring(dot + 1)};
                map.put(binding.getKey(), fqField);
            }
            generatedPDFList = new ArrayList<File>();
            for (Form form : forms) {
                File f = this.generateFilledDocumentInPDF(templateManager, form, map, replace);
                generatedPDFList.add(f);
            }
        }
        return generatedPDFList;
    }

    protected File generateFilledDocumentInPDF(TemplateManager templateManager, Form form, Map<String, String[]> fieldBindings, boolean replace) throws VradiException {
        File pdfDir = Configuration.getInstance().getPdfDir();
        File result = new File(pdfDir, form.getWikittyId() + ".pdf");
        if (!replace && result.exists()) {
            return result;
        }
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        Iterator<Map.Entry<String, String[]>> i$ = fieldBindings.entrySet().iterator();
        while (i$.hasNext()) {
            String[] fqField;
            Object value;
            Map.Entry<String, String[]> binding;
            fieldValues.put(binding.getKey(), (value = form.getField((fqField = (binding = i$.next()).getValue())[0], fqField[1])) != null ? value.toString() : null);
        }
        ArrayList<File> attachments = new ArrayList<File>();
        if (form.getFiles() != null) {
            File embededFilesDir = Configuration.getInstance().getEmbededFilesDir();
            File formFilesDir = new File(embededFilesDir, form.getWikittyId());
            for (String file : form.getFiles()) {
                File f = new File(formFilesDir, file);
                attachments.add(f);
            }
        }
        templateManager.generateDoc(result.getPath(), fieldValues, attachments.toArray(new File[attachments.size()]));
        return result;
    }

    @Override
    public Session sendMessages(Session session, List<Sending> sendings) throws VradiException {
        VradiStorageService storageService = ServiceFactory.getVradiStorageService();
        boolean resumeSession = false;
        if (session.getStatus() == VradiConstants.SessionStatus.STOPPED.getValue()) {
            log.info((Object)"Session was stopped, resume sending");
            session.setStatus(VradiConstants.SessionStatus.ACTIVE.getValue());
            session = storageService.updateEntity(session);
            resumeSession = true;
        }
        for (Sending sending : sendings) {
            if ((session = storageService.getEntity(session.getWikittyId(), Session.class)).getStatus() == VradiConstants.SessionStatus.STOPPED.getValue()) {
                log.warn((Object)"Sending stopped by user");
                return session;
            }
            if (resumeSession && sending.getStatus() != VradiConstants.SendingStatus.TO_SEND.getValue()) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Sending " + sending.getWikittyId() + " already sent, skip"));
                continue;
            }
            this.sendMessage(sending, session.getParagraph());
        }
        session.setStatus(VradiConstants.SessionStatus.SENT.getValue());
        session.setSessionDate(new Date());
        session = storageService.updateEntity(session);
        return session;
    }

    @Override
    public Sending sendMessage(Sending sending, String sessionParagraph) throws VradiException {
        return this.sendMessage(sending, sessionParagraph, null);
    }

    @Override
    public Sending sendMessage(Sending sending, String sessionParagraph, String email) throws VradiException {
        if (sending.getStatus() == VradiConstants.SendingStatus.ERROR.getValue() || sending.getStatus() == VradiConstants.SendingStatus.DELETED.getValue()) {
            return sending;
        }
        VradiStorageService storageService = ServiceFactory.getVradiStorageService();
        if (sending.getUser() == null) {
            sending.setStatus(VradiConstants.SendingStatus.SENT.getValue());
            return storageService.updateEntity(sending);
        }
        if (email == null || email.isEmpty()) {
            User user = this.clientManager.getUser(sending.getUser());
            email = user.getEmail();
        }
        String subject = Configuration.getInstance().getOfferMailSubject();
        String message = sessionParagraph + "\n\n" + sending.getParagraph();
        List<Form> forms = this.formManager.getForms(new ArrayList<String>(sending.getForm()));
        boolean receptionProof = sending.getReceptionProof();
        String messageId = null;
        try {
            messageId = this.mailingManager.postMail(email, subject, message, forms, receptionProof);
        }
        catch (VradiException eee) {
            sending.setStatus(VradiConstants.SendingStatus.ERROR.getValue());
            this.proxy.store((BusinessEntity)sending);
            throw eee;
        }
        sending.setMessageId(messageId);
        sending.setStatus(receptionProof ? VradiConstants.SendingStatus.WAITING_RECEPTION_PROOF.getValue() : VradiConstants.SendingStatus.SENT.getValue());
        sending = storageService.updateEntity(sending);
        return sending;
    }

    @Override
    public void receiveMessages() throws VradiException {
        this.mailingManager.receiveMails();
    }

    @Override
    public Session stopSentMail(Session session) throws VradiException {
        session.setStatus(VradiConstants.SessionStatus.STOPPED.getValue());
        session = ServiceFactory.getVradiStorageService().updateEntity(session);
        return session;
    }
}

