/*
 * *##%
 * Vradi :: Services
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
package com.jurismarches.vradi.services.dto;

import java.util.Date;

import org.sharengo.wikitty.BusinessEntityWikitty;

import com.jurismarches.vradi.entities.ModificationTag;
import com.jurismarches.vradi.entities.Status;
import com.jurismarches.vradi.entities.StatusBean;

/**
 * User: chemit
 * Date: 29 oct. 2009
 * Time: 22:23:27
 */
public class VradiStatusDTO extends StatusBean implements VradiDTO<Status> {

    private static final long serialVersionUID = 1L;
    
    public static final String PROPERTY_UP_OR_DOWN = "upOrDown";

    //true if up, false if down, else null
    protected Boolean upOrDown = null;

    @Override
    public void fromWikitty(Status wikitty) {
        if (wikitty == null) {
            reset();
        } else {
            setWikittyId(wikitty.getWikittyId());
            setName(wikitty.getName());
            setValue(wikitty.getValue());
            setDescription(wikitty.getDescription());
            setModifiable(wikitty.getModifiable());
            
            if (wikitty.getExtensionNames().contains(ModificationTag.EXTENSION_MODIFICATION_TAG)) {
                Object lastModified = wikitty.getField(ModificationTag.EXT_MODIFICATION_TAG,
                        ModificationTag.FIELD_LAST_MODIFIED);
                setLastModified(lastModified != null ? (Date) lastModified : null);
                Object lastModifier = wikitty.getField(ModificationTag.EXT_MODIFICATION_TAG,
                        ModificationTag.FIELD_LAST_MODIFIER);
                setLastModifier(lastModifier != null ? (String) lastModifier : null);
            } else {
                setLastModified(null);
                setLastModifier(null);
            }
        }
    }

    public void reset() {
        setWikittyId(null);
        setName(null);
        setValue(-1);
        setModifiable(false);
        setDescription(null);
        setLastModified(null);
        setLastModifier(null);
    }

    @Override
    public void toWikitty(Status status) {
        status.setName(getName());
        status.setValue(getValue());
        status.setDescription(getDescription());
        status.setModifiable(getModifiable());
        if (!status.getExtensionNames().contains(ModificationTag.EXT_MODIFICATION_TAG)) {
            ((BusinessEntityWikitty)status).getWikitty()
                    .addExtension(ModificationTag.EXTENSION_MODIFICATION_TAG);
        }
        status.setField(ModificationTag.EXT_MODIFICATION_TAG, ModificationTag.FIELD_LAST_MODIFIED, getLastModified());
        status.setField(ModificationTag.EXT_MODIFICATION_TAG, ModificationTag.FIELD_LAST_MODIFIER, getLastModifier());
    }

    @Override
    public void setWikittyId(String id) {
        String old = this.id;
        this.id = id;
        propertyChange.firePropertyChange("wikittyId", old, id);
    }

    public Boolean isUpOrDown() {
        return upOrDown;
    }

    public void setUpOrDown(Boolean value) {
        Boolean oldValue = this.upOrDown;
        this.upOrDown = value;
        propertyChange.firePropertyChange(PROPERTY_UP_OR_DOWN, oldValue, value);
    }

    public Date getLastModified() {
        return (Date) this.getField(ModificationTag.EXT_MODIFICATION_TAG,
                ModificationTag.FIELD_LAST_MODIFIED);
    }

    public void setLastModified(Date lastModified) {
        Date oldValue = getLastModified();
        this.setField(ModificationTag.EXT_MODIFICATION_TAG,
                ModificationTag.FIELD_LAST_MODIFIED, lastModified);
        propertyChange.firePropertyChange("lastModified",
                oldValue, lastModified);
    }

    public String getLastModifier() {
        return (String) this.getField(ModificationTag.EXT_MODIFICATION_TAG,
                ModificationTag.FIELD_LAST_MODIFIER);
    }

    public void setLastModifier(String lastModifier) {
        String oldValue = getLastModifier();
        this.setField(ModificationTag.EXT_MODIFICATION_TAG,
                ModificationTag.FIELD_LAST_MODIFIER, lastModifier);
        propertyChange.firePropertyChange("lastModifier",
                oldValue, lastModifier);
    }

    @Override
    public String toString() {
        return getName();
    }
}