package com.jurismarches.vradi.services.dto;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

import org.sharengo.wikitty.TreeNodeImpl;

import com.jurismarches.vradi.entities.Form;

/**
 * VradiCartographyDTO.
 *
 * @author schorlet
 * @version $Revision: 729 $ $Date: 2010-04-20 11:57:04 +0200 (mar., 20 avril 2010) $
 * @since 19 avr. 2010 16:58:00
 */
public class VradiCartographyDTO implements Serializable {

    private static final long serialVersionUID = -2575746133856007541L;

    private final Map<TreeNodeImpl, Integer> cartography;
    private final List<Form> forms;
    
    public VradiCartographyDTO(Map<TreeNodeImpl, Integer> cartography, List<Form> forms) {
        this.cartography = cartography;
        this.forms = forms;
    }

    public Map<TreeNodeImpl, Integer> getCartography() {
        return cartography;
    }

    public List<Form> getForms() {
        return forms;
    }
}
