package com.jurismarches.vradi;

import java.text.SimpleDateFormat;

import static org.nuiton.i18n.I18n._;

/**
 * VradiConstants.
 *
 * @author $Author: sletellier $
 * @version $Revision: 806 $ $Date: 2010-04-29 10:43:37 +0200 (jeu., 29 avril 2010) $
 * @since 2 mars 2010 15:37:19
 */
public class VradiConstants {

    private VradiConstants() {}
    
    /**
     * name of root thesaurus node.
     */
    public static final String ROOT_THESAURUS_NAME = "Thesaurus";

    // names of feed elements
    public static final String CHANNEL = "channel";
    public static final String ENTRY = "entry";
    public static final String ITEM = "item";
    
    /**
     * Form Id date format.
     */
    public static final SimpleDateFormat FORM_ID_DATE_FORMAT =
            new SimpleDateFormat("yyyy-MM-dd");
    
    /**
     * default value of the sending paragraph.
     */
    public static final String DEFAULT_SENDING_PARAGRAPH = "";
    
    /**
     * default value of the sending status.
     */
    public static final int DEFAULT_SENDING_STATUS = 0;
    
    /**
     * Forms Status.
     */
    public enum FormStatus {
        NON_TRAITE("Non traité", "par défaut toute nouvelle information", 0),
        NON_SELECTIONNE("Non sélectionné", "Traité  et non sélectionné", 1),
        PRESELECTIONNE("Préselectionné", "Traité  et présélectionné", 2),
        SELECTIONNE("Sélectionné", "Traité  et sélectionné", 3);
        
        private final String name;
        private final String description;
        private final int value;
        
        private FormStatus(String name, String description, int value) {
            this.name = name;
            this.description = description;
            this.value = value;
        }

        public String getName() {
            return name;
        }

        public String getDescription() {
            return description;
        }

        public int getValue() {
            return value;
        }
    }
    
    /**
     * Sending Status.
     */
    public enum SendingStatus {
        DELETED(-1, _("vradi.email.status.deleted")),
        TO_SEND(0, _("vradi.email.status.toSend")),
        SENT(1, _("vradi.email.status.sent")),
        WAITING_RECEPTION_PROOF(2, _("vradi.email.status.waitingReceptionProof")),
        RECEIVED(3, _("vradi.email.status.received")),
        ERROR(4, _("vradi.email.status.error"));
        
        private final int value;
        private final String description;
        
        private SendingStatus(int value, String description) {
            this.value = value;
            this.description = description;
        }

        public String getDescription() {
            return description;
        }

        public int getValue() {
            return value;
        }

        public static SendingStatus getStatus(int i){
            for (SendingStatus status : values()){
                if (status.getValue() == i){
                    return status;
                }
            }
            return null;
        }
    }

    /**
     * Session status.
     */
    public enum SessionStatus {
        ACTIVE(0, _("vradi.sessionStatus.active")),
        STOPPED(1, _("vradi.sessionStatus.stopped")),
        SENT(2, _("vradi.sessionStatus.sent")),
        CLOSE(3, _("vradi.sessionStatus.close")),
        ERROR(4, _("vradi.sessionStatus.error"));

        private final int value;
        private final String description;

        private SessionStatus(int value, String description) {
            this.value = value;
            this.description = description;
        }

        public int getValue() {
            return value;
        }

        public String getDescription() {
            return description;
        }

        public static SessionStatus getStatus(int i){
            for (SessionStatus status : values()){
                if (status.getValue() == i){
                    return status;
                }
            }
            return null;
        }
    }

    /**
     * XmlStreamConfig.
     */
    public enum XmlStreamConfig {
        DAYS("vradi.adminXmlStream.config.interval.days"),
        HOURS("vradi.adminXmlStream.config.interval.hours"),
        MINUTES("vradi.adminXmlStream.config.interval.minutes"),
        XML_STREAMS("vradi.xmlStreams"),
        XML_STREAMS_CONFIG("vradi.xmlStreams.config"),
        XML_STREAMS_CONFIG_INTERVAL("vradi.xmlStreams.config.interval"),
        XML_STREAMS_CONFIG_INTERVAL_UNIT("vradi.xmlStreams.config.interval.unit"),
        XML_STREAMS_CONFIG_INTERVAL_VALUE("vradi.xmlStreams.config.interval.value"),
        XML_STREAMS_CONFIG_INTERVAL_HOUR("vradi.xmlStreams.config.interval.hour"),
        XML_STREAMS_CONFIG_INTERVAL_MINUTE("vradi.xmlStreams.config.interval.minute");
        
        private final String value;
        
        private XmlStreamConfig(String value) {
            this.value = value;
        }
        @Override
        public String toString() {
            return value;
        }
    }
    
    public enum FormTypeTemplateEnum {
        FIELDS_ELEMENT("fields"),
        FIELD_ELEMENT("field"),
        FIELD_TEMPLATE_ATTRIBUTE("template"),
        FIELD_EXTENSION_ATTRIBUTE("extension");
        
        private final String value;
        
        private FormTypeTemplateEnum(String value) {
            this.value = value;
        }
        @Override
        public String toString() {
            return value;
        }
    }
}
