/*
 * *##% 
 * vradi-services
 * Copyright (C) 2009 JurisMarches
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
package com.jurismarches.vradi.services;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.sharengo.exceptions.TechnicalException;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

/**
 * @author morin
 */
public class XmlStreamServiceImpl implements XmlStreamService {

    static private final Log log = LogFactory.getLog(VradiStorageServiceImpl.class);

    protected static String channel = "channel";
    protected static String entry = "entry";
    protected static String feed = "feed";
    protected static String item = "item";
    protected static String opt = "opt";
    protected static String rdf = "rdf";


    @Override
    public List<String> getRSSFields(String url) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug("getRSSFields");
        }
        List<String> result = new ArrayList<String>();
        SAXBuilder sxb = new SAXBuilder();
        URL rssUrl = null;
        try {
            rssUrl = new URL(url);
        } catch (MalformedURLException e) {
            log.error(e);
            throw new TechnicalException();
        }
        log.debug("well formed URL");
        Document document = null;
        try {
            document = sxb.build(rssUrl);
        } catch (JDOMException e) {
            log.error(e);
            throw new TechnicalException();
        } catch (IOException e) {
            log.error(e);
            throw new TechnicalException();
        }
        Element racine = document.getRootElement();
        log.debug(racine.getName());
        Element itemElt = null;
        if (racine.getChild(item) != null) {
            itemElt = racine.getChild(item);
        } else if (racine.getChild(entry) != null) {
            itemElt = racine.getChild(entry);
        } else if (racine.getChild(channel) != null) {
            itemElt = racine.getChild(channel).getChild(item);
        }
        if (itemElt != null) {
            for (Element elt : (List<Element>) itemElt.getChildren()) {
                result.add(elt.getName());
            }
        }
        return result;
    }

    public void test(String url) {
        if (log.isDebugEnabled()) {
            log.debug("test");
        }
        try {
            SAXBuilder sxb = new SAXBuilder();
            URL rssUrl = new URL(url);
            Document document = sxb.build(rssUrl);
            Element racine = document.getRootElement();
            //Element chan = racine.getChild(channel);

            for (Element elt : (List<Element>) racine.getChildren()) {
                browseRSS(elt.getChildren());
            }
        } catch (Exception e) {
            System.out.println(e);
        }
    }

    protected void browseRSS(List<Element> list) {
        if (log.isDebugEnabled()) {
            log.debug("browseRSS");
        }
        for (Element aList : list) {
            Element e = aList;
            if (!e.getTextTrim().isEmpty()) {
                //TODO utiliser une logger plutôt !
                System.out.println(e.getQualifiedName() + " " + e.getTextTrim());
            }
            browseRSS(e.getChildren());
        }
        System.out.println("");
    }

}
