/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet.impl.write;

import com.jerolba.carpet.AnnotatedLevels;
import com.jerolba.carpet.RecordTypeConversionException;
import com.jerolba.carpet.impl.write.BigDecimalWrite;
import com.jerolba.carpet.impl.write.CarpetWriteConfiguration;
import com.jerolba.carpet.impl.write.DecimalConfig;
import com.jerolba.carpet.impl.write.FieldTypeInspect;
import com.jerolba.carpet.impl.write.SchemaBuilder;
import com.jerolba.carpet.model.BigDecimalType;
import com.jerolba.carpet.model.BinaryLogicalType;
import com.jerolba.carpet.model.CollectionType;
import com.jerolba.carpet.model.FieldType;
import com.jerolba.carpet.model.MapType;
import com.jerolba.carpet.model.WriteField;
import com.jerolba.carpet.model.WriteRecordModelType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.parquet.schema.ConversionPatterns;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;

class WriteRecordModel2Schema {
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private static final String ELEMENT = "element";
    private final CarpetWriteConfiguration carpetConfiguration;

    public WriteRecordModel2Schema(CarpetWriteConfiguration carpetConfiguration) {
        this.carpetConfiguration = carpetConfiguration;
    }

    public MessageType createSchema(WriteRecordModelType<?> writeRecordModelType) {
        HashSet visited = new HashSet();
        this.validateNotVisitedRecord(writeRecordModelType, visited);
        String groupName = writeRecordModelType.getClassType().getSimpleName();
        List<Type> fields = this.createGroupFields(writeRecordModelType, visited);
        return new MessageType(groupName, fields);
    }

    private List<Type> createGroupFields(WriteRecordModelType<?> writeRecordModelType, Set<WriteRecordModelType<?>> visited) {
        ArrayList<Type> fields = new ArrayList<Type>();
        for (WriteField<?> recordField : writeRecordModelType.getFields()) {
            Type.Repetition repetition = WriteRecordModel2Schema.getTypeRepetition(recordField.fieldType());
            Type type = this.createType(recordField.fieldType(), recordField.parquetFieldName(), repetition, visited);
            if (type != null) {
                fields.add(type);
                continue;
            }
            throw new RecordTypeConversionException("Column '" + recordField.parquetFieldName() + "' of type " + recordField.fieldType().getClass().getName() + " not supported");
        }
        return fields;
    }

    private Type createType(FieldType fieldtype, String parquetFieldName, Type.Repetition repetition, Set<WriteRecordModelType<?>> visited) {
        if (fieldtype instanceof CollectionType) {
            CollectionType collectionType = (CollectionType)fieldtype;
            return this.createCollectionType(parquetFieldName, collectionType.type(), repetition, visited);
        }
        if (fieldtype instanceof MapType) {
            MapType mapType = (MapType)fieldtype;
            return this.createMapType(parquetFieldName, mapType, repetition, visited);
        }
        return this.buildIfNonCollectionParquetType(fieldtype, parquetFieldName, repetition, visited);
    }

    private Type createCollectionType(String parquetFieldName, FieldType collectionType, Type.Repetition repetition, Set<WriteRecordModelType<?>> visited) {
        return switch (this.carpetConfiguration.annotatedLevels()) {
            default -> throw new IncompatibleClassChangeError();
            case AnnotatedLevels.ONE -> this.createCollectionOneLevel(parquetFieldName, collectionType, visited);
            case AnnotatedLevels.TWO -> this.createCollectionTwoLevel(parquetFieldName, collectionType, repetition, visited);
            case AnnotatedLevels.THREE -> this.createCollectionThreeLevel(parquetFieldName, collectionType, repetition, visited);
        };
    }

    private Type createCollectionOneLevel(String parquetFieldName, FieldType parametized, Set<WriteRecordModelType<?>> visited) {
        if (parametized instanceof CollectionType) {
            throw new RecordTypeConversionException("Recursive collections not supported in annotated 1-level structures");
        }
        if (parametized instanceof MapType) {
            MapType mapType = (MapType)parametized;
            return this.createMapType(parquetFieldName, mapType, Type.Repetition.REPEATED, visited);
        }
        return this.buildTypeElement(parquetFieldName, parametized, Type.Repetition.REPEATED, visited);
    }

    private Type createCollectionTwoLevel(String parquetFieldName, FieldType parametized, Type.Repetition repetition, Set<WriteRecordModelType<?>> visited) {
        Type nested = this.createNestedCollection(parametized, Type.Repetition.REPEATED, visited);
        return ConversionPatterns.listType((Type.Repetition)repetition, (String)parquetFieldName, (Type)nested);
    }

    private Type createCollectionThreeLevel(String parquetFieldName, FieldType parametized, Type.Repetition repetition, Set<WriteRecordModelType<?>> visited) {
        Type nested = this.createNestedCollection(parametized, WriteRecordModel2Schema.getTypeRepetition(parametized), visited);
        return ConversionPatterns.listOfElements((Type.Repetition)repetition, (String)parquetFieldName, (Type)nested);
    }

    private Type createNestedCollection(FieldType parametized, Type.Repetition repetition, Set<WriteRecordModelType<?>> visited) {
        if (parametized instanceof CollectionType) {
            CollectionType collectionType = (CollectionType)parametized;
            return this.createCollectionType(ELEMENT, collectionType.type(), repetition, visited);
        }
        if (parametized instanceof MapType) {
            MapType mapType = (MapType)parametized;
            return this.createMapType(ELEMENT, mapType, repetition, visited);
        }
        return this.buildTypeElement(ELEMENT, parametized, repetition, visited);
    }

    private Type createMapType(String parquetFieldName, MapType mapType, Type.Repetition repetition, Set<WriteRecordModelType<?>> visited) {
        FieldType keyType = mapType.keyType();
        Type nestedKey = this.buildTypeElement(KEY, keyType, Type.Repetition.REQUIRED, visited);
        Type nestedValue = null;
        FieldType valueType = mapType.valueType();
        Type.Repetition valueRepetition = WriteRecordModel2Schema.getTypeRepetition(valueType);
        if (valueType instanceof CollectionType) {
            CollectionType collectionType = (CollectionType)valueType;
            nestedValue = this.createCollectionType(VALUE, collectionType.type(), valueRepetition, visited);
        } else if (valueType instanceof MapType) {
            MapType innerMapType = (MapType)valueType;
            nestedValue = this.createMapType(VALUE, innerMapType, valueRepetition, visited);
        } else {
            nestedValue = this.buildTypeElement(VALUE, valueType, valueRepetition, visited);
        }
        if (nestedKey != null && nestedValue != null) {
            return (Type)((Types.MapBuilder)((Types.MapBuilder)Types.map((Type.Repetition)repetition).key(nestedKey)).value(nestedValue)).named(parquetFieldName);
        }
        throw new RecordTypeConversionException("Unsuported type in Map");
    }

    private Type buildTypeElement(String name, FieldType type, Type.Repetition repetition, Set<WriteRecordModelType<?>> visited) {
        Type parquetType = this.buildIfNonCollectionParquetType(type, name, repetition, visited);
        if (parquetType == null) {
            throw new RecordTypeConversionException("Unsuported type " + String.valueOf(type));
        }
        return parquetType;
    }

    private Type buildIfNonCollectionParquetType(FieldType type, String parquetFieldName, Type.Repetition repetition, Set<WriteRecordModelType<?>> visited) {
        FieldTypeInspect javaType = new FieldTypeInspect(type);
        if (javaType.isInteger()) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).named(parquetFieldName);
        }
        if (javaType.isLong()) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).named(parquetFieldName);
        }
        if (javaType.isFloat()) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FLOAT, (Type.Repetition)repetition).named(parquetFieldName);
        }
        if (javaType.isDouble()) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, (Type.Repetition)repetition).named(parquetFieldName);
        }
        if (javaType.isBoolean()) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BOOLEAN, (Type.Repetition)repetition).named(parquetFieldName);
        }
        if (javaType.isShort()) {
            return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)16, (boolean)true))).named(parquetFieldName);
        }
        if (javaType.isByte()) {
            return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)8, (boolean)true))).named(parquetFieldName);
        }
        if (javaType.isString()) {
            return this.buildStringType(javaType.binaryLogicalType(), repetition, parquetFieldName);
        }
        if (javaType.isBinary()) {
            return this.buildBinaryType(javaType.binaryLogicalType(), repetition, parquetFieldName);
        }
        if (javaType.isEnum()) {
            return this.buildEnumType(javaType.binaryLogicalType(), repetition, parquetFieldName);
        }
        if (javaType.isUuid()) {
            return SchemaBuilder.buildUuidType(repetition, parquetFieldName);
        }
        if (javaType.isBigDecimal()) {
            BigDecimalType bigDecimalType = (BigDecimalType)type;
            DecimalConfig config = BigDecimalWrite.buildDecimalConfig(bigDecimalType.precision(), bigDecimalType.scale(), bigDecimalType.roundingMode(), this.carpetConfiguration.decimalConfig());
            return SchemaBuilder.buildDecimalTypeItem(repetition, parquetFieldName, config);
        }
        if (javaType.isLocalDate()) {
            return SchemaBuilder.buildLocalDateType(repetition, parquetFieldName);
        }
        if (javaType.isLocalTime()) {
            return SchemaBuilder.buildLocalTimeType(repetition, parquetFieldName, this.carpetConfiguration.defaultTimeUnit(), this.carpetConfiguration.defaultTimeIsAdjustedToUTC());
        }
        if (javaType.isLocalDateTime()) {
            return SchemaBuilder.buildLocalDateTimeType(repetition, parquetFieldName, this.carpetConfiguration.defaultTimeUnit());
        }
        if (javaType.isInstant()) {
            return SchemaBuilder.buildInstantType(repetition, parquetFieldName, this.carpetConfiguration.defaultTimeUnit());
        }
        if (type instanceof WriteRecordModelType) {
            WriteRecordModelType childWriteRecordType = (WriteRecordModelType)type;
            List<Type> childFields = this.buildChildFields(childWriteRecordType, visited);
            return new GroupType(repetition, parquetFieldName, childFields);
        }
        return null;
    }

    private Type buildStringType(BinaryLogicalType logicalType, Type.Repetition repetition, String parquetFieldName) {
        Types.PrimitiveBuilder binary = Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition);
        if (logicalType == null) {
            return (Type)((Types.PrimitiveBuilder)binary.as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named(parquetFieldName);
        }
        return switch (logicalType) {
            default -> throw new IncompatibleClassChangeError();
            case BinaryLogicalType.JSON -> (PrimitiveType)((Types.PrimitiveBuilder)binary.as((LogicalTypeAnnotation)LogicalTypeAnnotation.jsonType())).named(parquetFieldName);
            case BinaryLogicalType.ENUM -> (PrimitiveType)((Types.PrimitiveBuilder)binary.as((LogicalTypeAnnotation)LogicalTypeAnnotation.enumType())).named(parquetFieldName);
            case BinaryLogicalType.STRING -> (PrimitiveType)((Types.PrimitiveBuilder)binary.as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named(parquetFieldName);
            case BinaryLogicalType.BSON -> throw new RecordTypeConversionException("Unsupported logical type for String: " + String.valueOf((Object)logicalType));
        };
    }

    private Type buildBinaryType(BinaryLogicalType logicalType, Type.Repetition repetition, String parquetFieldName) {
        Types.PrimitiveBuilder binary = Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition);
        if (logicalType == null) {
            return (Type)binary.named(parquetFieldName);
        }
        return switch (logicalType) {
            default -> throw new IncompatibleClassChangeError();
            case BinaryLogicalType.STRING -> (PrimitiveType)((Types.PrimitiveBuilder)binary.as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named(parquetFieldName);
            case BinaryLogicalType.ENUM -> (PrimitiveType)((Types.PrimitiveBuilder)binary.as((LogicalTypeAnnotation)LogicalTypeAnnotation.enumType())).named(parquetFieldName);
            case BinaryLogicalType.JSON -> (PrimitiveType)((Types.PrimitiveBuilder)binary.as((LogicalTypeAnnotation)LogicalTypeAnnotation.jsonType())).named(parquetFieldName);
            case BinaryLogicalType.BSON -> (PrimitiveType)((Types.PrimitiveBuilder)binary.as((LogicalTypeAnnotation)LogicalTypeAnnotation.bsonType())).named(parquetFieldName);
        };
    }

    private Type buildEnumType(BinaryLogicalType logicalType, Type.Repetition repetition, String parquetFieldName) {
        Types.PrimitiveBuilder binary = Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition);
        if (logicalType == null) {
            return (Type)((Types.PrimitiveBuilder)binary.as((LogicalTypeAnnotation)LogicalTypeAnnotation.enumType())).named(parquetFieldName);
        }
        return switch (logicalType) {
            default -> throw new IncompatibleClassChangeError();
            case BinaryLogicalType.STRING -> (PrimitiveType)((Types.PrimitiveBuilder)binary.as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named(parquetFieldName);
            case BinaryLogicalType.ENUM -> (PrimitiveType)((Types.PrimitiveBuilder)binary.as((LogicalTypeAnnotation)LogicalTypeAnnotation.enumType())).named(parquetFieldName);
            case BinaryLogicalType.JSON, BinaryLogicalType.BSON -> throw new RecordTypeConversionException("Unsupported logical type for String: " + String.valueOf((Object)logicalType));
        };
    }

    private List<Type> buildChildFields(WriteRecordModelType<?> writeRecordType, Set<WriteRecordModelType<?>> visited) {
        this.validateNotVisitedRecord(writeRecordType, visited);
        List<Type> fields = this.createGroupFields(writeRecordType, visited);
        visited.remove(writeRecordType);
        return fields;
    }

    private void validateNotVisitedRecord(WriteRecordModelType<?> recordClass, Set<WriteRecordModelType<?>> visited) {
        if (visited.contains(recordClass)) {
            throw new RecordTypeConversionException("Recusive records are not supported");
        }
        visited.add(recordClass);
    }

    private static Type.Repetition getTypeRepetition(FieldType parametized) {
        return parametized.isNotNull() ? Type.Repetition.REQUIRED : Type.Repetition.OPTIONAL;
    }
}

