/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android.standalonemojos;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.MonkeyTestRunner;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.jayway.maven.plugins.android.AbstractAndroidMojo;
import com.jayway.maven.plugins.android.DeviceCallback;
import com.jayway.maven.plugins.android.common.DeviceHelper;
import com.jayway.maven.plugins.android.config.ConfigHandler;
import com.jayway.maven.plugins.android.config.ConfigPojo;
import com.jayway.maven.plugins.android.config.PullParameter;
import com.jayway.maven.plugins.android.configuration.Monkey;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

@Mojo(name="monkey")
public class MonkeyMojo
extends AbstractAndroidMojo {
    @Parameter(property="maven.test.skip", defaultValue="false", readonly=true)
    private boolean mavenTestSkip;
    @Parameter(property="skipTests", defaultValue="false", readonly=true)
    private boolean mavenSkipTests;
    @Parameter(property="maven.test.failure.ignore", defaultValue="false", readonly=true)
    private boolean mavenTestFailureIgnore;
    @Parameter(property="testFailureIgnore", defaultValue="false", readonly=true)
    private boolean mavenIgnoreTestFailure;
    @ConfigPojo
    @Parameter
    private Monkey monkey;
    @Parameter(property="android.monkey.skip")
    private Boolean monkeySkip;
    @PullParameter(defaultValue={"true"})
    private Boolean parsedSkip;
    @Parameter(property="android.monkey.eventCount")
    private Integer monkeyEventCount;
    @PullParameter(required=true, defaultValue={"1000"})
    private Integer parsedEventCount;
    @Parameter(property="android.monkey.seed")
    private Long monkeySeed;
    @PullParameter(required=false, defaultValueGetterMethod="getSeed")
    private Long parsedSeed;
    @Parameter(property="android.monkey.throttle")
    private Long monkeyThrottle;
    @PullParameter(required=false, defaultValueGetterMethod="getThrottle")
    private Long parsedThrottle;
    @Parameter(property="android.monkey.percentTouch")
    private Integer monkeyPercentTouch;
    @PullParameter(required=false, defaultValueGetterMethod="getPercentTouch")
    private Integer parsedPercentTouch;
    @Parameter(property="android.monkey.percentMotion")
    private Integer monkeyPercentMotion;
    @PullParameter(required=false, defaultValueGetterMethod="getPercentMotion")
    private Integer parsedPercentMotion;
    @Parameter(property="android.monkey.percentTrackball")
    private Integer monkeyPercentTrackball;
    @PullParameter(required=false, defaultValueGetterMethod="getPercentTrackball")
    private Integer parsedPercentTrackball;
    @Parameter(property="android.monkey.percentNav")
    private Integer monkeyPercentNav;
    @PullParameter(required=false, defaultValueGetterMethod="getPercentNav")
    private Integer parsedPercentNav;
    @Parameter(property="android.monkey.percentMajorNav")
    private Integer monkeyPercentMajorNav;
    @PullParameter(required=false, defaultValueGetterMethod="getPercentMajorNav")
    private Integer parsedPercentMajorNav;
    @Parameter(property="android.monkey.percentSyskeys")
    private Integer monkeyPercentSyskeys;
    @PullParameter(required=false, defaultValueGetterMethod="getPercentSyskeys")
    private Integer parsedPercentSyskeys;
    @Parameter(property="android.monkey.percentAppswitch")
    private Integer monkeyPercentAppswitch;
    @PullParameter(required=false, defaultValueGetterMethod="getPercentAppswitch")
    private Integer parsedPercentAppswitch;
    @Parameter(property="android.monkey.percentAnyevent")
    private Integer monkeyPercentAnyEvent;
    @PullParameter(required=false, defaultValueGetterMethod="getPercentAnyevent")
    private Integer parsedPercentAnyevent;
    @Parameter(property="android.monkey.packages")
    private String[] monkeyPackages;
    @PullParameter(required=false, defaultValueGetterMethod="getPackages")
    private String[] parsedPackages;
    @Parameter(property="android.monkey.categories")
    private String[] monkeyCategories;
    @PullParameter(required=false, defaultValueGetterMethod="getCategories")
    private String[] parsedCategories;
    @Parameter(property="android.monkey.debugNoEvents")
    private Boolean monkeyDebugNoEvents;
    @PullParameter(defaultValue={"false"})
    private Boolean parsedDebugNoEvents;
    @Parameter(property="android.monkey.Hprof")
    private Boolean monkeyHprof;
    @PullParameter(defaultValue={"false"})
    private Boolean parsedHprof;
    @Parameter(property="android.monkey.ignoreCrashes")
    private Boolean monkeyIgnoreCrashes;
    @PullParameter(defaultValue={"false"})
    private Boolean parsedIgnoreCrashes;
    @Parameter(property="android.monkey.IgnoreTimeouts")
    private Boolean monkeyIgnoreTimeouts;
    @PullParameter(defaultValue={"false"})
    private Boolean parsedIgnoreTimeouts;
    @Parameter(property="android.monkey.IgnoreSecurityExceptions")
    private Boolean monkeyIgnoreSecurityExceptions;
    @PullParameter(defaultValue={"false"})
    private Boolean parsedIgnoreSecurityExceptions;
    @Parameter(property="android.monkey.KillProcessAfterError")
    private Boolean monkeyKillProcessAfterError;
    @PullParameter(defaultValue={"false"})
    private Boolean parsedKillProcessAfterError;
    @Parameter(property="android.monkey.MonitorNativeCrashes")
    private Boolean monkeyMonitorNativeCrashes;
    @PullParameter(defaultValue={"false"})
    private Boolean parsedMonitorNativeCrashes;
    @Parameter(property="android.monkey.createReport")
    private Boolean monkeyCreateReport;
    @PullParameter(defaultValue={"false"})
    private Boolean parsedCreateReport;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ConfigHandler configHandler = new ConfigHandler((Object)this, this.session, this.execution);
        configHandler.parseConfiguration();
        if (this.isEnableIntegrationTest()) {
            this.exerciseApp();
        }
    }

    protected boolean isEnableIntegrationTest() {
        return this.parsedSkip == false && !this.mavenTestSkip && !this.mavenSkipTests;
    }

    protected boolean isIgnoreTestFailures() {
        return this.mavenIgnoreTestFailure || this.mavenTestFailureIgnore;
    }

    protected void exerciseApp() throws MojoExecutionException, MojoFailureException {
        this.getLog().debug((CharSequence)"Parsed values for Android Monkey invocation: ");
        this.getLog().debug((CharSequence)("seed:" + this.parsedSeed));
        DeviceCallback instrumentationTestExecutor = new DeviceCallback(){

            @Override
            public void doWithDevice(IDevice device) throws MojoExecutionException, MojoFailureException {
                String deviceLogLinePrefix = DeviceHelper.getDeviceLogLinePrefix(device);
                MonkeyTestRunner monkeyTestRunner = new MonkeyTestRunner(MonkeyMojo.this.parsedEventCount, device);
                monkeyTestRunner.setRunName("ui monkey tests");
                if (MonkeyMojo.this.parsedSeed != null) {
                    monkeyTestRunner.setSeed(MonkeyMojo.this.parsedSeed);
                }
                if (MonkeyMojo.this.parsedPercentTouch != null) {
                    monkeyTestRunner.setPercentTouch(MonkeyMojo.this.parsedPercentTouch.intValue());
                }
                if (MonkeyMojo.this.parsedPercentMotion != null) {
                    monkeyTestRunner.setPercentTouch(MonkeyMojo.this.parsedPercentMotion.intValue());
                }
                if (MonkeyMojo.this.parsedPercentTrackball != null) {
                    monkeyTestRunner.setPercentTrackball(MonkeyMojo.this.parsedPercentTrackball.intValue());
                }
                if (MonkeyMojo.this.parsedPercentNav != null) {
                    monkeyTestRunner.setPercentNav(MonkeyMojo.this.parsedPercentNav.intValue());
                }
                if (MonkeyMojo.this.parsedPercentMajorNav != null) {
                    monkeyTestRunner.setPercentMajorNav(MonkeyMojo.this.parsedPercentMajorNav.intValue());
                }
                if (MonkeyMojo.this.parsedPercentSyskeys != null) {
                    monkeyTestRunner.setPercentSyskeys(MonkeyMojo.this.parsedPercentSyskeys.intValue());
                }
                if (MonkeyMojo.this.parsedPercentAppswitch != null) {
                    monkeyTestRunner.setPercentAppswitch(MonkeyMojo.this.parsedPercentAppswitch.intValue());
                }
                if (MonkeyMojo.this.parsedPercentAnyevent != null) {
                    monkeyTestRunner.setPercentAnyEvent(MonkeyMojo.this.parsedPercentAnyevent);
                }
                if (MonkeyMojo.this.parsedPackages != null) {
                    monkeyTestRunner.setPackages(MonkeyMojo.this.parsedPackages);
                }
                if (MonkeyMojo.this.parsedCategories != null) {
                    monkeyTestRunner.setCategories(MonkeyMojo.this.parsedCategories);
                }
                monkeyTestRunner.setDebugNoEvents(MonkeyMojo.this.parsedDebugNoEvents);
                monkeyTestRunner.setHprof(MonkeyMojo.this.parsedHprof);
                monkeyTestRunner.setIgnoreCrashes(MonkeyMojo.this.parsedIgnoreCrashes);
                monkeyTestRunner.setIgnoreTimeouts(MonkeyMojo.this.parsedIgnoreTimeouts);
                monkeyTestRunner.setIgnoreSecurityExceptions(MonkeyMojo.this.parsedIgnoreSecurityExceptions);
                monkeyTestRunner.setKillProcessAfterError(MonkeyMojo.this.parsedKillProcessAfterError);
                monkeyTestRunner.setMonitorNativeCrash(MonkeyMojo.this.parsedMonitorNativeCrashes);
                MonkeyMojo.this.getLog().info((CharSequence)(deviceLogLinePrefix + "Running ui monkey tests"));
                try {
                    AndroidTestRunListener testRunListener = new AndroidTestRunListener(MonkeyMojo.this.project, device);
                    monkeyTestRunner.run(testRunListener);
                    if (testRunListener.hasFailuresOrErrors() && !MonkeyMojo.this.isIgnoreTestFailures()) {
                        throw new MojoFailureException(deviceLogLinePrefix + "Tests failed on device.");
                    }
                    if (testRunListener.testRunFailed()) {
                        throw new MojoFailureException(deviceLogLinePrefix + "Test run failed to complete: " + testRunListener.getTestRunFailureCause());
                    }
                    if (testRunListener.threwException() && !MonkeyMojo.this.isIgnoreTestFailures()) {
                        throw new MojoFailureException(deviceLogLinePrefix + testRunListener.getExceptionMessages());
                    }
                }
                catch (TimeoutException e) {
                    throw new MojoExecutionException(deviceLogLinePrefix + "timeout", (Exception)((Object)e));
                }
                catch (AdbCommandRejectedException e) {
                    throw new MojoExecutionException(deviceLogLinePrefix + "adb command rejected", (Exception)((Object)e));
                }
                catch (ShellCommandUnresponsiveException e) {
                    throw new MojoExecutionException(deviceLogLinePrefix + "shell command " + "unresponsive", (Exception)((Object)e));
                }
                catch (IOException e) {
                    throw new MojoExecutionException(deviceLogLinePrefix + "IO problem", (Exception)e);
                }
            }
        };
        this.doWithDevices(instrumentationTestExecutor);
    }

    private Long getSeed() {
        return this.parsedSeed;
    }

    private Long getThrottle() {
        return this.parsedThrottle;
    }

    private Integer getPercentTouch() {
        return this.parsedPercentTouch;
    }

    private Integer getPercentMotion() {
        return this.parsedPercentMotion;
    }

    private Integer getPercentTrackball() {
        return this.parsedPercentTrackball;
    }

    private Integer getPercentNav() {
        return this.parsedPercentNav;
    }

    private Integer getPercentMajorNav() {
        return this.parsedPercentMajorNav;
    }

    private Integer getPercentSyskeys() {
        return this.parsedPercentSyskeys;
    }

    private Integer getPercentAppswitch() {
        return this.parsedPercentAppswitch;
    }

    private Integer getPercentAnyevent() {
        return this.parsedPercentAnyevent;
    }

    public String[] getPackages() {
        return this.parsedPackages;
    }

    public String[] getCategories() {
        return this.parsedCategories;
    }

    public class AndroidTestRunListener
    implements ITestRunListener {
        private static final String SCREENSHOT_SUFFIX = "_screenshot.png";
        private static final String INDENT = "  ";
        private static final String TAG_TESTSUITES = "testsuites";
        private static final String TAG_TESTSUITE = "testsuite";
        private static final String ATTR_TESTSUITE_ERRORS = "errors";
        private static final String ATTR_TESTSUITE_FAILURES = "failures";
        private static final String ATTR_TESTSUITE_HOSTNAME = "hostname";
        private static final String ATTR_TESTSUITE_NAME = "name";
        private static final String ATTR_TESTSUITE_TESTS = "tests";
        private static final String ATTR_TESTSUITE_TIME = "time";
        private static final String ATTR_TESTSUITE_TIMESTAMP = "timestamp";
        private static final String TAG_PROPERTIES = "properties";
        private static final String TAG_PROPERTY = "property";
        private static final String ATTR_PROPERTY_NAME = "name";
        private static final String ATTR_PROPERTY_VALUE = "value";
        private static final String TAG_TESTCASE = "testcase";
        private static final String ATTR_TESTCASE_NAME = "name";
        private static final String ATTR_TESTCASE_CLASSNAME = "classname";
        private static final String ATTR_TESTCASE_TIME = "time";
        private static final String TAG_ERROR = "error";
        private static final String TAG_FAILURE = "failure";
        private static final String ATTR_MESSAGE = "message";
        private static final String ATTR_TYPE = "type";
        private final NumberFormat timeFormatter = new DecimalFormat("#0.0000");
        private int testCount = 0;
        private int testRunCount = 0;
        private int testFailureCount = 0;
        private int testErrorCount = 0;
        private String testRunFailureCause = null;
        private final MavenProject project;
        private final IDevice device;
        private final String deviceLogLinePrefix;
        private Document junitReport;
        private Node testSuiteNode;
        private Node currentTestCaseNode;
        private long currentTestCaseStartTime;
        private boolean threwException = false;
        private final StringBuilder exceptionMessages = new StringBuilder();

        public AndroidTestRunListener(MavenProject project, IDevice device) {
            this.project = project;
            this.device = device;
            this.deviceLogLinePrefix = DeviceHelper.getDeviceLogLinePrefix(device);
        }

        public void testRunStarted(String runName, int tCount) {
            this.testCount = tCount;
            MonkeyMojo.this.getLog().info((CharSequence)(this.deviceLogLinePrefix + INDENT + "Run started: " + runName + ", " + this.testCount + " tests:"));
            if (MonkeyMojo.this.parsedCreateReport.booleanValue()) {
                try {
                    Attr propValueAttr;
                    Attr propNameAttr;
                    NamedNodeMap propertyAttributes;
                    Element propertyNode;
                    DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
                    DocumentBuilder parser = null;
                    parser = fact.newDocumentBuilder();
                    this.junitReport = parser.newDocument();
                    Element testSuitesNode = this.junitReport.createElement(TAG_TESTSUITES);
                    this.junitReport.appendChild(testSuitesNode);
                    this.testSuiteNode = this.junitReport.createElement(TAG_TESTSUITE);
                    NamedNodeMap testSuiteAttributes = this.testSuiteNode.getAttributes();
                    Attr nameAttr = this.junitReport.createAttribute("name");
                    nameAttr.setValue(runName);
                    testSuiteAttributes.setNamedItem(nameAttr);
                    Attr hostnameAttr = this.junitReport.createAttribute(ATTR_TESTSUITE_HOSTNAME);
                    hostnameAttr.setValue(DeviceHelper.getDescriptiveName(this.device));
                    testSuiteAttributes.setNamedItem(hostnameAttr);
                    Element propertiesNode = this.junitReport.createElement(TAG_PROPERTIES);
                    for (Map.Entry<Object, Object> systemProperty : System.getProperties().entrySet()) {
                        propertyNode = this.junitReport.createElement(TAG_PROPERTY);
                        propertyAttributes = propertyNode.getAttributes();
                        propNameAttr = this.junitReport.createAttribute("name");
                        propNameAttr.setValue(systemProperty.getKey().toString());
                        propertyAttributes.setNamedItem(propNameAttr);
                        propValueAttr = this.junitReport.createAttribute(ATTR_PROPERTY_VALUE);
                        propValueAttr.setValue(systemProperty.getValue().toString());
                        propertyAttributes.setNamedItem(propValueAttr);
                        propertiesNode.appendChild(propertyNode);
                    }
                    Map deviceProperties = this.device.getProperties();
                    for (Map.Entry deviceProperty : deviceProperties.entrySet()) {
                        propertyNode = this.junitReport.createElement(TAG_PROPERTY);
                        propertyAttributes = propertyNode.getAttributes();
                        propNameAttr = this.junitReport.createAttribute("name");
                        propNameAttr.setValue((String)deviceProperty.getKey());
                        propertyAttributes.setNamedItem(propNameAttr);
                        propValueAttr = this.junitReport.createAttribute(ATTR_PROPERTY_VALUE);
                        propValueAttr.setValue((String)deviceProperty.getValue());
                        propertyAttributes.setNamedItem(propValueAttr);
                        propertiesNode.appendChild(propertyNode);
                    }
                    this.testSuiteNode.appendChild(propertiesNode);
                    testSuitesNode.appendChild(this.testSuiteNode);
                }
                catch (ParserConfigurationException e) {
                    this.threwException = true;
                    this.exceptionMessages.append("Failed to create document");
                    this.exceptionMessages.append(e.getMessage());
                }
            }
        }

        public void testStarted(TestIdentifier testIdentifier) {
            ++this.testRunCount;
            MonkeyMojo.this.getLog().info((CharSequence)(this.deviceLogLinePrefix + String.format("%1$s%1$sStart [%2$d/%3$d]: %4$s", INDENT, this.testRunCount, this.testCount, testIdentifier.toString())));
            if (MonkeyMojo.this.parsedCreateReport.booleanValue()) {
                this.currentTestCaseStartTime = new Date().getTime();
                this.currentTestCaseNode = this.junitReport.createElement(TAG_TESTCASE);
                NamedNodeMap testCaseAttributes = this.currentTestCaseNode.getAttributes();
                Attr classAttr = this.junitReport.createAttribute(ATTR_TESTCASE_CLASSNAME);
                classAttr.setValue(testIdentifier.getClassName());
                testCaseAttributes.setNamedItem(classAttr);
                Attr methodAttr = this.junitReport.createAttribute("name");
                methodAttr.setValue(testIdentifier.getTestName());
                testCaseAttributes.setNamedItem(methodAttr);
            }
        }

        public void testFailed(ITestRunListener.TestFailure status, TestIdentifier testIdentifier, String trace) {
            if (status == ITestRunListener.TestFailure.ERROR) {
                ++this.testErrorCount;
            } else {
                ++this.testFailureCount;
            }
            MonkeyMojo.this.getLog().info((CharSequence)(this.deviceLogLinePrefix + INDENT + INDENT + status.name() + ":" + testIdentifier.toString()));
            MonkeyMojo.this.getLog().info((CharSequence)(this.deviceLogLinePrefix + INDENT + INDENT + trace));
            if (MonkeyMojo.this.parsedCreateReport.booleanValue()) {
                NamedNodeMap errorfailureAttributes;
                Element errorFailureNode;
                if (status == ITestRunListener.TestFailure.ERROR) {
                    errorFailureNode = this.junitReport.createElement(TAG_ERROR);
                    errorfailureAttributes = errorFailureNode.getAttributes();
                } else {
                    errorFailureNode = this.junitReport.createElement(TAG_FAILURE);
                    errorfailureAttributes = errorFailureNode.getAttributes();
                }
                errorFailureNode.setTextContent(trace);
                Attr msgAttr = this.junitReport.createAttribute(ATTR_MESSAGE);
                msgAttr.setValue(this.parseForMessage(trace));
                errorfailureAttributes.setNamedItem(msgAttr);
                Attr typeAttr = this.junitReport.createAttribute(ATTR_TYPE);
                typeAttr.setValue(this.parseForException(trace));
                errorfailureAttributes.setNamedItem(typeAttr);
                this.currentTestCaseNode.appendChild(errorFailureNode);
            }
        }

        private void executeOnAdbShell(String command) {
            try {
                this.device.executeShellCommand(command, new IShellOutputReceiver(){

                    public boolean isCancelled() {
                        return false;
                    }

                    public void flush() {
                    }

                    public void addOutput(byte[] data, int offset, int length) {
                    }
                });
            }
            catch (TimeoutException e) {
                MonkeyMojo.this.getLog().error((Throwable)e);
            }
            catch (AdbCommandRejectedException e) {
                MonkeyMojo.this.getLog().error((Throwable)e);
            }
            catch (ShellCommandUnresponsiveException e) {
                MonkeyMojo.this.getLog().error((Throwable)e);
            }
            catch (IOException e) {
                MonkeyMojo.this.getLog().error((Throwable)e);
            }
        }

        public void testEnded(TestIdentifier testIdentifier, Map<String, String> testMetrics) {
            MonkeyMojo.this.getLog().info((CharSequence)(this.deviceLogLinePrefix + String.format("%1$s%1$sEnd [%2$d/%3$d]: %4$s", INDENT, this.testRunCount, this.testCount, testIdentifier.toString())));
            this.logMetrics(testMetrics);
            if (MonkeyMojo.this.parsedCreateReport.booleanValue()) {
                this.testSuiteNode.appendChild(this.currentTestCaseNode);
                NamedNodeMap testCaseAttributes = this.currentTestCaseNode.getAttributes();
                Attr timeAttr = this.junitReport.createAttribute("time");
                long now = new Date().getTime();
                double seconds = (double)(now - this.currentTestCaseStartTime) / 1000.0;
                timeAttr.setValue(this.timeFormatter.format(seconds));
                testCaseAttributes.setNamedItem(timeAttr);
            }
        }

        public void testRunEnded(long elapsedTime, Map<String, String> runMetrics) {
            MonkeyMojo.this.getLog().info((CharSequence)(this.deviceLogLinePrefix + INDENT + "Run ended: " + elapsedTime + " ms"));
            if (this.hasFailuresOrErrors()) {
                MonkeyMojo.this.getLog().error((CharSequence)(this.deviceLogLinePrefix + INDENT + "FAILURES!!!"));
            }
            MonkeyMojo.this.getLog().info((CharSequence)("  Tests run: " + this.testRunCount + (this.testRunCount < this.testCount ? " (of " + this.testCount + ")" : "") + ",  Failures: " + this.testFailureCount + ",  Errors: " + this.testErrorCount));
            if (MonkeyMojo.this.parsedCreateReport.booleanValue()) {
                NamedNodeMap testSuiteAttributes = this.testSuiteNode.getAttributes();
                Attr testCountAttr = this.junitReport.createAttribute(ATTR_TESTSUITE_TESTS);
                testCountAttr.setValue(Integer.toString(this.testCount));
                testSuiteAttributes.setNamedItem(testCountAttr);
                Attr testFailuresAttr = this.junitReport.createAttribute(ATTR_TESTSUITE_FAILURES);
                testFailuresAttr.setValue(Integer.toString(this.testFailureCount));
                testSuiteAttributes.setNamedItem(testFailuresAttr);
                Attr testErrorsAttr = this.junitReport.createAttribute(ATTR_TESTSUITE_ERRORS);
                testErrorsAttr.setValue(Integer.toString(this.testErrorCount));
                testSuiteAttributes.setNamedItem(testErrorsAttr);
                Attr timeAttr = this.junitReport.createAttribute("time");
                timeAttr.setValue(this.timeFormatter.format((double)elapsedTime / 1000.0));
                testSuiteAttributes.setNamedItem(timeAttr);
                Attr timeStampAttr = this.junitReport.createAttribute(ATTR_TESTSUITE_TIMESTAMP);
                timeStampAttr.setValue(new Date().toString());
                testSuiteAttributes.setNamedItem(timeStampAttr);
            }
            this.logMetrics(runMetrics);
            if (MonkeyMojo.this.parsedCreateReport.booleanValue()) {
                this.writeJunitReportToFile();
            }
        }

        public void testRunFailed(String errorMessage) {
            this.testRunFailureCause = errorMessage;
            MonkeyMojo.this.getLog().info((CharSequence)(this.deviceLogLinePrefix + INDENT + "Run failed: " + errorMessage));
        }

        public void testRunStopped(long elapsedTime) {
            MonkeyMojo.this.getLog().info((CharSequence)(this.deviceLogLinePrefix + INDENT + "Run stopped:" + elapsedTime));
        }

        private String parseForMessage(String trace) {
            if (StringUtils.isNotBlank((String)trace)) {
                boolean hasMessage;
                String newline = "\r\n";
                int messageEnd = trace.indexOf(newline);
                boolean bl = hasMessage = !trace.startsWith("junit.") && messageEnd > 0;
                if (hasMessage) {
                    int messageStart = trace.indexOf(":") + 2;
                    if (messageStart > messageEnd && messageStart > (messageEnd = trace.indexOf(newline + "at"))) {
                        messageStart = 0;
                    }
                    return trace.substring(messageStart, messageEnd);
                }
                return "";
            }
            return "";
        }

        private String parseForException(String trace) {
            if (StringUtils.isNotBlank((String)trace)) {
                return trace.substring(0, trace.indexOf(":"));
            }
            return "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private void writeJunitReportToFile() {
            block9: {
                TransformerFactory xfactory = TransformerFactory.newInstance();
                Transformer xformer = null;
                try {
                    xformer = xfactory.newTransformer();
                }
                catch (TransformerConfigurationException e) {
                    e.printStackTrace();
                }
                DOMSource source = new DOMSource(this.junitReport);
                FileWriter writer = null;
                try {
                    String directory = MonkeyMojo.this.targetDirectory + "/surefire-reports";
                    FileUtils.forceMkdir((File)new File(directory));
                    String fileName = directory + "/TEST-" + DeviceHelper.getDescriptiveName(this.device) + ".xml";
                    File reportFile = new File(fileName);
                    writer = new FileWriter(reportFile);
                    StreamResult result = new StreamResult(writer);
                    xformer.transform(source, result);
                    MonkeyMojo.this.getLog().info((CharSequence)(this.deviceLogLinePrefix + "Report file written to " + reportFile.getAbsolutePath()));
                    IOUtils.closeQuietly((Writer)writer);
                }
                catch (IOException e) {
                    this.threwException = true;
                    this.exceptionMessages.append("Failed to write test report file");
                    this.exceptionMessages.append(e.getMessage());
                }
                catch (TransformerException e2) {
                    this.threwException = true;
                    this.exceptionMessages.append("Failed to transform document to write to test report file");
                    this.exceptionMessages.append(e2.getMessage());
                    break block9;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    IOUtils.closeQuietly(writer);
                }
            }
        }

        private void logMetrics(Map<String, String> metrics) {
            for (Map.Entry<String, String> entry : metrics.entrySet()) {
                MonkeyMojo.this.getLog().info((CharSequence)(this.deviceLogLinePrefix + INDENT + INDENT + entry.getKey() + ": " + entry.getValue()));
            }
        }

        public boolean hasFailuresOrErrors() {
            return this.testErrorCount > 0 || this.testFailureCount > 0;
        }

        public boolean testRunFailed() {
            return this.testRunFailureCause != null;
        }

        public String getTestRunFailureCause() {
            return this.testRunFailureCause;
        }

        public boolean threwException() {
            return this.threwException;
        }

        public String getExceptionMessages() {
            return this.exceptionMessages.toString();
        }
    }
}

