/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android.common;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.codehaus.plexus.logging.Logger;

final class DependencyCollector {
    private final Logger log;
    private final Set<Artifact> dependencies = new HashSet<Artifact>();
    private final Artifact target;

    DependencyCollector(Logger logger, Artifact target) {
        this.log = logger;
        this.target = target;
    }

    public void visit(DependencyNode node, boolean collecting) {
        if (collecting) {
            this.dependencies.add(node.getArtifact());
        }
        if (this.matchesTarget(node.getArtifact())) {
            collecting = true;
            this.log.debug("Found target. Collecting dependencies after " + node.getArtifact());
        }
        for (DependencyNode child : node.getChildren()) {
            this.visit(child, collecting);
        }
    }

    public Set<Artifact> getDependencies() {
        return Collections.unmodifiableSet(this.dependencies);
    }

    private boolean matchesTarget(Artifact found) {
        return found.getGroupId().equals(this.target.getGroupId()) && found.getArtifactId().equals(this.target.getArtifactId()) && found.getVersion().equals(this.target.getVersion()) && found.getType().equals(this.target.getType()) && this.classifierMatch(found.getClassifier(), this.target.getClassifier());
    }

    private boolean classifierMatch(String classifierA, String classifierB) {
        boolean hasClassifierB;
        boolean hasClassifierA = !this.isNullOrEmpty(classifierA);
        boolean bl = hasClassifierB = !this.isNullOrEmpty(classifierB);
        if (!hasClassifierA && !hasClassifierB) {
            return true;
        }
        if (hasClassifierA && hasClassifierB) {
            return classifierA.equals(classifierB);
        }
        return false;
    }

    private boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }
}

