/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android.phase09package;

import com.jayway.maven.plugins.android.AbstractAndroidMojo;
import com.jayway.maven.plugins.android.CommandExecutor;
import com.jayway.maven.plugins.android.ExecutionException;
import com.jayway.maven.plugins.android.common.NativeHelper;
import com.jayway.maven.plugins.android.config.PullParameter;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.util.DefaultFileSet;

public class AarMojo
extends AbstractAndroidMojo {
    public static final String NATIVE_LIBRARIES_FOLDER = "libs";
    private File ndkOutputDirectory;
    private String classifier;
    @PullParameter
    private String applicationMakefile;
    @PullParameter
    private String ndkArchitecture;
    @PullParameter
    private String ndkClassifier;
    @PullParameter
    private String[] classesJarIncludes = new String[]{"**/*"};
    @PullParameter
    private String[] classesJarExcludes = new String[]{"**/R.class", "**/R$*.class", "**/BuildConfig.class"};
    private List<String> sourceFolders = new ArrayList<String>();

    public void execute() throws MojoExecutionException, MojoFailureException {
        String out = this.project.getBuild().getDirectory();
        for (String src : this.project.getCompileSourceRoots()) {
            if (src.startsWith(out)) continue;
            this.sourceFolders.add(src);
        }
        this.generateIntermediateApk();
        CommandExecutor executor = CommandExecutor.Factory.createDefaultCommmandExecutor();
        executor.setLogger(this.getLog());
        File outputFile = this.createApkLibraryFile(this.createAarClassesJar());
        if (this.classifier == null) {
            this.project.getArtifact().setFile(outputFile);
        } else {
            this.projectHelper.attachArtifact(this.project, outputFile, this.classifier);
        }
    }

    protected File createAarClassesJar() throws MojoExecutionException {
        File classesJar = new File(this.project.getBuild().getDirectory(), this.project.getBuild().getFinalName() + ".aar.classes.jar");
        try {
            JarArchiver jarArchiver = new JarArchiver();
            jarArchiver.setDestFile(classesJar);
            jarArchiver.addDirectory(new File(this.project.getBuild().getOutputDirectory()), this.classesJarIncludes, this.classesJarExcludes);
            jarArchiver.createArchive();
            return classesJar;
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("ArchiverException while creating ." + classesJar + " file.", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("IOException while creating ." + classesJar + " file.", (Exception)e);
        }
    }

    protected File createApkLibraryFile(File classesJar) throws MojoExecutionException {
        File apklibrary = new File(this.project.getBuild().getDirectory(), this.project.getBuild().getFinalName() + "." + "aar");
        FileUtils.deleteQuietly((File)apklibrary);
        try {
            File[] overlayDirectories;
            JarArchiver jarArchiver = new JarArchiver();
            jarArchiver.setDestFile(apklibrary);
            jarArchiver.addFile(this.androidManifestFile, "AndroidManifest.xml");
            this.addDirectory(jarArchiver, this.assetsDirectory, "assets");
            this.addDirectory(jarArchiver, this.resourceDirectory, "res");
            jarArchiver.addFile(classesJar, "classes.jar");
            for (File resOverlayDir : overlayDirectories = this.getResourceOverlayDirectories()) {
                if (resOverlayDir == null || !resOverlayDir.exists()) continue;
                this.addDirectory(jarArchiver, resOverlayDir, "res");
            }
            this.addJavaResources(jarArchiver, this.project.getBuild().getResources(), "src");
            this.addR(jarArchiver);
            this.addNativeLibraries(jarArchiver);
            jarArchiver.createArchive();
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("ArchiverException while creating .aar file.", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("IOException while creating .aar file.", (Exception)e);
        }
        return apklibrary;
    }

    private void addR(JarArchiver jarArchiver) throws MojoExecutionException {
        File rFile = new File(this.project.getBuild().getDirectory() + "/R.txt");
        jarArchiver.addFile(rFile, "R.txt");
    }

    private void addNativeLibraries(JarArchiver jarArchiver) throws MojoExecutionException {
        try {
            if (this.nativeLibrariesDirectory.exists()) {
                this.getLog().info((CharSequence)(this.nativeLibrariesDirectory + " exists, adding libraries."));
                this.addDirectory(jarArchiver, this.nativeLibrariesDirectory, NATIVE_LIBRARIES_FOLDER);
            } else {
                String[] ndkArchitectures;
                this.getLog().info((CharSequence)(this.nativeLibrariesDirectory + " does not exist, looking for libraries in target directory."));
                for (String ndkArchitecture : ndkArchitectures = NativeHelper.getNdkArchitectures(this.ndkArchitecture, this.applicationMakefile, this.project.getBasedir())) {
                    File ndkLibsDirectory = new File(this.ndkOutputDirectory, ndkArchitecture);
                    this.addSharedLibraries(jarArchiver, ndkLibsDirectory, ndkArchitecture);
                    for (Artifact apkLibraryArtifact : this.getAllRelevantDependencyArtifacts()) {
                        File apklibLibsDirectory;
                        if (!apkLibraryArtifact.getType().equals("aar") && !apkLibraryArtifact.getType().equals("apklib") || !(apklibLibsDirectory = new File(this.getLibraryUnpackDirectory(apkLibraryArtifact) + "/" + NATIVE_LIBRARIES_FOLDER + "/" + ndkArchitecture)).exists()) continue;
                        this.addSharedLibraries(jarArchiver, apklibLibsDirectory, ndkArchitecture);
                    }
                }
            }
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("IOException while creating .aar file.", (Exception)((Object)e));
        }
    }

    protected void addJavaResources(JarArchiver jarArchiver, List<Resource> javaResources, String prefix) throws IOException {
        for (Resource javaResource : javaResources) {
            this.addJavaResource(jarArchiver, javaResource, prefix);
        }
    }

    protected void addJavaResource(JarArchiver jarArchiver, Resource javaResource, String prefix) throws IOException {
        String apkLibUnpackBasePath;
        String resourcePath;
        File javaResourceDirectory;
        if (javaResource != null && (javaResourceDirectory = new File(javaResource.getDirectory())).exists() && !(resourcePath = javaResourceDirectory.getCanonicalPath()).startsWith(apkLibUnpackBasePath = this.unpackedApkLibsDirectory.getCanonicalPath())) {
            DefaultFileSet javaResourceFileSet = new DefaultFileSet();
            javaResourceFileSet.setDirectory(javaResourceDirectory);
            javaResourceFileSet.setPrefix(this.endWithSlash(prefix));
            jarArchiver.addFileSet((FileSet)javaResourceFileSet);
        }
    }

    protected String endWithSlash(String prefix) {
        if (!(prefix = StringUtils.defaultIfEmpty((String)prefix, (String)"/")).endsWith("/")) {
            prefix = prefix + "/";
        }
        return prefix;
    }

    protected void addDirectory(JarArchiver jarArchiver, File directory, String prefix) {
        if (directory != null && directory.exists()) {
            DefaultFileSet fileSet = new DefaultFileSet();
            fileSet.setPrefix(this.endWithSlash(prefix));
            fileSet.setDirectory(directory);
            jarArchiver.addFileSet((FileSet)fileSet);
            this.getLog().debug((CharSequence)("Added files from " + directory));
        }
    }

    protected void addSharedLibraries(JarArchiver jarArchiver, File directory, String ndkArchitecture) {
        this.getLog().debug((CharSequence)("Searching for shared libraries in " + directory));
        File[] libFiles = directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("lib") && name.endsWith(".so");
            }
        });
        if (libFiles != null) {
            for (File libFile : libFiles) {
                String dest = "libs/" + ndkArchitecture + "/" + libFile.getName();
                this.getLog().debug((CharSequence)("Adding " + libFile + " as " + dest));
                jarArchiver.addFile(libFile, dest);
            }
        }
    }

    private void generateIntermediateApk() throws MojoExecutionException {
        CommandExecutor executor = CommandExecutor.Factory.createDefaultCommmandExecutor();
        executor.setLogger(this.getLog());
        File[] overlayDirectories = this.getResourceOverlayDirectories();
        File androidJar = this.getAndroidSdk().getAndroidJar();
        File outputFile = new File(this.project.getBuild().getDirectory(), this.project.getBuild().getFinalName() + ".ap_");
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("package");
        commands.add("-f");
        commands.add("-M");
        commands.add(this.androidManifestFile.getAbsolutePath());
        for (File resOverlayDir : overlayDirectories) {
            if (resOverlayDir == null || !resOverlayDir.exists()) continue;
            commands.add("-S");
            commands.add(resOverlayDir.getAbsolutePath());
        }
        if (this.resourceDirectory.exists()) {
            commands.add("-S");
            commands.add(this.resourceDirectory.getAbsolutePath());
        }
        for (Artifact apkLibraryArtifact : this.getAllRelevantDependencyArtifacts()) {
            String apklibResDirectory;
            if (!apkLibraryArtifact.getType().equals("aar") && !apkLibraryArtifact.getType().equals("apklib") || !new File(apklibResDirectory = this.getLibraryUnpackDirectory(apkLibraryArtifact) + "/res").exists()) continue;
            commands.add("-S");
            commands.add(apklibResDirectory);
        }
        commands.add("--auto-add-overlay");
        if (this.combinedAssets.exists()) {
            this.getLog().debug((CharSequence)("Adding assets folder : " + this.combinedAssets));
            commands.add("-A");
            commands.add(this.combinedAssets.getAbsolutePath());
        }
        commands.add("-I");
        commands.add(androidJar.getAbsolutePath());
        commands.add("-F");
        commands.add(outputFile.getAbsolutePath());
        if (StringUtils.isNotBlank((String)this.configurations)) {
            commands.add("-c");
            commands.add(this.configurations);
        }
        commands.add("-m");
        commands.add("-J");
        String rDir = this.project.getBuild().getDirectory() + File.separator + "generated-sources" + File.separator + "r";
        commands.add(rDir);
        commands.add("--non-constant-id");
        commands.add("--output-text-symbols");
        commands.add(this.project.getBuild().getDirectory());
        this.getLog().info((CharSequence)(this.getAndroidSdk().getAaptPath() + " " + ((Object)commands).toString()));
        try {
            executor.executeCommand(this.getAndroidSdk().getAaptPath(), commands, this.project.getBasedir(), false);
        }
        catch (ExecutionException e) {
            throw new MojoExecutionException("", (Exception)e);
        }
    }
}

