/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android.common;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.plugin.MojoExecutionException;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;

public final class DependencyResolver {
    private final RepositorySystem repoSystem;
    private final RepositorySystemSession repoSession;
    private final List<RemoteRepository> remoteRepos;
    private final ArtifactHandler artifactHandler;

    public DependencyResolver(RepositorySystem repoSystem, RepositorySystemSession repoSession, List<RemoteRepository> remoteRepos, ArtifactHandler artifactHandler) {
        this.repoSystem = repoSystem;
        this.repoSession = repoSession;
        this.remoteRepos = remoteRepos;
        this.artifactHandler = artifactHandler;
    }

    public List<org.apache.maven.artifact.Artifact> getDependenciesFor(org.apache.maven.artifact.Artifact artifact) throws MojoExecutionException {
        ArrayList<org.apache.maven.artifact.Artifact> results = new ArrayList<org.apache.maven.artifact.Artifact>();
        DefaultArtifact artifactToResolve = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getType(), artifact.getVersion());
        List<Dependency> transitiveDeps = this.getDependenciesFor((Artifact)artifactToResolve);
        for (Dependency dependency : transitiveDeps) {
            org.apache.maven.artifact.DefaultArtifact apklibDep = new org.apache.maven.artifact.DefaultArtifact(dependency.getArtifact().getGroupId(), dependency.getArtifact().getArtifactId(), dependency.getArtifact().getVersion(), dependency.getScope(), dependency.getArtifact().getExtension(), dependency.getArtifact().getClassifier(), this.artifactHandler);
            results.add((org.apache.maven.artifact.Artifact)apklibDep);
        }
        return results;
    }

    private List<Dependency> getDependenciesFor(Artifact artifact) throws MojoExecutionException {
        ArtifactDescriptorResult descriptorResult;
        ArrayList<Dependency> results = new ArrayList<Dependency>();
        ArtifactDescriptorRequest descriptorRequest = new ArtifactDescriptorRequest();
        descriptorRequest.setArtifact(artifact);
        descriptorRequest.setRepositories(this.remoteRepos);
        try {
            descriptorResult = this.repoSystem.readArtifactDescriptor(this.repoSession, descriptorRequest);
        }
        catch (ArtifactDescriptorException e) {
            throw new MojoExecutionException("Could not resolve dependencies for " + artifact, (Exception)((Object)e));
        }
        for (Dependency dependency : descriptorResult.getDependencies()) {
            String extension = dependency.getArtifact().getExtension();
            if (!extension.equals("apklib") && !extension.equals("aar")) continue;
            results.add(dependency);
            results.addAll(this.getDependenciesFor(dependency.getArtifact()));
        }
        return results;
    }
}

