/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android.standalonemojos;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.jayway.maven.plugins.android.AbstractAndroidMojo;
import com.jayway.maven.plugins.android.DeviceCallback;
import com.jayway.maven.plugins.android.config.ConfigHandler;
import com.jayway.maven.plugins.android.config.ConfigPojo;
import com.jayway.maven.plugins.android.config.PullParameter;
import com.jayway.maven.plugins.android.configuration.Run;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RunMojo
extends AbstractAndroidMojo {
    @ConfigPojo
    private Run run;
    protected Boolean runDebug;
    @PullParameter(defaultValue="false")
    private Boolean parsedDebug;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            LauncherInfo launcherInfo = this.getLauncherActivity();
            ConfigHandler configHandler = new ConfigHandler((Object)this);
            configHandler.parseConfiguration();
            this.launch(launcherInfo);
        }
        catch (Exception ex) {
            throw new MojoFailureException("Unable to run launcher Activity", (Throwable)ex);
        }
    }

    private LauncherInfo getLauncherActivity() throws ParserConfigurationException, SAXException, IOException, XPathExpressionException, MojoFailureException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(this.androidManifestFile);
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        XPathExpression xPathExpression = xPath.compile("//manifest/application/activity/intent-filter[action[@name=\"android.intent.action.MAIN\"] and category[@name=\"android.intent.category.LAUNCHER\"]]/..");
        Object result = xPathExpression.evaluate(document, XPathConstants.NODESET);
        if (result instanceof NodeList) {
            NodeList activities = (NodeList)result;
            if (activities.getLength() > 0) {
                LauncherInfo launcherInfo = new LauncherInfo();
                String activityName = activities.item(0).getAttributes().getNamedItem("android:name").getNodeValue();
                if (!activityName.contains(".")) {
                    activityName = "." + activityName;
                }
                if (activityName.startsWith(".")) {
                    String packageName = document.getElementsByTagName("manifest").item(0).getAttributes().getNamedItem("package").getNodeValue();
                    activityName = packageName + activityName;
                }
                launcherInfo.activity = activityName;
                launcherInfo.packageName = this.renameManifestPackage != null ? this.renameManifestPackage : document.getDocumentElement().getAttribute("package").toString();
                return launcherInfo;
            }
            throw new MojoFailureException("Could not find a launcher activity in manifest");
        }
        throw new MojoFailureException("Could not find any activity in manifest");
    }

    private void launch(final LauncherInfo info) throws MojoExecutionException, MojoFailureException {
        final String command = String.format("am start %s-n %s/%s", this.parsedDebug != false ? "-D " : "", info.packageName, info.activity);
        this.doWithDevices(new DeviceCallback(){

            @Override
            public void doWithDevice(IDevice device) throws MojoExecutionException, MojoFailureException {
                try {
                    RunMojo.this.getLog().info((CharSequence)("Attempting to start " + info.packageName + "/" + info.activity + " on device " + device.getSerialNumber() + " (avdName = " + device.getAvdName() + ")"));
                    CollectingOutputReceiver shellOutput = new CollectingOutputReceiver();
                    device.executeShellCommand(command, (IShellOutputReceiver)shellOutput);
                    if (shellOutput.getOutput().contains("Error")) {
                        throw new MojoFailureException(shellOutput.getOutput());
                    }
                }
                catch (IOException ex) {
                    throw new MojoFailureException("Input/Output error", (Throwable)ex);
                }
                catch (TimeoutException ex) {
                    throw new MojoFailureException("Command timeout", (Throwable)ex);
                }
                catch (AdbCommandRejectedException ex) {
                    throw new MojoFailureException("ADB rejected the command", (Throwable)ex);
                }
                catch (ShellCommandUnresponsiveException ex) {
                    throw new MojoFailureException("Unresponsive command", (Throwable)ex);
                }
            }
        });
    }

    private static class LauncherInfo {
        private String packageName;
        private String activity;

        private LauncherInfo() {
        }

        public String getPackageName() {
            return this.packageName;
        }

        public void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        public String getActivity() {
            return this.activity;
        }

        public void setActivity(String activity) {
            this.activity = activity;
        }
    }
}

