/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android.common;

import com.android.ddmlib.IDevice;
import com.jayway.maven.plugins.android.common.FileNameHelper;
import org.apache.commons.lang.StringUtils;

public class DeviceHelper {
    private static final String MANUFACTURER_PROPERTY = "ro.product.manufacturer";
    private static final String MODEL_PROPERTY = "ro.product.model";

    public static String getDescriptiveName(IDevice device) {
        String model;
        String manufacturer;
        String SEPARATOR = "_";
        StringBuilder identfier = new StringBuilder().append(device.getSerialNumber());
        if (device.getAvdName() != null) {
            identfier.append(SEPARATOR).append(device.getAvdName());
        }
        if (StringUtils.isNotBlank((String)(manufacturer = DeviceHelper.getManufacturer(device)))) {
            identfier.append(SEPARATOR).append(manufacturer);
        }
        if (StringUtils.isNotBlank((String)(model = DeviceHelper.getModel(device)))) {
            identfier.append(SEPARATOR).append(model);
        }
        return FileNameHelper.fixFileName(identfier.toString());
    }

    public static String getManufacturer(IDevice device) {
        return StringUtils.deleteWhitespace((String)device.getProperty(MANUFACTURER_PROPERTY));
    }

    public static String getModel(IDevice device) {
        return StringUtils.deleteWhitespace((String)device.getProperty(MODEL_PROPERTY));
    }

    public static String getDescriptiveNameWithStatus(IDevice device) {
        String status = device.isOnline() ? "Online" : (device.isOffline() ? "Offline" : "Unknown");
        return DeviceHelper.getDescriptiveName(device) + " " + status;
    }
}

