/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android.standalonemojos;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.SyncService;
import com.android.ddmlib.TimeoutException;
import com.jayway.maven.plugins.android.AbstractAndroidMojo;
import com.jayway.maven.plugins.android.DeviceCallback;
import com.jayway.maven.plugins.android.common.LogSyncProgressMonitor;
import com.jayway.maven.plugins.android.configuration.Push;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class PushMojo
extends AbstractAndroidMojo {
    private Push push;
    private String pushSource;
    private String pushDestination;
    private File parsedSource;
    private String parsedDestination;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.parseConfiguration();
        final Map<String, String> sourceDestinationMap = this.calculateSourceDestinationMapping();
        this.doWithDevices(new DeviceCallback(){

            @Override
            public void doWithDevice(IDevice device) throws MojoExecutionException {
                String message = "";
                try {
                    SyncService syncService = device.getSyncService();
                    for (Map.Entry pushFileEntry : sourceDestinationMap.entrySet()) {
                        String sourcePath = (String)pushFileEntry.getKey();
                        String destinationPath = (String)pushFileEntry.getValue();
                        message = "Push of " + sourcePath + " to " + destinationPath + " on ";
                        syncService.pushFile(sourcePath, destinationPath, (SyncService.ISyncProgressMonitor)new LogSyncProgressMonitor(PushMojo.this.getLog()));
                        PushMojo.this.getLog().info((CharSequence)(message + device.getSerialNumber() + " (avdName=" + device.getAvdName() + ") successful."));
                    }
                }
                catch (SyncException e) {
                    throw new MojoExecutionException(message + device.getSerialNumber() + " (avdName=" + device.getAvdName() + ") failed.", (Exception)((Object)e));
                }
                catch (IOException e) {
                    throw new MojoExecutionException(message + device.getSerialNumber() + " (avdName=" + device.getAvdName() + ") failed.", (Exception)e);
                }
                catch (TimeoutException e) {
                    throw new MojoExecutionException(message + device.getSerialNumber() + " (avdName=" + device.getAvdName() + ") failed.", (Exception)((Object)e));
                }
                catch (AdbCommandRejectedException e) {
                    throw new MojoExecutionException(message + device.getSerialNumber() + " (avdName=" + device.getAvdName() + ") failed.", (Exception)((Object)e));
                }
            }
        });
    }

    private void parseConfiguration() {
        if (this.push != null) {
            this.parsedSource = StringUtils.isNotEmpty((String)this.push.getSource()) ? new File(this.push.getSource()) : new File(this.pushSource);
            this.parsedDestination = StringUtils.isNotEmpty((String)this.push.getDestination()) ? this.push.getDestination() : this.pushDestination;
        } else {
            this.parsedSource = new File(this.pushSource);
            this.parsedDestination = this.pushDestination;
        }
    }

    private Map<String, String> calculateSourceDestinationMapping() throws MojoExecutionException {
        HashMap<String, String> result = new HashMap<String, String>();
        String destinationPath = this.parsedDestination.endsWith("/") ? this.parsedDestination + this.parsedSource.getName() : this.parsedDestination;
        if (this.parsedSource.isFile()) {
            String sourcePath = this.parsedSource.getAbsolutePath();
            result.put(sourcePath, destinationPath);
        } else if (this.parsedSource.isDirectory()) {
            Collection filesList = FileUtils.listFiles((File)this.parsedSource, null, (boolean)true);
            for (File file : filesList) {
                String filePath = file.getAbsolutePath().substring(this.parsedSource.getAbsolutePath().length());
                result.put(file.getAbsolutePath(), destinationPath + filePath);
            }
        } else {
            throw new MojoExecutionException("Cannot execute push goal: File or directory " + this.parsedSource.getAbsolutePath() + " does not exist.");
        }
        return result;
    }
}

