/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android.standalonemojos;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.SyncService;
import com.android.ddmlib.TimeoutException;
import com.jayway.maven.plugins.android.AbstractAndroidMojo;
import com.jayway.maven.plugins.android.DeviceCallback;
import com.jayway.maven.plugins.android.common.LogSyncProgressMonitor;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class PullMojo
extends AbstractAndroidMojo {
    private String source;
    private File destination;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String destinationPath;
        final String sourcePath = this.source;
        if (this.destination.isDirectory()) {
            String sourceFileName = this.source.substring(this.source.lastIndexOf("/"), this.source.length());
            destinationPath = this.destination.getAbsolutePath() + sourceFileName;
        } else {
            destinationPath = this.destination.getAbsolutePath();
        }
        if (!this.destination.exists()) {
            String destPath = this.destination.getAbsolutePath();
            File destFile = new File(destPath = FilenameUtils.getFullPath((String)destPath));
            if (!destFile.exists()) {
                this.getLog().info((CharSequence)("Creating destination directory " + destFile));
                destFile.mkdirs();
            }
        }
        final String message = "Pull of " + this.source + " to " + destinationPath + " from ";
        this.doWithDevices(new DeviceCallback(){

            @Override
            public void doWithDevice(IDevice device) throws MojoExecutionException {
                try {
                    SyncService syncService = device.getSyncService();
                    syncService.pullFile(sourcePath, destinationPath, (SyncService.ISyncProgressMonitor)new LogSyncProgressMonitor(PullMojo.this.getLog()));
                    PullMojo.this.getLog().info((CharSequence)(message + device.getSerialNumber() + " (avdName=" + device.getAvdName() + ") successful."));
                }
                catch (SyncException e) {
                    throw new MojoExecutionException(message + device.getSerialNumber() + " (avdName=" + device.getAvdName() + ") failed.", (Exception)((Object)e));
                }
                catch (IOException e) {
                    throw new MojoExecutionException(message + device.getSerialNumber() + " (avdName=" + device.getAvdName() + ") failed.", (Exception)e);
                }
                catch (TimeoutException e) {
                    throw new MojoExecutionException(message + device.getSerialNumber() + " (avdName=" + device.getAvdName() + ") failed.", (Exception)((Object)e));
                }
                catch (AdbCommandRejectedException e) {
                    throw new MojoExecutionException(message + device.getSerialNumber() + " (avdName=" + device.getAvdName() + ") failed.", (Exception)((Object)e));
                }
            }
        });
    }
}

