/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.jayway.maven.plugins.android.AbstractAndroidMojo;
import com.jayway.maven.plugins.android.CommandExecutor;
import com.jayway.maven.plugins.android.common.DeviceHelper;
import com.jayway.maven.plugins.android.configuration.Emulator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;

public abstract class AbstractEmulatorMojo
extends AbstractAndroidMojo {
    public static final String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.US);
    private Emulator emulator;
    private String emulatorAvd;
    private String emulatorWait;
    private String emulatorOptions;
    private String parsedAvd;
    private String parsedOptions;
    private String parsedWait;
    private static final String START_EMULATOR_MSG = "Starting android emulator with script: ";
    private static final String START_EMULATOR_WAIT_MSG = "Waiting for emulator start:";
    private static final String scriptFolder = System.getProperty("java.io.tmpdir");

    private boolean isWindows() {
        boolean result = OS_NAME.toLowerCase().contains("windows");
        this.getLog().debug((CharSequence)("isWindows: " + result));
        return result;
    }

    protected void startAndroidEmulator() throws MojoExecutionException {
        this.parseParameters();
        CommandExecutor executor = CommandExecutor.Factory.createDefaultCommmandExecutor();
        executor.setLogger(this.getLog());
        try {
            String filename = this.isWindows() ? this.writeEmulatorStartScriptWindows() : this.writeEmulatorStartScriptUnix();
            AndroidDebugBridge androidDebugBridge = this.initAndroidDebugBridge();
            if (androidDebugBridge.isConnected()) {
                this.waitForInitialDeviceList(androidDebugBridge);
                List<IDevice> devices = Arrays.asList(androidDebugBridge.getDevices());
                int numberOfDevices = devices.size();
                this.getLog().info((CharSequence)("Found " + numberOfDevices + " devices connected with the Android Debug Bridge"));
                IDevice existingEmulator = null;
                for (IDevice device : devices) {
                    if (!device.isEmulator() || !this.isExistingEmulator(device)) continue;
                    existingEmulator = device;
                    break;
                }
                if (existingEmulator == null) {
                    this.getLog().info((CharSequence)(START_EMULATOR_MSG + filename));
                    executor.executeCommand(filename, null);
                    this.getLog().info((CharSequence)(START_EMULATOR_WAIT_MSG + this.parsedWait));
                    Thread.sleep(new Long(this.parsedWait));
                } else {
                    this.getLog().info((CharSequence)String.format("Emulator already running [Serial No: '%s', AVD Name '%s']. Skipping start and wait.", existingEmulator.getSerialNumber(), existingEmulator.getAvdName()));
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("", e);
        }
    }

    private boolean isExistingEmulator(IDevice device) {
        return device.getAvdName().equalsIgnoreCase(this.parsedAvd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeEmulatorStartScriptWindows() throws MojoExecutionException {
        String filename = scriptFolder + "\\android-maven-plugin-emulator-start.vbs";
        File file = new File(filename);
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new FileWriter(file));
            String command = this.assembleStartCommandLine();
            String uniqueWindowTitle = "AndroidMavenPlugin-AVD" + this.parsedAvd;
            writer.println("Dim oShell");
            writer.println("Set oShell = WScript.CreateObject(\"WScript.shell\")");
            String cmdPath = System.getenv("COMSPEC");
            if (cmdPath == null) {
                cmdPath = "cmd.exe";
            }
            String cmd = cmdPath + " /X /C START /SEPARATE \"\"" + uniqueWindowTitle + "\"\"  " + command.trim();
            writer.println("oShell.run \"" + cmd + "\"");
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("Failure writing file " + filename));
        }
        finally {
            if (writer != null) {
                writer.flush();
                writer.close();
            }
        }
        file.setExecutable(true);
        return filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeEmulatorStartScriptUnix() throws MojoExecutionException {
        String filename = scriptFolder + "/android-maven-plugin-emulator-start.sh";
        File sh = new File("/bin/bash");
        if (!sh.exists()) {
            sh = new File("/usr/bin/bash");
        }
        if (!sh.exists()) {
            sh = new File("/bin/sh");
        }
        File file = new File(filename);
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new FileWriter(file));
            writer.println("#!" + sh.getAbsolutePath());
            writer.print(this.assembleStartCommandLine());
            writer.print(" 1>/dev/null 2>&1 &");
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("Failure writing file " + filename));
        }
        finally {
            if (writer != null) {
                writer.flush();
                writer.close();
            }
        }
        file.setExecutable(true);
        return filename;
    }

    protected void stopAndroidEmulator() throws MojoExecutionException {
        this.parseParameters();
        AndroidDebugBridge androidDebugBridge = this.initAndroidDebugBridge();
        if (androidDebugBridge.isConnected()) {
            List<IDevice> devices = Arrays.asList(androidDebugBridge.getDevices());
            int numberOfDevices = devices.size();
            this.getLog().info((CharSequence)("Found " + numberOfDevices + " devices connected with the Android Debug Bridge"));
            for (IDevice device : devices) {
                if (device.isEmulator()) {
                    if (!this.isExistingEmulator(device)) continue;
                    this.stopEmulator(device);
                    continue;
                }
                this.getLog().info((CharSequence)("Skipping stop. Not an emulator. " + DeviceHelper.getDescriptiveName(device)));
            }
        }
    }

    protected void stopAndroidEmulators() throws MojoExecutionException {
        AndroidDebugBridge androidDebugBridge = this.initAndroidDebugBridge();
        if (androidDebugBridge.isConnected()) {
            List<IDevice> devices = Arrays.asList(androidDebugBridge.getDevices());
            int numberOfDevices = devices.size();
            this.getLog().info((CharSequence)("Found " + numberOfDevices + " devices connected with the Android Debug Bridge"));
            for (IDevice device : devices) {
                if (device.isEmulator()) {
                    this.stopEmulator(device);
                    continue;
                }
                this.getLog().info((CharSequence)("Skipping stop. Not an emulator. " + DeviceHelper.getDescriptiveName(device)));
            }
        }
    }

    private void stopEmulator(IDevice device) {
        int devicePort = this.extractPortFromDevice(device);
        if (devicePort == -1) {
            this.getLog().info((CharSequence)("Unable to retrieve port to stop emulator " + DeviceHelper.getDescriptiveName(device)));
        } else {
            this.getLog().info((CharSequence)("Stopping emulator " + DeviceHelper.getDescriptiveName(device)));
            this.sendEmulatorCommand(devicePort, "avd stop");
            boolean killed = this.sendEmulatorCommand(devicePort, "kill");
            if (!killed) {
                this.getLog().info((CharSequence)("Emulator failed to stop " + DeviceHelper.getDescriptiveName(device)));
            } else {
                this.getLog().info((CharSequence)("Emulator stopped successfully " + DeviceHelper.getDescriptiveName(device)));
            }
        }
    }

    private int extractPortFromDevice(IDevice device) {
        String portStr = StringUtils.substringAfterLast((String)device.getSerialNumber(), (String)"-");
        if (StringUtils.isNotBlank((String)portStr) && StringUtils.isNumeric((String)portStr)) {
            return Integer.parseInt(portStr);
        }
        return -1;
    }

    private boolean sendEmulatorCommand(final int port, final String command) {
        Callable<Boolean> task = new Callable<Boolean>(){
            private static final long serialVersionUID = 1L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() throws IOException {
                Socket socket = null;
                BufferedReader in = null;
                PrintWriter out = null;
                try {
                    socket = new Socket("127.0.0.1", port);
                    out = new PrintWriter(socket.getOutputStream(), true);
                    in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                    if (in.readLine() == null) {
                        Boolean bl = false;
                        return bl;
                    }
                    out.write(command);
                    out.write("\r\n");
                }
                finally {
                    try {
                        out.close();
                        in.close();
                        socket.close();
                    }
                    catch (Exception e) {}
                }
                return true;
            }
        };
        boolean result = false;
        try {
            ExecutorService executor = Executors.newSingleThreadExecutor();
            Future<Boolean> future = executor.submit(task);
            result = future.get();
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)String.format("Failed to execute emulator command '%s': %s", command, e));
        }
        return result;
    }

    private String assembleStartCommandLine() throws MojoExecutionException {
        StringBuilder startCommandline = new StringBuilder().append(this.getAndroidSdk().getEmulatorPath()).append(" -avd ").append(this.parsedAvd).append(" ");
        if (!StringUtils.isEmpty((String)this.parsedOptions)) {
            startCommandline.append(this.parsedOptions);
        }
        this.getLog().info((CharSequence)("Android emulator command: " + startCommandline));
        return startCommandline.toString();
    }

    private void parseParameters() {
        if (this.emulator != null) {
            this.parsedAvd = this.emulator.getAvd() != null ? this.emulator.getAvd() : this.determineAvd();
            this.parsedOptions = this.emulator.getOptions() != null ? this.emulator.getOptions() : this.determineOptions();
            this.parsedWait = this.emulator.getWait() != null ? this.emulator.getWait() : this.determineWait();
        } else {
            this.parsedAvd = this.determineAvd();
            this.parsedOptions = this.determineOptions();
            this.parsedWait = this.determineWait();
        }
    }

    private String determineWait() {
        String wait = this.emulatorWait != null ? this.emulatorWait : "5000";
        return wait;
    }

    private String determineOptions() {
        String options = this.emulatorOptions != null ? this.emulatorOptions : "";
        return options;
    }

    private String determineAvd() {
        String avd = this.emulatorAvd != null ? this.emulatorAvd : "Default";
        return avd;
    }
}

