/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.schemaregistry.serdes.avro;

import com.hortonworks.registries.schemaregistry.SchemaIdVersion;
import com.hortonworks.registries.schemaregistry.serde.SerDesException;
import com.hortonworks.registries.schemaregistry.serdes.avro.AbstractAvroSerDesProtocolHandler;
import com.hortonworks.registries.schemaregistry.serdes.avro.DefaultAvroSerDesHandler;
import com.hortonworks.registries.schemaregistry.serdes.avro.exceptions.AvroRetryableException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class SchemaVersionIdAsLongProtocolHandler
extends AbstractAvroSerDesProtocolHandler {
    public SchemaVersionIdAsLongProtocolHandler() {
        super((byte)2, new DefaultAvroSerDesHandler());
    }

    @Override
    public void doHandleSchemaVersionSerialization(OutputStream outputStream, SchemaIdVersion schemaIdVersion) throws SerDesException {
        try {
            Long versionId = schemaIdVersion.getSchemaVersionId();
            outputStream.write(ByteBuffer.allocate(8).putLong(versionId).array());
        }
        catch (IOException e) {
            throw new AvroRetryableException(e);
        }
    }

    @Override
    public SchemaIdVersion handleSchemaVersionDeserialization(InputStream inputStream) throws SerDesException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        try {
            inputStream.read(byteBuffer.array());
        }
        catch (IOException e) {
            throw new AvroRetryableException(e);
        }
        return new SchemaIdVersion(Long.valueOf(byteBuffer.getLong()));
    }

    @Override
    public Byte getProtocolId() {
        return this.protocolId;
    }
}

