/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.schemaregistry.serdes.avro;

import com.hortonworks.registries.schemaregistry.serdes.avro.AvroSerDesHandler;
import com.hortonworks.registries.schemaregistry.serdes.avro.AvroUtils;
import com.hortonworks.registries.schemaregistry.serdes.avro.exceptions.AvroException;
import com.hortonworks.registries.schemaregistry.serdes.avro.exceptions.AvroRetryableException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.specific.SpecificRecord;
import org.apache.commons.io.IOUtils;

public class DefaultAvroSerDesHandler
implements AvroSerDesHandler {
    private final Map<String, Schema> readerSchemaCache = new ConcurrentHashMap<String, Schema>();

    @Override
    public void handlePayloadSerialization(OutputStream outputStream, Object input) {
        try {
            Schema schema = AvroUtils.computeSchema(input);
            Schema.Type schemaType = schema.getType();
            if (Schema.Type.BYTES.equals((Object)schemaType)) {
                outputStream.write((byte[])input);
            } else if (Schema.Type.STRING.equals((Object)schemaType)) {
                outputStream.write(input.toString().getBytes("UTF-8"));
            } else {
                BinaryEncoder encoder = EncoderFactory.get().binaryEncoder(outputStream, null);
                boolean isSpecificRecord = input instanceof SpecificRecord;
                Object writer = isSpecificRecord ? new SpecificDatumWriter(schema) : new GenericDatumWriter(schema);
                writer.write(input, (Encoder)encoder);
                encoder.flush();
            }
        }
        catch (IOException e) {
            throw new AvroRetryableException(e);
        }
        catch (RuntimeException e) {
            throw new AvroException(e);
        }
    }

    @Override
    public Object handlePayloadDeserialization(InputStream payloadInputStream, Schema writerSchema, Schema readerSchema, boolean useSpecificAvroReader) {
        Object deserializedObj;
        Schema.Type writerSchemaType = writerSchema.getType();
        try {
            if (Schema.Type.BYTES.equals((Object)writerSchemaType)) {
                deserializedObj = IOUtils.toByteArray((InputStream)payloadInputStream);
            } else if (Schema.Type.STRING.equals((Object)writerSchemaType)) {
                deserializedObj = new String(IOUtils.toByteArray((InputStream)payloadInputStream), AvroUtils.UTF_8);
            } else {
                DatumReader datumReader = this.getDatumReader(writerSchema, readerSchema, useSpecificAvroReader);
                deserializedObj = datumReader.read(null, (Decoder)DecoderFactory.get().binaryDecoder(payloadInputStream, null));
            }
        }
        catch (IOException e) {
            throw new AvroRetryableException(e);
        }
        catch (Exception e) {
            throw new AvroException(e);
        }
        return deserializedObj;
    }

    private DatumReader getDatumReader(Schema writerSchema, Schema readerSchema, boolean useSpecificAvroReader) {
        if (useSpecificAvroReader) {
            if (readerSchema == null) {
                readerSchema = this.getReaderSchema(writerSchema);
            }
            return new SpecificDatumReader(writerSchema, readerSchema);
        }
        return readerSchema == null ? new GenericDatumReader(writerSchema) : new GenericDatumReader(writerSchema, readerSchema);
    }

    private Schema getReaderSchema(Schema writerSchema) {
        Schema readerSchema = this.readerSchemaCache.get(writerSchema.getFullName());
        if (readerSchema == null) {
            Class readerClass = SpecificData.get().getClass(writerSchema);
            if (readerClass == null) {
                throw new AvroException("Could not find class " + writerSchema.getFullName() + " specified in writer's schema whilst finding reader's schema for a SpecificRecord.");
            }
            try {
                readerSchema = ((SpecificRecord)readerClass.newInstance()).getSchema();
            }
            catch (InstantiationException e) {
                throw new AvroException(writerSchema.getFullName() + " specified by the writers schema could not be instantiated to find the readers schema.");
            }
            catch (IllegalAccessException e) {
                throw new AvroException(writerSchema.getFullName() + " specified by the writers schema is not allowed to be instantiated to find the readers schema.");
            }
            this.readerSchemaCache.put(writerSchema.getFullName(), readerSchema);
        }
        return readerSchema;
    }
}

