/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.schemaregistry.serdes.avro;

import com.hortonworks.registries.schemaregistry.serdes.avro.AvroSerDesHandler;
import com.hortonworks.registries.schemaregistry.serdes.avro.AvroUtils;
import com.hortonworks.registries.schemaregistry.serdes.avro.exceptions.AvroException;
import com.hortonworks.registries.schemaregistry.serdes.avro.exceptions.AvroRetryableException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.specific.SpecificRecord;
import org.apache.commons.io.IOUtils;

public class ConfluentAvroSerDesHandler
implements AvroSerDesHandler {
    private final Map<String, Schema> readerSchemaCache = new ConcurrentHashMap<String, Schema>();

    @Override
    public void handlePayloadSerialization(OutputStream outputStream, Object input) {
        try {
            Schema schema = AvroUtils.computeSchema(input);
            if (input instanceof byte[]) {
                outputStream.write((byte[])input);
            } else {
                BinaryEncoder encoder = EncoderFactory.get().binaryEncoder(outputStream, null);
                Object writer = input instanceof SpecificRecord ? new SpecificDatumWriter(schema) : new GenericDatumWriter(schema);
                writer.write(input, (Encoder)encoder);
                encoder.flush();
            }
        }
        catch (IOException e) {
            throw new AvroRetryableException("Error serializing Avro message", e);
        }
        catch (RuntimeException e) {
            throw new AvroException("Error serializing Avro message", e);
        }
    }

    @Override
    public Object handlePayloadDeserialization(InputStream payloadInputStream, Schema writerSchema, Schema readerSchema, boolean useSpecificAvroReader) {
        Object deserializedObj;
        try {
            if (Schema.Type.BYTES.equals((Object)writerSchema.getType())) {
                deserializedObj = IOUtils.toByteArray((InputStream)payloadInputStream);
            } else {
                DatumReader datumReader = this.getDatumReader(writerSchema, readerSchema, useSpecificAvroReader);
                deserializedObj = datumReader.read(null, (Decoder)DecoderFactory.get().binaryDecoder(payloadInputStream, null));
            }
        }
        catch (IOException e) {
            throw new AvroRetryableException("Error deserializing Avro message for id " + writerSchema, e);
        }
        catch (RuntimeException e) {
            throw new AvroException("Error deserializing Avro message for id " + writerSchema, e);
        }
        return deserializedObj;
    }

    private DatumReader getDatumReader(Schema writerSchema, Schema readerSchema, boolean useSpecificAvroReader) {
        if (useSpecificAvroReader) {
            if (readerSchema == null) {
                readerSchema = this.getReaderSchema(writerSchema);
            }
            return new SpecificDatumReader(writerSchema, readerSchema);
        }
        return readerSchema == null ? new GenericDatumReader(writerSchema) : new GenericDatumReader(writerSchema, readerSchema);
    }

    private Schema getReaderSchema(Schema writerSchema) {
        Schema readerSchema = this.readerSchemaCache.get(writerSchema.getFullName());
        if (readerSchema == null) {
            Class readerClass = SpecificData.get().getClass(writerSchema);
            if (readerClass == null) {
                throw new AvroException("Could not find class " + writerSchema.getFullName() + " specified in writer's schema whilst finding reader's schema for a SpecificRecord.");
            }
            try {
                readerSchema = ((SpecificRecord)readerClass.newInstance()).getSchema();
            }
            catch (InstantiationException e) {
                throw new AvroException(writerSchema.getFullName() + " specified by the writers schema could not be instantiated to find the readers schema.");
            }
            catch (IllegalAccessException e) {
                throw new AvroException(writerSchema.getFullName() + " specified by the writers schema is not allowed to be instantiated to find the readers schema.");
            }
            this.readerSchemaCache.put(writerSchema.getFullName(), readerSchema);
        }
        return readerSchema;
    }
}

