/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.schemaregistry.state;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.collect.Lists;
import com.hortonworks.registries.schemaregistry.state.BaseSchemaVersionLifecycleState;
import com.hortonworks.registries.schemaregistry.state.SchemaVersionLifecycleState;
import com.hortonworks.registries.schemaregistry.state.SchemaVersionLifecycleStateTransition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class SchemaVersionLifecycleStateMachineInfo
implements Serializable {
    private static final long serialVersionUID = -3499349707355937574L;
    private Collection<BaseSchemaVersionLifecycleState> states;
    private Collection<SchemaVersionLifecycleStateTransition> transitions;

    private SchemaVersionLifecycleStateMachineInfo() {
    }

    SchemaVersionLifecycleStateMachineInfo(Collection<SchemaVersionLifecycleState> states, Collection<SchemaVersionLifecycleStateTransition> transitions) {
        this.states = new ArrayList<BaseSchemaVersionLifecycleState>(states.size());
        this.transitions = Lists.newArrayList(transitions);
        for (SchemaVersionLifecycleState state : states) {
            this.states.add(new BaseSchemaVersionLifecycleState(state.getName(), state.getId(), state.getDescription()));
        }
    }

    public Collection<BaseSchemaVersionLifecycleState> getStates() {
        return this.states;
    }

    public Collection<SchemaVersionLifecycleStateTransition> getTransitions() {
        return this.transitions;
    }

    public String toString() {
        return "Configuration{states=" + this.states + ", transitions=" + this.transitions + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaVersionLifecycleStateMachineInfo that = (SchemaVersionLifecycleStateMachineInfo)o;
        if (this.states != null ? !this.states.equals(that.states) : that.states != null) {
            return false;
        }
        return this.transitions != null ? this.transitions.equals(that.transitions) : that.transitions == null;
    }

    public int hashCode() {
        int result = this.states != null ? this.states.hashCode() : 0;
        result = 31 * result + (this.transitions != null ? this.transitions.hashCode() : 0);
        return result;
    }
}

