/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.schemaregistry.avro;

import com.hortonworks.registries.schemaregistry.SchemaFieldInfo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.avro.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroFieldsGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(AvroFieldsGenerator.class);

    public List<SchemaFieldInfo> generateFields(Schema rootSchema) {
        ArrayList<SchemaFieldInfo> schemaFieldInfos = new ArrayList<SchemaFieldInfo>();
        this.parse(rootSchema, schemaFieldInfos);
        return schemaFieldInfos;
    }

    private void parse(Schema schema, List<SchemaFieldInfo> schemaFieldInfos) {
        if (schema.getType() != Schema.Type.RECORD) {
            LOG.info("Given schema type [{}] is not record", (Object)schema.getType());
        } else {
            String fullName = schema.getFullName();
            LOG.debug("Schema full name: [{}]", (Object)fullName);
            List fields = schema.getFields();
            HashSet<String> visitedRecords = new HashSet<String>();
            visitedRecords.add(schema.getFullName());
            for (Schema.Field field : fields) {
                this.parseField(field, schemaFieldInfos, visitedRecords);
            }
        }
    }

    private void parseField(Schema.Field field, List<SchemaFieldInfo> schemaFieldInfos, Set<String> visitedRecords) {
        Schema schema = field.schema();
        Schema.Type type = schema.getType();
        String name = field.name();
        LOG.debug("Visiting field: [{}]", (Object)field);
        String namespace = null;
        try {
            namespace = schema.getNamespace();
        }
        catch (Exception exception) {
            // empty catch block
        }
        schemaFieldInfos.add(new SchemaFieldInfo(namespace, name, type.name()));
        this.parseSchema(schema, schemaFieldInfos, visitedRecords);
    }

    private void parseSchema(Schema schema, List<SchemaFieldInfo> schemaFieldInfos, Set<String> visitedRecords) {
        Schema.Type type = schema.getType();
        LOG.debug("Visiting type: [{}]", (Object)type);
        switch (type) {
            case RECORD: {
                String completeName = schema.getFullName();
                if (visitedRecords.contains(completeName)) break;
                visitedRecords.add(completeName);
                List fields = schema.getFields();
                for (Schema.Field recordField : fields) {
                    this.parseField(recordField, schemaFieldInfos, visitedRecords);
                }
                break;
            }
            case MAP: {
                Schema valueTypeSchema = schema.getValueType();
                this.parseSchema(valueTypeSchema, schemaFieldInfos, visitedRecords);
                break;
            }
            case ENUM: {
                break;
            }
            case ARRAY: {
                Schema elementType = schema.getElementType();
                this.parseSchema(elementType, schemaFieldInfos, visitedRecords);
                break;
            }
            case UNION: {
                List unionTypes = schema.getTypes();
                for (Schema typeSchema : unionTypes) {
                    this.parseSchema(typeSchema, schemaFieldInfos, visitedRecords);
                }
                break;
            }
            case STRING: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case FIXED: 
            case BOOLEAN: 
            case BYTES: 
            case NULL: {
                break;
            }
            default: {
                throw new RuntimeException("Unsupported type: " + type);
            }
        }
    }
}

