/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.schemaregistry;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.hortonworks.registries.schemaregistry.SchemaCompatibility;
import com.hortonworks.registries.schemaregistry.SchemaValidationLevel;
import java.io.Serializable;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SchemaMetadata
implements Serializable {
    private static final long serialVersionUID = -6880986623123299254L;
    private String type;
    private String schemaGroup;
    private String name;
    private String description;
    private SchemaCompatibility compatibility;
    private SchemaValidationLevel validationLevel;
    @JsonProperty(value="evolve")
    public boolean evolve = true;

    private SchemaMetadata() {
    }

    private SchemaMetadata(String name, String type, String schemaGroup, String description, SchemaCompatibility compatibility, SchemaValidationLevel validationLevel, boolean evolve) {
        Preconditions.checkNotNull((Object)name, (Object)"name can not be null");
        Preconditions.checkNotNull((Object)type, (Object)"type can not be null");
        this.name = name;
        this.type = type;
        this.schemaGroup = schemaGroup;
        this.description = description;
        this.evolve = evolve;
        this.compatibility = compatibility;
        this.validationLevel = validationLevel;
    }

    public String getName() {
        return this.name;
    }

    public String getSchemaGroup() {
        return this.schemaGroup;
    }

    public String getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public SchemaCompatibility getCompatibility() {
        return this.compatibility != null ? this.compatibility : SchemaCompatibility.DEFAULT_COMPATIBILITY;
    }

    public SchemaValidationLevel getValidationLevel() {
        return this.validationLevel != null ? this.validationLevel : SchemaValidationLevel.DEFAULT_VALIDATION_LEVEL;
    }

    public boolean isEvolve() {
        return this.evolve;
    }

    public String toString() {
        return "SchemaMetadata{type='" + this.type + '\'' + ", schemaGroup='" + this.schemaGroup + '\'' + ", name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", compatibility=" + (Object)((Object)this.compatibility) + ", validationLevel=" + (Object)((Object)this.validationLevel) + ", evolve=" + this.evolve + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaMetadata that = (SchemaMetadata)o;
        if (this.evolve != that.evolve) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        if (this.schemaGroup != null ? !this.schemaGroup.equals(that.schemaGroup) : that.schemaGroup != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.getValidationLevel() != null ? !this.getValidationLevel().equals((Object)that.getValidationLevel()) : that.getValidationLevel() != null) {
            return false;
        }
        return this.getCompatibility() == that.getCompatibility();
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.schemaGroup != null ? this.schemaGroup.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.getCompatibility() != null ? this.getCompatibility().hashCode() : 0);
        result = 31 * result + (this.getValidationLevel() != null ? this.getValidationLevel().hashCode() : 0);
        result = 31 * result + (this.evolve ? 1 : 0);
        return result;
    }

    public void trim() {
        this.name = this.name != null ? this.name.trim() : this.name;
        this.type = this.type != null ? this.type.trim() : this.type;
    }

    public static class Builder {
        private final String name;
        private String type;
        private String schemaGroup;
        private String description;
        private SchemaCompatibility compatibility;
        private SchemaValidationLevel validationLevel;
        private boolean evolve = true;

        public Builder(String name) {
            Preconditions.checkNotNull((Object)name, (Object)"name can not be null");
            this.name = name;
        }

        public Builder(SchemaMetadata schemaMetadata) {
            this.name = schemaMetadata.getName();
            this.type = schemaMetadata.getType();
            this.schemaGroup = schemaMetadata.getSchemaGroup();
            this.description = schemaMetadata.getDescription();
            this.compatibility = schemaMetadata.getCompatibility();
            this.validationLevel = schemaMetadata.getValidationLevel();
            this.evolve = schemaMetadata.isEvolve();
        }

        public Builder schemaGroup(String schemaGroup) {
            this.schemaGroup = schemaGroup;
            return this;
        }

        public Builder type(String type) {
            Preconditions.checkNotNull((Object)type, (Object)"type can not be null");
            this.type = type;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder compatibility(SchemaCompatibility compatibility) {
            this.compatibility = compatibility;
            return this;
        }

        public Builder validationLevel(SchemaValidationLevel validationLevel) {
            this.validationLevel = validationLevel;
            return this;
        }

        public Builder evolve(boolean evolve) {
            this.evolve = evolve;
            return this;
        }

        public SchemaMetadata build() {
            return new SchemaMetadata(this.name, this.type, this.schemaGroup, this.description, this.compatibility, this.validationLevel, this.evolve);
        }
    }
}

