/*
 * #%L
 * SGQ :: Web
 * $Id: LabelsAction.java 105 2012-09-28 14:22:53Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.3/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/user/LabelsAction.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.user;

import java.io.File;
import java.util.Date;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.herbocailleau.sgq.business.model.ImportLog;
import com.herbocailleau.sgq.business.services.ProductionService;
import com.herbocailleau.sgq.entities.Zone;
import com.herbocailleau.sgq.web.SgqActionSupport;

/**
 * Action d'import de reception des lots.
 * 
 * @author echatellier
 */
public class LabelsAction extends SgqActionSupport {

    /** serialVersionUID. */
    private static final long serialVersionUID = 3074255662512738956L;

    private static final Log log = LogFactory.getLog(LabelsAction.class);

    protected Date productionLastImportDate;

    protected Date expeditionLastImportDate;

    protected File file;

    protected String fileFileName;

    protected List<ImportLog> importLogs;

    @Override
    public String input() throws Exception {

        ProductionService productionService = newService(ProductionService.class);
        productionLastImportDate = productionService.getLastImportDate(Zone.ZE);
        expeditionLastImportDate = productionService.getLastImportDate(Zone.ZP);
        return super.input();
    }

    public Date getProductionStartDate() {
        return productionLastImportDate;
    }

    public Date getExpeditionStartDate() {
        return expeditionLastImportDate;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setFileFileName(String fileFileName) {
        this.fileFileName = fileFileName;
    }

    @Override
    public String execute() throws Exception {
        String result = super.execute();
        ProductionService productionService = newService(ProductionService.class);
        try {
            importLogs = productionService.importLabelsFile(fileFileName, file);
        } catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error("Can't import labels file", ex);
            }
            addActionError(ex.getMessage());
            result = input();
        }

        return result;
    }
    
    public List<ImportLog> getImportLogs() {
        return importLogs;
    }
}
