/*
 * #%L
 * SGQ :: Web
 * $Id: BatchEditAction.java 112 2012-10-02 09:34:04Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.3/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/user/BatchEditAction.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.user;

import java.text.ParseException;

import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import com.herbocailleau.sgq.business.SgqUtils;
import com.herbocailleau.sgq.business.services.BatchService;
import com.herbocailleau.sgq.entities.Batch;
import com.herbocailleau.sgq.web.SgqActionSupport;

/**
 * Action d'edition des informations d'un lot (dpmes, date d'expiration).
 * 
 * @author echatellier
 */
public class BatchEditAction extends SgqActionSupport {

    /** serialVersionUID. */
    private static final long serialVersionUID = 3074255662512738956L;

    protected String batchId;

    protected Batch batch;

    protected String dpmes;
    
    protected String comment;
    
    protected String elapsedDate;

    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }

    @Override
    public String input() throws Exception {
        BatchService batchService = newService(BatchService.class);
        batch = batchService.getBatchById(batchId);
        return INPUT;
    }

    public Batch getBatch() {
        return batch;
    }

    public void setDpmes(String dpmes) {
        this.dpmes = dpmes;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setElapsedDate(String elapsedDate) {
        this.elapsedDate = elapsedDate;
    }

    @Override
    @Action(results={@Result(type="redirectAction", params = {"actionName", "batch", "batchId", "${batch.topiaId}"})})
    public String execute() throws Exception {
        String result = SUCCESS;

        BatchService batchService = newService(BatchService.class);
        batch = batchService.getBatchById(batchId);

        try {
            if (StringUtils.isNotBlank(dpmes)) {
                batch.setDpmes(SgqUtils.parseSgqDate(dpmes));
            } else {
                batch.setDpmes(null);
            }
            if (StringUtils.isNotBlank(elapsedDate)) {
                batch.setElapsedDate(SgqUtils.parseSgqDate(elapsedDate));
            } else {
                batch.setElapsedDate(null);
            }
            batch.setComment(comment);
            
            batchService.saveBatch(batch);
        } catch (ParseException ex) {
            addActionError("Format de date invalide (dd/MM/yyyy)");
            result = INPUT;
        }
        return result;
    }
}
