/*
 * #%L
 * SGQ :: Web
 * $Id: AnalyzeCategoryAction.java 73 2012-09-19 13:18:29Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.3/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/admin/AnalyzeCategoryAction.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.admin;

import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import com.herbocailleau.sgq.business.services.ReferentialService;
import com.herbocailleau.sgq.entities.AnalyzeCategory;
import com.herbocailleau.sgq.entities.AnalyzeCategoryImpl;
import com.herbocailleau.sgq.web.SgqActionSupport;
import com.opensymphony.xwork2.Preparable;

public class AnalyzeCategoryAction extends SgqActionSupport implements Preparable {

    /** serialVersionUID. */
    private static final long serialVersionUID = 6915148559808770928L;

    protected ReferentialService referentialService;

    protected String analyzeCategoryId;

    protected AnalyzeCategory analyzeCategory;

    public void setAnalyzeCategoryId(String analyzeCategoryId) {
        this.analyzeCategoryId = analyzeCategoryId;
    }

    @Override
    public void prepare() throws Exception {
        referentialService = newService(ReferentialService.class);
    }

    @Override
    @Action(results={@Result(type="redirectAction", params = {"actionName" , "analyze-types"})})
    public String execute() throws Exception {

        referentialService.saveAnalyzeCategory(analyzeCategory);
        return SUCCESS;
    }

    public AnalyzeCategory getAnalyzeCategory() {
        if (analyzeCategory == null) {
            String analyzeCategoryId = getParameter("analyzeCategoryId");
            if (StringUtils.isNotBlank(analyzeCategoryId)) {
                analyzeCategory = referentialService.findAnalyzeCategoryById(analyzeCategoryId);
            } else {
                analyzeCategory = new AnalyzeCategoryImpl();
            }
        }
        return analyzeCategory;
    }
}
