/*
 * Decompiled with CFR 0.152.
 */
package com.helger.io.resourceprovider;

import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.io.resource.IReadableResource;
import com.helger.io.resourceprovider.IReadableResourceProvider;
import java.io.InputStream;
import java.util.function.Predicate;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Immutable
public class ReadableResourceProviderChain
implements IReadableResourceProvider {
    private final ICommonsList<IReadableResourceProvider> m_aReadingResourceProviders;

    public ReadableResourceProviderChain(IReadableResourceProvider ... iReadableResourceProviderArray) {
        ValueEnforcer.notEmptyNoNullValue((Object[])iReadableResourceProviderArray, (String)"ResourceProviders");
        this.m_aReadingResourceProviders = new CommonsArrayList((Object[])iReadableResourceProviderArray);
    }

    public ReadableResourceProviderChain(@NonNull Iterable<? extends IReadableResourceProvider> iterable) {
        ValueEnforcer.notEmptyNoNullValue(iterable, (String)"ResourceProviders");
        this.m_aReadingResourceProviders = new CommonsArrayList(iterable);
    }

    @ReturnsMutableObject
    protected final @NonNull ICommonsList<IReadableResourceProvider> readingResourceProviders() {
        return this.m_aReadingResourceProviders;
    }

    @ReturnsMutableCopy
    public final @NonNull ICommonsList<IReadableResourceProvider> getAllContainedReadingResourceProviders() {
        return (ICommonsList)this.m_aReadingResourceProviders.getClone();
    }

    @Override
    public final boolean supportsReading(@Nullable String string) {
        return this.m_aReadingResourceProviders.containsAny(iReadableResourceProvider -> iReadableResourceProvider.supportsReading(string));
    }

    @Override
    @OverrideOnDemand
    public @NonNull IReadableResource getReadableResource(@NonNull String string) {
        for (IReadableResourceProvider iReadableResourceProvider : this.m_aReadingResourceProviders) {
            if (!iReadableResourceProvider.supportsReading(string)) continue;
            return iReadableResourceProvider.getReadableResource(string);
        }
        throw new IllegalArgumentException("Cannot handle reading '" + string + "' by any of " + String.valueOf(this.m_aReadingResourceProviders));
    }

    public @Nullable IReadableResource getReadableResourceIf(@NonNull String string, @NonNull Predicate<? super IReadableResource> predicate) {
        for (IReadableResourceProvider iReadableResourceProvider : this.m_aReadingResourceProviders) {
            IReadableResource iReadableResource;
            if (!iReadableResourceProvider.supportsReading(string) || !predicate.test(iReadableResource = iReadableResourceProvider.getReadableResource(string))) continue;
            return iReadableResource;
        }
        return null;
    }

    @Override
    public @Nullable InputStream getInputStream(@NonNull String string) {
        for (IReadableResourceProvider iReadableResourceProvider : this.m_aReadingResourceProviders) {
            InputStream inputStream = iReadableResourceProvider.getInputStream(string);
            if (inputStream == null) continue;
            return inputStream;
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ReadableResourceProviderChain readableResourceProviderChain = (ReadableResourceProviderChain)object;
        return this.m_aReadingResourceProviders.equals(readableResourceProviderChain.m_aReadingResourceProviders);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aReadingResourceProviders).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("readableResProviders", this.m_aReadingResourceProviders).getToString();
    }
}

