/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.thirdparty;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.ELockType;
import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.MustBeLocked;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.CodingStyleguideUnaware;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.spi.ServiceLoaderHelper;
import com.helger.base.state.EChange;
import com.helger.base.thirdparty.IThirdPartyModule;
import com.helger.base.thirdparty.IThirdPartyModuleProviderSPI;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jspecify.annotations.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class ThirdPartyModuleRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThirdPartyModuleRegistry.class);
    private static boolean s_bDefaultInstantiated = false;
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    @CodingStyleguideUnaware
    private final Set<IThirdPartyModule> m_aModules = new LinkedHashSet<IThirdPartyModule>();

    private ThirdPartyModuleRegistry() {
        this.reinitialize();
    }

    public static boolean isInstantiated() {
        return s_bDefaultInstantiated;
    }

    public static @NonNull ThirdPartyModuleRegistry getInstance() {
        ThirdPartyModuleRegistry thirdPartyModuleRegistry = SingletonHolder.INSTANCE;
        s_bDefaultInstantiated = true;
        return thirdPartyModuleRegistry;
    }

    @MustBeLocked(value=ELockType.WRITE)
    private @NonNull EChange _registerThirdPartyModule(@NonNull IThirdPartyModule iThirdPartyModule) {
        ValueEnforcer.notNull(iThirdPartyModule, "Module");
        return EChange.valueOf(this.m_aModules.add(iThirdPartyModule));
    }

    public @NonNull EChange registerThirdPartyModule(@NonNull IThirdPartyModule iThirdPartyModule) {
        return this.m_aRWLock.writeLockedGet(() -> this._registerThirdPartyModule(iThirdPartyModule));
    }

    @ReturnsMutableCopy
    public @NonNull Set<IThirdPartyModule> getAllRegisteredThirdPartyModules() {
        return this.m_aRWLock.readLockedGet(() -> new LinkedHashSet<IThirdPartyModule>(this.m_aModules));
    }

    @Nonnegative
    public int getRegisteredThirdPartyModuleCount() {
        return this.m_aRWLock.readLockedInt(this.m_aModules::size);
    }

    public void reinitialize() {
        this.m_aRWLock.writeLocked(() -> {
            this.m_aModules.clear();
            for (IThirdPartyModuleProviderSPI iThirdPartyModuleProviderSPI : ServiceLoaderHelper.getAllSPIImplementations(IThirdPartyModuleProviderSPI.class)) {
                IThirdPartyModule[] iThirdPartyModuleArray = iThirdPartyModuleProviderSPI.getAllThirdPartyModules();
                if (iThirdPartyModuleArray == null) continue;
                for (IThirdPartyModule iThirdPartyModule : iThirdPartyModuleArray) {
                    this._registerThirdPartyModule(iThirdPartyModule);
                }
            }
        });
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Reinitialized " + ThirdPartyModuleRegistry.class.getName());
        }
    }

    private static final class SingletonHolder {
        private static final ThirdPartyModuleRegistry INSTANCE = new ThirdPartyModuleRegistry();

        private SingletonHolder() {
        }
    }
}

