/*
 * Decompiled with CFR 0.152.
 */
package com.mp4parser.iso14496.part15;

import com.coremedia.iso.Hex;
import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.googlecode.mp4parser.authoring.tracks.CleanInputStream;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.BitReaderBuffer;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.BitWriterBuffer;
import com.googlecode.mp4parser.h264.model.PictureParameterSet;
import com.googlecode.mp4parser.h264.model.SeqParameterSet;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AvcDecoderConfigurationRecord {
    public int configurationVersion;
    public int avcProfileIndication;
    public int profileCompatibility;
    public int avcLevelIndication;
    public int lengthSizeMinusOne;
    public List<byte[]> sequenceParameterSets = new ArrayList<byte[]>();
    public List<byte[]> pictureParameterSets = new ArrayList<byte[]>();
    public boolean hasExts = true;
    public int chromaFormat = 1;
    public int bitDepthLumaMinus8 = 0;
    public int bitDepthChromaMinus8 = 0;
    public List<byte[]> sequenceParameterSetExts = new ArrayList<byte[]>();
    public int lengthSizeMinusOnePaddingBits = 63;
    public int numberOfSequenceParameterSetsPaddingBits = 7;
    public int chromaFormatPaddingBits = 31;
    public int bitDepthLumaMinus8PaddingBits = 31;
    public int bitDepthChromaMinus8PaddingBits = 31;

    public AvcDecoderConfigurationRecord() {
    }

    public AvcDecoderConfigurationRecord(ByteBuffer content) {
        this.configurationVersion = IsoTypeReader.readUInt8(content);
        this.avcProfileIndication = IsoTypeReader.readUInt8(content);
        this.profileCompatibility = IsoTypeReader.readUInt8(content);
        this.avcLevelIndication = IsoTypeReader.readUInt8(content);
        BitReaderBuffer brb = new BitReaderBuffer(content);
        this.lengthSizeMinusOnePaddingBits = brb.readBits(6);
        this.lengthSizeMinusOne = brb.readBits(2);
        this.numberOfSequenceParameterSetsPaddingBits = brb.readBits(3);
        int numberOfSeuqenceParameterSets = brb.readBits(5);
        int i = 0;
        while (i < numberOfSeuqenceParameterSets) {
            int sequenceParameterSetLength = IsoTypeReader.readUInt16(content);
            byte[] sequenceParameterSetNALUnit = new byte[sequenceParameterSetLength];
            content.get(sequenceParameterSetNALUnit);
            this.sequenceParameterSets.add(sequenceParameterSetNALUnit);
            ++i;
        }
        long numberOfPictureParameterSets = IsoTypeReader.readUInt8(content);
        int i2 = 0;
        while ((long)i2 < numberOfPictureParameterSets) {
            int pictureParameterSetLength = IsoTypeReader.readUInt16(content);
            byte[] pictureParameterSetNALUnit = new byte[pictureParameterSetLength];
            content.get(pictureParameterSetNALUnit);
            this.pictureParameterSets.add(pictureParameterSetNALUnit);
            ++i2;
        }
        if (content.remaining() < 4) {
            this.hasExts = false;
        }
        if (this.hasExts && (this.avcProfileIndication == 100 || this.avcProfileIndication == 110 || this.avcProfileIndication == 122 || this.avcProfileIndication == 144)) {
            brb = new BitReaderBuffer(content);
            this.chromaFormatPaddingBits = brb.readBits(6);
            this.chromaFormat = brb.readBits(2);
            this.bitDepthLumaMinus8PaddingBits = brb.readBits(5);
            this.bitDepthLumaMinus8 = brb.readBits(3);
            this.bitDepthChromaMinus8PaddingBits = brb.readBits(5);
            this.bitDepthChromaMinus8 = brb.readBits(3);
            long numOfSequenceParameterSetExt = IsoTypeReader.readUInt8(content);
            int i3 = 0;
            while ((long)i3 < numOfSequenceParameterSetExt) {
                int sequenceParameterSetExtLength = IsoTypeReader.readUInt16(content);
                byte[] sequenceParameterSetExtNALUnit = new byte[sequenceParameterSetExtLength];
                content.get(sequenceParameterSetExtNALUnit);
                this.sequenceParameterSetExts.add(sequenceParameterSetExtNALUnit);
                ++i3;
            }
        } else {
            this.chromaFormat = -1;
            this.bitDepthLumaMinus8 = -1;
            this.bitDepthChromaMinus8 = -1;
        }
    }

    public void getContent(ByteBuffer byteBuffer) {
        IsoTypeWriter.writeUInt8(byteBuffer, this.configurationVersion);
        IsoTypeWriter.writeUInt8(byteBuffer, this.avcProfileIndication);
        IsoTypeWriter.writeUInt8(byteBuffer, this.profileCompatibility);
        IsoTypeWriter.writeUInt8(byteBuffer, this.avcLevelIndication);
        BitWriterBuffer bwb = new BitWriterBuffer(byteBuffer);
        bwb.writeBits(this.lengthSizeMinusOnePaddingBits, 6);
        bwb.writeBits(this.lengthSizeMinusOne, 2);
        bwb.writeBits(this.numberOfSequenceParameterSetsPaddingBits, 3);
        bwb.writeBits(this.pictureParameterSets.size(), 5);
        for (byte[] sequenceParameterSetNALUnit : this.sequenceParameterSets) {
            IsoTypeWriter.writeUInt16(byteBuffer, sequenceParameterSetNALUnit.length);
            byteBuffer.put(sequenceParameterSetNALUnit);
        }
        IsoTypeWriter.writeUInt8(byteBuffer, this.pictureParameterSets.size());
        for (byte[] pictureParameterSetNALUnit : this.pictureParameterSets) {
            IsoTypeWriter.writeUInt16(byteBuffer, pictureParameterSetNALUnit.length);
            byteBuffer.put(pictureParameterSetNALUnit);
        }
        if (this.hasExts && (this.avcProfileIndication == 100 || this.avcProfileIndication == 110 || this.avcProfileIndication == 122 || this.avcProfileIndication == 144)) {
            bwb = new BitWriterBuffer(byteBuffer);
            bwb.writeBits(this.chromaFormatPaddingBits, 6);
            bwb.writeBits(this.chromaFormat, 2);
            bwb.writeBits(this.bitDepthLumaMinus8PaddingBits, 5);
            bwb.writeBits(this.bitDepthLumaMinus8, 3);
            bwb.writeBits(this.bitDepthChromaMinus8PaddingBits, 5);
            bwb.writeBits(this.bitDepthChromaMinus8, 3);
            for (byte[] sequenceParameterSetExtNALUnit : this.sequenceParameterSetExts) {
                IsoTypeWriter.writeUInt16(byteBuffer, sequenceParameterSetExtNALUnit.length);
                byteBuffer.put(sequenceParameterSetExtNALUnit);
            }
        }
    }

    public long getContentSize() {
        long size = 5L;
        ++size;
        for (byte[] sequenceParameterSetNALUnit : this.sequenceParameterSets) {
            size += 2L;
            size += (long)sequenceParameterSetNALUnit.length;
        }
        ++size;
        for (byte[] pictureParameterSetNALUnit : this.pictureParameterSets) {
            size += 2L;
            size += (long)pictureParameterSetNALUnit.length;
        }
        if (this.hasExts && (this.avcProfileIndication == 100 || this.avcProfileIndication == 110 || this.avcProfileIndication == 122 || this.avcProfileIndication == 144)) {
            size += 4L;
            for (byte[] sequenceParameterSetExtNALUnit : this.sequenceParameterSetExts) {
                size += 2L;
                size += (long)sequenceParameterSetExtNALUnit.length;
            }
        }
        return size;
    }

    public String[] getPPS() {
        ArrayList<String> l = new ArrayList<String>();
        for (byte[] pictureParameterSet : this.pictureParameterSets) {
            String details = "not parsable";
            try {
                details = PictureParameterSet.read(new ByteArrayInputStream(pictureParameterSet, 1, pictureParameterSet.length - 1)).toString();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            l.add(details);
        }
        return l.toArray(new String[l.size()]);
    }

    public String[] getSPS() {
        ArrayList<String> l = new ArrayList<String>();
        for (byte[] sequenceParameterSet : this.sequenceParameterSets) {
            String detail = "not parsable";
            try {
                detail = SeqParameterSet.read(new CleanInputStream(new ByteArrayInputStream(sequenceParameterSet, 1, sequenceParameterSet.length - 1))).toString();
            }
            catch (IOException iOException) {}
            l.add(detail);
        }
        return l.toArray(new String[l.size()]);
    }

    public List<String> getSequenceParameterSetsAsStrings() {
        ArrayList<String> result = new ArrayList<String>(this.sequenceParameterSets.size());
        for (byte[] parameterSet : this.sequenceParameterSets) {
            result.add(Hex.encodeHex(parameterSet));
        }
        return result;
    }

    public List<String> getSequenceParameterSetExtsAsStrings() {
        ArrayList<String> result = new ArrayList<String>(this.sequenceParameterSetExts.size());
        for (byte[] parameterSet : this.sequenceParameterSetExts) {
            result.add(Hex.encodeHex(parameterSet));
        }
        return result;
    }

    public List<String> getPictureParameterSetsAsStrings() {
        ArrayList<String> result = new ArrayList<String>(this.pictureParameterSets.size());
        for (byte[] parameterSet : this.pictureParameterSets) {
            result.add(Hex.encodeHex(parameterSet));
        }
        return result;
    }

    public String toString() {
        return "AvcDecoderConfigurationRecord{configurationVersion=" + this.configurationVersion + ", avcProfileIndication=" + this.avcProfileIndication + ", profileCompatibility=" + this.profileCompatibility + ", avcLevelIndication=" + this.avcLevelIndication + ", lengthSizeMinusOne=" + this.lengthSizeMinusOne + ", hasExts=" + this.hasExts + ", chromaFormat=" + this.chromaFormat + ", bitDepthLumaMinus8=" + this.bitDepthLumaMinus8 + ", bitDepthChromaMinus8=" + this.bitDepthChromaMinus8 + ", lengthSizeMinusOnePaddingBits=" + this.lengthSizeMinusOnePaddingBits + ", numberOfSequenceParameterSetsPaddingBits=" + this.numberOfSequenceParameterSetsPaddingBits + ", chromaFormatPaddingBits=" + this.chromaFormatPaddingBits + ", bitDepthLumaMinus8PaddingBits=" + this.bitDepthLumaMinus8PaddingBits + ", bitDepthChromaMinus8PaddingBits=" + this.bitDepthChromaMinus8PaddingBits + '}';
    }
}

