/*
 * Copyright 2010 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.shared.impl.cldr;

// DO NOT EDIT - GENERATED FROM CLDR AND ICU DATA

/**
 * Implementation of DateTimeFormatInfo for the "uk" locale.
 */
public class DateTimeFormatInfoImpl_uk extends DateTimeFormatInfoImpl {

  @Override
  public String[] ampms() {
    return new String[] {
        "дп",
        "пп"
    };
  }

  @Override
  public String dateFormatFull() {
    return "EEEE, d MMMM y 'р'.";
  }

  @Override
  public String dateFormatLong() {
    return "d MMMM y 'р'.";
  }

  @Override
  public String dateFormatMedium() {
    return "d MMM y";
  }

  @Override
  public String dateFormatShort() {
    return "dd.MM.yy";
  }

  @Override
  public String dateTimeFull(String timePattern, String datePattern) {
    return new java.lang.StringBuffer().append(datePattern).append(", ").append(timePattern).toString();
  }

  @Override
  public String dateTimeLong(String timePattern, String datePattern) {
    return new java.lang.StringBuffer().append(datePattern).append(", ").append(timePattern).toString();
  }

  @Override
  public String[] erasFull() {
    return new String[] {
        "до нашої ери",
        "нашої ери"
    };
  }

  @Override
  public String[] erasShort() {
    return new String[] {
        "до н.е.",
        "н.е."
    };
  }

  @Override
  public String formatMonthAbbrevDay() {
    return "d MMM";
  }

  @Override
  public String formatMonthFullDay() {
    return "d MMMM";
  }

  @Override
  public String formatMonthFullWeekdayDay() {
    return "EEEE, d MMMM";
  }

  @Override
  public String formatMonthNumDay() {
    return "d.M";
  }

  @Override
  public String formatYearMonthAbbrev() {
    return "LLL y";
  }

  @Override
  public String formatYearMonthAbbrevDay() {
    return "d MMM y 'р'.";
  }

  @Override
  public String formatYearMonthFull() {
    return "LLLL y";
  }

  @Override
  public String formatYearMonthFullDay() {
    return "d MMMM y 'р'.";
  }

  @Override
  public String formatYearMonthNum() {
    return "M.y";
  }

  @Override
  public String formatYearMonthNumDay() {
    return "d.M.y";
  }

  @Override
  public String formatYearMonthWeekdayDay() {
    return "EEE, d MMM y";
  }

  @Override
  public String formatYearQuarterFull() {
    return "QQQQ y 'р'.";
  }

  @Override
  public String formatYearQuarterShort() {
    return "Q y 'р'.";
  }

  @Override
  public String[] monthsFull() {
    return new String[] {
        "січня",
        "лютого",
        "березня",
        "квітня",
        "травня",
        "червня",
        "липня",
        "серпня",
        "вересня",
        "жовтня",
        "листопада",
        "грудня"
    };
  }

  @Override
  public String[] monthsFullStandalone() {
    return new String[] {
        "Січень",
        "Лютий",
        "Березень",
        "Квітень",
        "Травень",
        "Червень",
        "Липень",
        "Серпень",
        "Вересень",
        "Жовтень",
        "Листопад",
        "Грудень"
    };
  }

  @Override
  public String[] monthsNarrow() {
    return new String[] {
        "С",
        "Л",
        "Б",
        "К",
        "Т",
        "Ч",
        "Л",
        "С",
        "В",
        "Ж",
        "Л",
        "Г"
    };
  }

  @Override
  public String[] monthsShort() {
    return new String[] {
        "січ.",
        "лют.",
        "бер.",
        "квіт.",
        "трав.",
        "черв.",
        "лип.",
        "серп.",
        "вер.",
        "жовт.",
        "лист.",
        "груд."
    };
  }

  @Override
  public String[] monthsShortStandalone() {
    return new String[] {
        "Січ",
        "Лют",
        "Бер",
        "Кві",
        "Тра",
        "Чер",
        "Лип",
        "Сер",
        "Вер",
        "Жов",
        "Лис",
        "Гру"
    };
  }

  @Override
  public String[] quartersFull() {
    return new String[] {
        "I квартал",
        "II квартал",
        "III квартал",
        "IV квартал"
    };
  }

  @Override
  public String[] quartersShort() {
    return new String[] {
        "I кв.",
        "II кв.",
        "III кв.",
        "IV кв."
    };
  }

  @Override
  public String[] weekdaysFull() {
    return new String[] {
        "Неділя",
        "Понеділок",
        "Вівторок",
        "Середа",
        "Четвер",
        "Пʼятниця",
        "Субота"
    };
  }

  @Override
  public String[] weekdaysNarrow() {
    return new String[] {
        "Н",
        "П",
        "В",
        "С",
        "Ч",
        "П",
        "С"
    };
  }

  @Override
  public String[] weekdaysShort() {
    return new String[] {
        "Нд",
        "Пн",
        "Вт",
        "Ср",
        "Чт",
        "Пт",
        "Сб"
    };
  }
}
