/*
 * Copyright 2010 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "pt" locale.
 */
public class LocalizedNamesImpl_pt extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "BR",
        "PT",
        "AO",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AF",
        "ZA",
        "AL",
        "DE",
        "AD",
        "AO",
        "AI",
        "AQ",
        "AG",
        "AN",
        "SA",
        "DZ",
        "AR",
        "AM",
        "AW",
        "AU",
        "AT",
        "AZ",
        "BS",
        "BH",
        "BD",
        "BB",
        "BY",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "BO",
        "BA",
        "BW",
        "BR",
        "BN",
        "BG",
        "BF",
        "BI",
        "BT",
        "CV",
        "KH",
        "CA",
        "KZ",
        "QA",
        "EA",
        "TD",
        "CL",
        "CN",
        "CY",
        "SG",
        "CO",
        "KM",
        "CG",
        "CD",
        "KP",
        "KR",
        "CI",
        "CR",
        "HR",
        "CU",
        "DG",
        "DK",
        "DJ",
        "DM",
        "EG",
        "SV",
        "AE",
        "EC",
        "ER",
        "SK",
        "SI",
        "ES",
        "US",
        "EE",
        "ET",
        "FJ",
        "PH",
        "FI",
        "FR",
        "GA",
        "GM",
        "GH",
        "GE",
        "GS",
        "GI",
        "GD",
        "GR",
        "GL",
        "GP",
        "GU",
        "GT",
        "GG",
        "GY",
        "GF",
        "GN",
        "GW",
        "GQ",
        "HT",
        "NL",
        "HN",
        "HK",
        "HU",
        "YE",
        "BV",
        "AC",
        "CP",
        "IM",
        "HM",
        "NF",
        "AX",
        "KY",
        "IC",
        "CC",
        "CK",
        "FO",
        "FK",
        "MP",
        "MH",
        "UM",
        "CX",
        "SB",
        "TC",
        "VG",
        "VI",
        "IN",
        "ID",
        "IR",
        "IQ",
        "IE",
        "IS",
        "IL",
        "IT",
        "JM",
        "JP",
        "JE",
        "JO",
        "KW",
        "LS",
        "LV",
        "LB",
        "LR",
        "LY",
        "LI",
        "LT",
        "LU",
        "MO",
        "MK",
        "MG",
        "MY",
        "MW",
        "MV",
        "ML",
        "MT",
        "MA",
        "MQ",
        "MU",
        "MR",
        "YT",
        "MX",
        "MM",
        "FM",
        "MZ",
        "MD",
        "MC",
        "MN",
        "ME",
        "MS",
        "NA",
        "NR",
        "NP",
        "NI",
        "NE",
        "NG",
        "NU",
        "NO",
        "NC",
        "NZ",
        "QO",
        "OM",
        "PW",
        "PA",
        "PG",
        "PK",
        "PY",
        "PE",
        "PN",
        "PF",
        "PL",
        "PR",
        "PT",
        "KE",
        "KG",
        "KI",
        "GB",
        "CF",
        "DO",
        "CM",
        "LA",
        "CZ",
        "RE",
        "RO",
        "RW",
        "RU",
        "EH",
        "PM",
        "WS",
        "AS",
        "SM",
        "SH",
        "LC",
        "BL",
        "KN",
        "MF",
        "ST",
        "VC",
        "SN",
        "SL",
        "RS",
        "CS",
        "SC",
        "SY",
        "SO",
        "LK",
        "SZ",
        "SD",
        "SE",
        "CH",
        "SR",
        "SJ",
        "TJ",
        "TH",
        "TW",
        "TZ",
        "IO",
        "TF",
        "PS",
        "TL",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TN",
        "TM",
        "TR",
        "TV",
        "UA",
        "UG",
        "EU",
        "UY",
        "UZ",
        "VU",
        "VA",
        "VE",
        "VN",
        "WF",
        "ZM",
        "ZW",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Mundo");
    namesMap.put("002", "África");
    namesMap.put("003", "América do Norte");
    namesMap.put("005", "América do Sul");
    namesMap.put("011", "África Ocidental");
    namesMap.put("013", "América Central");
    namesMap.put("014", "África Oriental");
    namesMap.put("015", "África do Norte");
    namesMap.put("017", "África Central");
    namesMap.put("018", "África Austral");
    namesMap.put("019", "Américas");
    namesMap.put("021", "América Setentrional");
    namesMap.put("029", "Caribe");
    namesMap.put("030", "Ásia Oriental");
    namesMap.put("034", "Ásia do Sul");
    namesMap.put("035", "Ásia Centro-Oriental");
    namesMap.put("039", "Europa do Sul");
    namesMap.put("053", "Austrália e Nova Zelândia");
    namesMap.put("054", "Melanésia");
    namesMap.put("057", "Região da Micronésia");
    namesMap.put("061", "Polinésia");
    namesMap.put("062", "Ásia Centro-Meridional");
    namesMap.put("142", "Ásia");
    namesMap.put("143", "Ásia Central");
    namesMap.put("145", "Ásia Ocidental");
    namesMap.put("150", "Europa");
    namesMap.put("151", "Europa Oriental");
    namesMap.put("154", "Europa Setentrional");
    namesMap.put("155", "Europa Ocidental");
    namesMap.put("172", "Comunidade dos Estados Independentes");
    namesMap.put("419", "América Latina e Caribe");
    namesMap.put("AC", "Ilha de Ascensão");
    namesMap.put("AE", "Emirados Árabes Unidos");
    namesMap.put("AF", "Afeganistão");
    namesMap.put("AG", "Antígua e Barbuda");
    namesMap.put("AL", "Albânia");
    namesMap.put("AM", "Armênia");
    namesMap.put("AN", "Antilhas Holandesas");
    namesMap.put("AQ", "Antártida");
    namesMap.put("AS", "Samoa Americana");
    namesMap.put("AT", "Áustria");
    namesMap.put("AU", "Austrália");
    namesMap.put("AX", "Ilhas Aland");
    namesMap.put("AZ", "Azerbaijão");
    namesMap.put("BA", "Bósnia-Herzegovina");
    namesMap.put("BE", "Bélgica");
    namesMap.put("BF", "Burquina Faso");
    namesMap.put("BG", "Bulgária");
    namesMap.put("BL", "São Bartolomeu");
    namesMap.put("BM", "Bermudas");
    namesMap.put("BO", "Bolívia");
    namesMap.put("BR", "Brasil");
    namesMap.put("BT", "Butão");
    namesMap.put("BV", "Ilha Bouvet");
    namesMap.put("BW", "Botsuana");
    namesMap.put("CA", "Canadá");
    namesMap.put("CC", "Ilhas Coco");
    namesMap.put("CD", "Congo-Kinshasa");
    namesMap.put("CF", "República Centro-Africana");
    namesMap.put("CG", "Congo - Brazzaville");
    namesMap.put("CH", "Suíça");
    namesMap.put("CI", "Costa do Marfim");
    namesMap.put("CK", "Ilhas Cook");
    namesMap.put("CM", "República dos Camarões");
    namesMap.put("CO", "Colômbia");
    namesMap.put("CP", "Ilha de Clipperton");
    namesMap.put("CS", "Sérvia e Montenegro");
    namesMap.put("CV", "Cabo Verde");
    namesMap.put("CX", "Ilhas Natal");
    namesMap.put("CY", "Chipre");
    namesMap.put("CZ", "República Tcheca");
    namesMap.put("DE", "Alemanha");
    namesMap.put("DJ", "Djibuti");
    namesMap.put("DK", "Dinamarca");
    namesMap.put("DO", "República Dominicana");
    namesMap.put("DZ", "Argélia");
    namesMap.put("EA", "Ceuta e Melilha");
    namesMap.put("EC", "Equador");
    namesMap.put("EE", "Estônia");
    namesMap.put("EG", "Egito");
    namesMap.put("EH", "Saara Ocidental");
    namesMap.put("ER", "Eritreia");
    namesMap.put("ES", "Espanha");
    namesMap.put("ET", "Etiópia");
    namesMap.put("EU", "União Europeia");
    namesMap.put("FI", "Finlândia");
    namesMap.put("FK", "Ilhas Malvinas");
    namesMap.put("FM", "Micronésia");
    namesMap.put("FO", "Ilhas Faroe");
    namesMap.put("FR", "França");
    namesMap.put("GA", "Gabão");
    namesMap.put("GB", "Reino Unido");
    namesMap.put("GD", "Granada");
    namesMap.put("GE", "Geórgia");
    namesMap.put("GF", "Guiana Francesa");
    namesMap.put("GH", "Gana");
    namesMap.put("GL", "Groênlandia");
    namesMap.put("GM", "Gâmbia");
    namesMap.put("GN", "Guiné");
    namesMap.put("GP", "Guadalupe");
    namesMap.put("GQ", "Guiné Equatorial");
    namesMap.put("GR", "Grécia");
    namesMap.put("GS", "Geórgia do Sul e Ilhas Sandwich do Sul");
    namesMap.put("GW", "Guiné Bissau");
    namesMap.put("GY", "Guiana");
    namesMap.put("HM", "Ilha Heard e Ilhas McDonald");
    namesMap.put("HR", "Croácia");
    namesMap.put("HU", "Hungria");
    namesMap.put("IC", "Ilhas Canárias");
    namesMap.put("ID", "Indonésia");
    namesMap.put("IE", "Irlanda");
    namesMap.put("IM", "Ilha de Man");
    namesMap.put("IN", "Índia");
    namesMap.put("IO", "Território Britânico do Oceano Índico");
    namesMap.put("IQ", "Iraque");
    namesMap.put("IR", "Irã");
    namesMap.put("IS", "Islândia");
    namesMap.put("IT", "Itália");
    namesMap.put("JO", "Jordânia");
    namesMap.put("JP", "Japão");
    namesMap.put("KE", "Quênia");
    namesMap.put("KG", "Quirguistão");
    namesMap.put("KH", "Camboja");
    namesMap.put("KI", "Quiribati");
    namesMap.put("KM", "Comores");
    namesMap.put("KN", "São Cristovão e Nevis");
    namesMap.put("KP", "Coreia do Norte");
    namesMap.put("KR", "Coreia do Sul");
    namesMap.put("KY", "Ilhas Caiman");
    namesMap.put("KZ", "Casaquistão");
    namesMap.put("LA", "República Popular Democrática do Laos");
    namesMap.put("LB", "Líbano");
    namesMap.put("LC", "Santa Lúcia");
    namesMap.put("LR", "Libéria");
    namesMap.put("LS", "Lesoto");
    namesMap.put("LT", "Lituânia");
    namesMap.put("LU", "Luxemburgo");
    namesMap.put("LV", "Letônia");
    namesMap.put("LY", "Líbia");
    namesMap.put("MA", "Marrocos");
    namesMap.put("MC", "Mônaco");
    namesMap.put("MD", "Moldávia");
    namesMap.put("MF", "São Martinho");
    namesMap.put("MH", "Ilhas Marshall");
    namesMap.put("MK", "Macedônia");
    namesMap.put("MM", "Mianmar [Birmânia]");
    namesMap.put("MN", "Mongólia");
    namesMap.put("MP", "Ilhas Marianas do Norte");
    namesMap.put("MQ", "Martinica");
    namesMap.put("MR", "Mauritânia");
    namesMap.put("MU", "Maurício");
    namesMap.put("MV", "Maldivas");
    namesMap.put("MX", "México");
    namesMap.put("MY", "Malásia");
    namesMap.put("MZ", "Moçambique");
    namesMap.put("NA", "Namíbia");
    namesMap.put("NC", "Nova Caledônia");
    namesMap.put("NE", "Níger");
    namesMap.put("NF", "Ilha Norfolk");
    namesMap.put("NG", "Nigéria");
    namesMap.put("NI", "Nicarágua");
    namesMap.put("NL", "Holanda");
    namesMap.put("NO", "Noruega");
    namesMap.put("NZ", "Nova Zelândia");
    namesMap.put("OM", "Omã");
    namesMap.put("PA", "Panamá");
    namesMap.put("PF", "Polinésia Francesa");
    namesMap.put("PG", "Papua-Nova Guiné");
    namesMap.put("PH", "Filipinas");
    namesMap.put("PK", "Paquistão");
    namesMap.put("PL", "Polônia");
    namesMap.put("PM", "Saint Pierre e Miquelon");
    namesMap.put("PN", "Pitcairn");
    namesMap.put("PR", "Porto Rico");
    namesMap.put("PS", "Territórios palestinos");
    namesMap.put("PY", "Paraguai");
    namesMap.put("QA", "Catar");
    namesMap.put("QO", "Oceania Remota");
    namesMap.put("RE", "Reunião");
    namesMap.put("RO", "Romênia");
    namesMap.put("RS", "Sérvia");
    namesMap.put("RU", "Rússia");
    namesMap.put("RW", "Ruanda");
    namesMap.put("SA", "Arábia Saudita");
    namesMap.put("SB", "Ilhas Salomão");
    namesMap.put("SD", "Sudão");
    namesMap.put("SE", "Suécia");
    namesMap.put("SG", "Cingapura");
    namesMap.put("SH", "Santa Helena");
    namesMap.put("SI", "Eslovênia");
    namesMap.put("SJ", "Svalbard e Jan Mayen");
    namesMap.put("SK", "Eslováquia");
    namesMap.put("SL", "Serra Leoa");
    namesMap.put("SO", "Somália");
    namesMap.put("ST", "São Tomé e Príncipe");
    namesMap.put("SY", "Síria");
    namesMap.put("SZ", "Suazilândia");
    namesMap.put("TA", "Tristão da Cunha");
    namesMap.put("TC", "Ilhas Turks e Caicos");
    namesMap.put("TD", "Chade");
    namesMap.put("TF", "Territórios Franceses do Sul");
    namesMap.put("TH", "Tailândia");
    namesMap.put("TJ", "Tadjiquistão");
    namesMap.put("TM", "Turcomenistão");
    namesMap.put("TN", "Tunísia");
    namesMap.put("TR", "Turquia");
    namesMap.put("TT", "Trinidad e Tobago");
    namesMap.put("TZ", "Tanzânia");
    namesMap.put("UA", "Ucrânia");
    namesMap.put("UM", "Ilhas Menores Distantes dos Estados Unidos");
    namesMap.put("US", "Estados Unidos");
    namesMap.put("UY", "Uruguai");
    namesMap.put("UZ", "Uzbequistão");
    namesMap.put("VA", "Vaticano");
    namesMap.put("VC", "São Vicente e Granadinas");
    namesMap.put("VG", "Ilhas Virgens Britânicas");
    namesMap.put("VI", "Ilhas Virgens dos EUA");
    namesMap.put("VN", "Vietnã");
    namesMap.put("WF", "Wallis e Futuna");
    namesMap.put("YE", "Iêmen");
    namesMap.put("ZA", "África do Sul");
    namesMap.put("ZM", "Zâmbia");
    namesMap.put("ZW", "Zimbábue");
    namesMap.put("ZZ", "Região desconhecida ou inválida");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Mundo",
        "002": "África",
        "003": "América do Norte",
        "005": "América do Sul",
        "011": "África Ocidental",
        "013": "América Central",
        "014": "África Oriental",
        "015": "África do Norte",
        "017": "África Central",
        "018": "África Austral",
        "019": "Américas",
        "021": "América Setentrional",
        "029": "Caribe",
        "030": "Ásia Oriental",
        "034": "Ásia do Sul",
        "035": "Ásia Centro-Oriental",
        "039": "Europa do Sul",
        "053": "Austrália e Nova Zelândia",
        "054": "Melanésia",
        "057": "Região da Micronésia",
        "061": "Polinésia",
        "062": "Ásia Centro-Meridional",
        "142": "Ásia",
        "143": "Ásia Central",
        "145": "Ásia Ocidental",
        "150": "Europa",
        "151": "Europa Oriental",
        "154": "Europa Setentrional",
        "155": "Europa Ocidental",
        "172": "Comunidade dos Estados Independentes",
        "419": "América Latina e Caribe",
        "AC": "Ilha de Ascensão",
        "AE": "Emirados Árabes Unidos",
        "AF": "Afeganistão",
        "AG": "Antígua e Barbuda",
        "AL": "Albânia",
        "AM": "Armênia",
        "AN": "Antilhas Holandesas",
        "AQ": "Antártida",
        "AS": "Samoa Americana",
        "AT": "Áustria",
        "AU": "Austrália",
        "AX": "Ilhas Aland",
        "AZ": "Azerbaijão",
        "BA": "Bósnia-Herzegovina",
        "BE": "Bélgica",
        "BF": "Burquina Faso",
        "BG": "Bulgária",
        "BL": "São Bartolomeu",
        "BM": "Bermudas",
        "BO": "Bolívia",
        "BR": "Brasil",
        "BT": "Butão",
        "BV": "Ilha Bouvet",
        "BW": "Botsuana",
        "CA": "Canadá",
        "CC": "Ilhas Coco",
        "CD": "Congo-Kinshasa",
        "CF": "República Centro-Africana",
        "CG": "Congo - Brazzaville",
        "CH": "Suíça",
        "CI": "Costa do Marfim",
        "CK": "Ilhas Cook",
        "CM": "República dos Camarões",
        "CO": "Colômbia",
        "CP": "Ilha de Clipperton",
        "CS": "Sérvia e Montenegro",
        "CV": "Cabo Verde",
        "CX": "Ilhas Natal",
        "CY": "Chipre",
        "CZ": "República Tcheca",
        "DE": "Alemanha",
        "DJ": "Djibuti",
        "DK": "Dinamarca",
        "DO": "República Dominicana",
        "DZ": "Argélia",
        "EA": "Ceuta e Melilha",
        "EC": "Equador",
        "EE": "Estônia",
        "EG": "Egito",
        "EH": "Saara Ocidental",
        "ER": "Eritreia",
        "ES": "Espanha",
        "ET": "Etiópia",
        "EU": "União Europeia",
        "FI": "Finlândia",
        "FK": "Ilhas Malvinas",
        "FM": "Micronésia",
        "FO": "Ilhas Faroe",
        "FR": "França",
        "GA": "Gabão",
        "GB": "Reino Unido",
        "GD": "Granada",
        "GE": "Geórgia",
        "GF": "Guiana Francesa",
        "GH": "Gana",
        "GL": "Groênlandia",
        "GM": "Gâmbia",
        "GN": "Guiné",
        "GP": "Guadalupe",
        "GQ": "Guiné Equatorial",
        "GR": "Grécia",
        "GS": "Geórgia do Sul e Ilhas Sandwich do Sul",
        "GW": "Guiné Bissau",
        "GY": "Guiana",
        "HM": "Ilha Heard e Ilhas McDonald",
        "HR": "Croácia",
        "HU": "Hungria",
        "IC": "Ilhas Canárias",
        "ID": "Indonésia",
        "IE": "Irlanda",
        "IM": "Ilha de Man",
        "IN": "Índia",
        "IO": "Território Britânico do Oceano Índico",
        "IQ": "Iraque",
        "IR": "Irã",
        "IS": "Islândia",
        "IT": "Itália",
        "JO": "Jordânia",
        "JP": "Japão",
        "KE": "Quênia",
        "KG": "Quirguistão",
        "KH": "Camboja",
        "KI": "Quiribati",
        "KM": "Comores",
        "KN": "São Cristovão e Nevis",
        "KP": "Coreia do Norte",
        "KR": "Coreia do Sul",
        "KY": "Ilhas Caiman",
        "KZ": "Casaquistão",
        "LA": "República Popular Democrática do Laos",
        "LB": "Líbano",
        "LC": "Santa Lúcia",
        "LR": "Libéria",
        "LS": "Lesoto",
        "LT": "Lituânia",
        "LU": "Luxemburgo",
        "LV": "Letônia",
        "LY": "Líbia",
        "MA": "Marrocos",
        "MC": "Mônaco",
        "MD": "Moldávia",
        "MF": "São Martinho",
        "MH": "Ilhas Marshall",
        "MK": "Macedônia",
        "MM": "Mianmar [Birmânia]",
        "MN": "Mongólia",
        "MP": "Ilhas Marianas do Norte",
        "MQ": "Martinica",
        "MR": "Mauritânia",
        "MU": "Maurício",
        "MV": "Maldivas",
        "MX": "México",
        "MY": "Malásia",
        "MZ": "Moçambique",
        "NA": "Namíbia",
        "NC": "Nova Caledônia",
        "NE": "Níger",
        "NF": "Ilha Norfolk",
        "NG": "Nigéria",
        "NI": "Nicarágua",
        "NL": "Holanda",
        "NO": "Noruega",
        "NZ": "Nova Zelândia",
        "OM": "Omã",
        "PA": "Panamá",
        "PF": "Polinésia Francesa",
        "PG": "Papua-Nova Guiné",
        "PH": "Filipinas",
        "PK": "Paquistão",
        "PL": "Polônia",
        "PM": "Saint Pierre e Miquelon",
        "PN": "Pitcairn",
        "PR": "Porto Rico",
        "PS": "Territórios palestinos",
        "PY": "Paraguai",
        "QA": "Catar",
        "QO": "Oceania Remota",
        "RE": "Reunião",
        "RO": "Romênia",
        "RS": "Sérvia",
        "RU": "Rússia",
        "RW": "Ruanda",
        "SA": "Arábia Saudita",
        "SB": "Ilhas Salomão",
        "SD": "Sudão",
        "SE": "Suécia",
        "SG": "Cingapura",
        "SH": "Santa Helena",
        "SI": "Eslovênia",
        "SJ": "Svalbard e Jan Mayen",
        "SK": "Eslováquia",
        "SL": "Serra Leoa",
        "SO": "Somália",
        "ST": "São Tomé e Príncipe",
        "SY": "Síria",
        "SZ": "Suazilândia",
        "TA": "Tristão da Cunha",
        "TC": "Ilhas Turks e Caicos",
        "TD": "Chade",
        "TF": "Territórios Franceses do Sul",
        "TH": "Tailândia",
        "TJ": "Tadjiquistão",
        "TM": "Turcomenistão",
        "TN": "Tunísia",
        "TR": "Turquia",
        "TT": "Trinidad e Tobago",
        "TZ": "Tanzânia",
        "UA": "Ucrânia",
        "UM": "Ilhas Menores Distantes dos Estados Unidos",
        "US": "Estados Unidos",
        "UY": "Uruguai",
        "UZ": "Uzbequistão",
        "VA": "Vaticano",
        "VC": "São Vicente e Granadinas",
        "VG": "Ilhas Virgens Britânicas",
        "VI": "Ilhas Virgens dos EUA",
        "VN": "Vietnã",
        "WF": "Wallis e Futuna",
        "YE": "Iêmen",
        "ZA": "África do Sul",
        "ZM": "Zâmbia",
        "ZW": "Zimbábue",
        "ZZ": "Região desconhecida ou inválida"
    };
  }-*/;
}
